//
//  SMACustomCSMAdapterExample.m
//  SmaatoSDKAdapters
//
//  Created by Smaato Inc on 20.12.18.
//  Copyright © 2018 Smaato Inc. All rights reserved.￼
//  Licensed under the Smaato SDK License Agreement￼
//  https://www.smaato.com/sdk-license-agreement/
//

#import <SmaatoSDKCore/SMACSMBannerPlugin.h>
#import "SMACustomCSMBannerAdapter.h"
#if __has_include("MoPub/MoPub.h")
#import "MoPub/MoPub.h"
#else
#import <mopub-ios-sdk/MoPub.h>
#endif

@interface SMACustomCSMBannerAdapterPlugin : SMACSMBannerPlugin

@end

@implementation SMACustomCSMBannerAdapterPlugin

+ (void)load
{
    [SMACSMAdapterPlugin registerAdapterClass:self];
}

- (NSDictionary<NSString *, NSString *> *)extraParameters
{
    return [super extraParameters];
}

@end

@interface SMACustomCSMBannerAdapter () <MPAdViewDelegate>

@property (nonatomic) MPAdView *adView;

@end

@implementation SMACustomCSMBannerAdapter

@synthesize delegate;

- (void)requestBannerAdWithSize:(CGSize)adSize
                     customData:(NSDictionary *)customData
                   objectExtras:(NSDictionary *)objectExtras;
{
    NSString *adUnitId = customData[@"adunitid"];
    if (!adUnitId) {
        return;
    }

    // Create MoPub ad view
    self.adView = [[MPAdView alloc] initWithAdUnitId:adUnitId];
    self.adView.delegate = self;
    self.adView.frame = CGRectMake(0, 0, adSize.width, adSize.height);

    // Load ad
    [self.adView loadAdWithMaxAdSize:adSize];
}

#pragma mark - MPAdViewDelegate methods

- (void)adViewDidLoadAd:(MPAdView *)view adSize:(CGSize)adSize
{
    [self.delegate bannerDidLoad:view];
}

- (void)adView:(MPAdView *)view didFailToLoadAdWithError:(NSError *)error
{
    [self.delegate bannerDidFailWithError:error];
}

- (void)willPresentModalViewForAd:(MPAdView *)view
{
    [self.delegate bannerWillPresentModalContent];
}

- (void)didDismissModalViewForAd:(MPAdView *)view
{
    [self.delegate bannerDidDismissModalContent];
}

- (void)willLeaveApplicationFromAd:(MPAdView *)view
{
    [self.delegate bannerWillLeaveApplication];
}

- (UIViewController *)viewControllerForPresentingModalView
{
    return [self.delegate presentingViewController];
}

@end
