//
//  SMACustomCSMInterstitialAdapter.m
//  SmaatoSDKAdapters
//
//  Created by Smaato Inc on 20.12.18.
//  Copyright © 2018 Smaato Inc. All rights reserved.￼
//  Licensed under the Smaato SDK License Agreement￼
//  https://www.smaato.com/sdk-license-agreement/
//

#import <SmaatoSDKCore/SMACSMInterstitialPlugin.h>
#import "SMACustomCSMInterstitialAdapter.h"
#if __has_include("MoPub/MoPub.h")
#import "MoPub/MoPub.h"
#else
#import <mopub-ios-sdk/MoPub.h>
#endif

@interface SMACustomCSMInterstitialAdapterPlugin : SMACSMInterstitialPlugin

@end

@implementation SMACustomCSMInterstitialAdapterPlugin

+ (void)load
{
    [SMACSMAdapterPlugin registerAdapterClass:self];
}

- (NSDictionary<NSString *, NSString *> *)extraParameters
{
    return [super extraParameters];
}

@end

@interface SMACustomCSMInterstitialAdapter () <MPInterstitialAdControllerDelegate>

@property (nonatomic) MPInterstitialAdController *interstitial;

@end

@implementation SMACustomCSMInterstitialAdapter

@synthesize delegate;

#pragma mark - SMAInterstitialNetworkEvent methods

- (void)requestInterstitialAdWithCustomData:(NSDictionary *)customData
                               objectExtras:(NSDictionary *)objectExtras;
{
    NSString *adUnitId = customData[@"adunitid"];
    if (!adUnitId) {
        return;
    }

    self.interstitial = [MPInterstitialAdController interstitialAdControllerForAdUnitId:adUnitId];
    self.interstitial.delegate = self;
    [self.interstitial loadAd];
}

- (void)showInterstitialFromViewController:(UIViewController *)viewController
{
    if (self.interstitial.ready) {
        [self.interstitial showFromViewController:viewController];
    }
}

#pragma mark - MPInterstitialAdControllerDelegate methods

- (void)interstitialDidLoadAd:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialDidLoad];
}

- (void)interstitialDidFailToLoadAd:(MPInterstitialAdController *)interstitial
{
    NSString *description = @"MoPub interstitial did fail to load ad.";
    NSDictionary *userInfo = @{ NSLocalizedDescriptionKey : description, NSLocalizedFailureReasonErrorKey : description };
    NSError *error = [NSError errorWithDomain:@"com.smaaato.SMAMoPubCSMInterstitialAdapter" code:0 userInfo:userInfo];

    [self.delegate interstitialDidFailWithError:error];
}

- (void)interstitialDidFailToLoadAd:(MPInterstitialAdController *)interstitial withError:(NSError *)error
{
    [self.delegate interstitialDidFailWithError:error];
}

- (void)interstitialWillAppear:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialWillAppear];
}

- (void)interstitialDidAppear:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialDidAppear];
}

- (void)interstitialWillDisappear:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialWillDisappear];
}

- (void)interstitialDidDisappear:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialDidDisappear];
}

- (void)interstitialDidExpire:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialDidExpire];
}

- (void)interstitialDidReceiveTapEvent:(MPInterstitialAdController *)interstitial
{
    [self.delegate interstitialDidClick];
}

@end
