//
//  SMACustomCSMRewardedAdapter.m
//  SmaatoSDKAdapters
//
//  Created by Smaato Inc on 20.12.18.
//  Copyright © 2018 Smaato Inc. All rights reserved.￼
//  Licensed under the Smaato SDK License Agreement￼
//  https://www.smaato.com/sdk-license-agreement/
//

#import <SmaatoSDKCore/SMACSMRewardedPlugin.h>
#import "SMACustomCSMRewardedAdapter.h"
#if __has_include("MoPub/MoPub.h")
#import "MoPub/MoPub.h"
#else
#import <mopub-ios-sdk/MoPub.h>
#endif

@interface SMACustomCSMRewardedAdapterPlugin : SMACSMRewardedPlugin

@end

@implementation SMACustomCSMRewardedAdapterPlugin

+ (void)load
{
    [SMACSMAdapterPlugin registerAdapterClass:self];
}

- (NSDictionary<NSString *, NSString *> *)extraParameters
{
    return [super extraParameters];
}

@end

@interface SMACustomCSMRewardedAdapter () <MPRewardedVideoDelegate>

@property (nonatomic, copy) NSString *adUnitId;

@end

@implementation SMACustomCSMRewardedAdapter

@synthesize delegate;

#pragma mark - SMARewardedNetworkEvent methods

- (void)requestRewardedAdWithCustomData:(NSDictionary *)customData
                           objectExtras:(NSDictionary *)objectExtras;
{
    NSString *adUnitId = customData[@"adunitid"];
    if (!adUnitId) {
        return;
    }

    self.adUnitId = adUnitId;

    [MPRewardedVideo loadRewardedVideoAdWithAdUnitID:self.adUnitId withMediationSettings:@[]];
    [MPRewardedVideo setDelegate:self forAdUnitId:self.adUnitId];
}

- (void)showRewardedAdFromViewController:(UIViewController *)viewController
{
    if ([MPRewardedVideo hasAdAvailableForAdUnitID:self.adUnitId]) {
        MPRewardedVideoReward *rewardedVieo = [MPRewardedVideo availableRewardsForAdUnitID:self.adUnitId].firstObject;
        [MPRewardedVideo presentRewardedVideoAdForAdUnitID:self.adUnitId fromViewController:viewController withReward:rewardedVieo];
    }
}

#pragma mark - MPRewardedVideoDelegate methods

- (void)rewardedVideoAdDidLoadForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdDidLoad];
}

- (void)rewardedVideoAdDidFailToLoadForAdUnitID:(NSString *)adUnitID error:(NSError *)error
{
    [self.delegate rewardedAdDidFailWithError:error];
}

- (void)rewardedVideoAdDidFailToPlayForAdUnitID:(NSString *)adUnitID error:(NSError *)error
{
    [self.delegate rewardedAdDidFailToPresentWithError:error.localizedDescription];
}

- (void)rewardedVideoAdWillAppearForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdWillAppear];
}

- (void)rewardedVideoAdDidAppearForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdDidAppear];
}

- (void)rewardedVideoAdWillDisappearForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdWillDisappear];
}

- (void)rewardedVideoAdDidDisappearForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdDidDisappear];
}

- (void)rewardedVideoAdDidReceiveTapEventForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdDidClick];
}

- (void)rewardedVideoAdWillLeaveApplicationForAdUnitID:(NSString *)adUnitID
{
    [self.delegate rewardedAdWillLeaveApplication];
}

- (void)rewardedVideoAdShouldRewardForAdUnitID:(NSString *)adUnitID reward:(MPRewardedVideoReward *)reward
{
    [self.delegate rewardedAdDidReward];
}

@end
