/*
 * Decompiled with CFR 0.152.
 */
package boxresin.library.javahttp;

import boxresin.library.javahttp.HttpResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class HttpRequester {
    @NotNull
    private String url = "";
    @NotNull
    private String method = "";
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> params = new TreeMap<String, String>();
    private Map<String, String> headers = new TreeMap<String, String>();

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public HttpRequester setUrl(@NotNull String url) {
        this.url = url;
        return this;
    }

    @NotNull
    public HttpRequester setUrl(@NotNull String url, @NotNull Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (queryString.length() != 0) {
                queryString.append('&');
            }
            String encodedKey = URLEncoder.encode(entry.getKey(), "UTF-8");
            String encodedValue = URLEncoder.encode(entry.getValue(), "UTF-8");
            queryString.append(encodedKey);
            queryString.append('=');
            queryString.append(encodedValue);
        }
        return this.setUrl(url + '?' + queryString.toString());
    }

    @NotNull
    public String getMethod() {
        return this.method;
    }

    @NotNull
    public HttpRequester setMethod(@NotNull String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @NotNull
    public HttpRequester setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @NotNull
    public HttpRequester setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    @NotNull
    public HttpRequester addParameter(@NotNull String key, @NotNull String value) {
        this.params.put(key, value);
        return this;
    }

    @NotNull
    public HttpRequester addParameters(@NotNull Map<String, String> params) {
        this.params.putAll(params);
        return this;
    }

    public void clearParameters() {
        this.params.clear();
    }

    @NotNull
    public HttpRequester addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @NotNull
    public HttpRequester addHeaders(@NotNull Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    @NotNull
    public HttpResponse request() throws SocketTimeoutException, IOException {
        int length;
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod(this.method);
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.method.equals("POST")) {
            connection.setDoOutput(true);
            boolean isNotFirst = false;
            OutputStream out = connection.getOutputStream();
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (isNotFirst) {
                    out.write("&".getBytes());
                } else {
                    isNotFirst = true;
                }
                out.write(String.format("%s=%s", key, value).getBytes());
            }
        }
        connection.connect();
        int statusCode = connection.getResponseCode();
        String statusMessage = connection.getResponseMessage();
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream(10240);
        byte[] buffer = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        while ((length = ((InputStream)in).read(buffer)) != -1) {
            bufferStream.write(buffer, 0, length);
        }
        connection.disconnect();
        return new HttpResponse(statusCode, statusMessage, bufferStream, connection);
    }

    @NotNull
    public HttpResponse request(boolean autoRedirection) throws SocketTimeoutException, IOException {
        HttpResponse response = this.request();
        String newUrl = response.getHeader("Location");
        if (autoRedirection && newUrl != null) {
            this.setUrl(newUrl);
            return this.request(true);
        }
        return response;
    }
}

