/*
 * Decompiled with CFR 0.152.
 */
package boxresin.library.javahttp;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpResponse {
    private int statusCode;
    @NotNull
    private String statusMessage;
    @NotNull
    private ByteArrayOutputStream bodyStream;
    @NotNull
    private HttpURLConnection connection;

    HttpResponse(int statusCode, @NotNull String statusMessage, @NotNull ByteArrayOutputStream bodyStream, @NotNull HttpURLConnection connection) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.bodyStream = bodyStream;
        this.connection = connection;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public String getHeader(String key) {
        return this.connection.getHeaderField(key);
    }

    @NotNull
    public Map<String, List<String>> getHeaders() {
        return this.connection.getHeaderFields();
    }

    @NotNull
    public String getBody() {
        try {
            String encoding = this.getBodyEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            return this.bodyStream.toString(encoding);
        }
        catch (Exception e) {
            return this.bodyStream.toString();
        }
    }

    @NotNull
    public String getBody(@NotNull String encoding) throws UnsupportedEncodingException {
        return this.bodyStream.toString(encoding);
    }

    @NotNull
    public byte[] getBodyAsByteArray() {
        return this.bodyStream.toByteArray();
    }

    @Nullable
    public String getBodyEncoding() {
        try {
            String[] params;
            String contentType = this.getHeader("Content-Type");
            for (String param : params = contentType.split(";")) {
                if (!(param = param.trim()).startsWith("charset=")) continue;
                return param.replace("charset=", "").toUpperCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

