/*
 * Decompiled with CFR 0.152.
 */
package cn.okayj.util.lineartree;

import cn.okayj.util.lineartree.DataNode;
import java.util.LinkedList;
import java.util.List;

public class NodeFlatIndex {
    private boolean mInvalidated = false;
    private boolean mIgnoreRoot = false;
    private DataNode mRootNode;
    private List<DataNode> mList = new LinkedList<DataNode>();
    private List<DataNode> mVisibleList;
    private VisibleFlatIndex mVisibleFlatIndex = new VisibleFlatIndex();

    NodeFlatIndex(DataNode rootNode) {
        this.mRootNode = rootNode;
        this.addSubtree(0, 0, rootNode, this.mVisibleList != null);
    }

    public void invalidate() {
        this.mRootNode.invalidateFlatIndex();
        this.mRootNode = null;
        this.mList.clear();
        if (this.mVisibleList != null) {
            this.mVisibleList.clear();
            this.mVisibleList = null;
        }
        this.mInvalidated = true;
    }

    public DataNode get(int position) {
        if (this.mIgnoreRoot) {
            int pos = position + 1;
            return this.mList.get(pos);
        }
        return this.mList.get(position);
    }

    public int indexOf(DataNode dataNode) {
        int index = this.mList.indexOf(dataNode);
        if (this.mIgnoreRoot) {
            return index - 1;
        }
        return index;
    }

    public int size() {
        if (this.mIgnoreRoot) {
            assert (this.mList.size() > 0);
            return this.mList.size() - 1;
        }
        return this.mList.size();
    }

    public VisibleFlatIndex getVisibleIndex() {
        if (this.mInvalidated) {
            throw new RuntimeException("NodeFlatIndex is invalidated !!!");
        }
        if (this.mVisibleList == null) {
            this.mVisibleList = new LinkedList<DataNode>();
            if (this.mRootNode.isVisible()) {
                this.addSubtreeToVisibleList(0, this.mRootNode, true);
            }
        }
        return this.mVisibleFlatIndex;
    }

    public void ignoreRoot(boolean ignoreRoot) {
        this.mIgnoreRoot = ignoreRoot;
    }

    public boolean isIgnoreRoot() {
        return this.mIgnoreRoot;
    }

    void addSubtree(DataNode preSibling, DataNode preVisibleSibling, DataNode subtree) {
        int basePosition = this.getBasePosition(preSibling, subtree);
        int baseVisibleListPosition = 0;
        boolean addToVisibleList = false;
        baseVisibleListPosition = this.getVisibleBasePosition(preVisibleSibling, subtree);
        if (this.mVisibleList != null && subtree.isVisible() && baseVisibleListPosition >= 0) {
            addToVisibleList = true;
        }
        this.addSubtree(basePosition, baseVisibleListPosition, subtree, addToVisibleList);
    }

    void removeFlatNodes(DataNode dataNode) {
        int visiblePosition;
        int position = this.mList.indexOf(dataNode);
        assert (position >= 0);
        if (position >= 0) {
            for (int i = 0; i < dataNode.getFlatSize(); ++i) {
                try {
                    this.mList.remove(position);
                    continue;
                }
                catch (IndexOutOfBoundsException throwable) {
                    throw new RuntimeException("\u7d22\u5f15\u72b6\u6001\u4e0d\u6b63\u786e,\u8282\u70b9\u6811\u65e0\u6cd5\u5b8c\u5168\u4ece\u7d22\u5f15\u5220\u9664,bug??", throwable);
                }
            }
        }
        if (this.mVisibleList != null && dataNode.isVisible() && (visiblePosition = this.mVisibleList.indexOf(dataNode)) > 0) {
            for (int i = 0; i < dataNode.getVisibleFlatSize(); ++i) {
                this.mVisibleList.remove(visiblePosition);
            }
        }
    }

    void onNodeVisibilityChange(DataNode preVisibleCousinDataNode, DataNode dataNode, boolean currentVisibility) {
        if (this.mVisibleList == null) {
            return;
        }
        if (currentVisibility) {
            int basePosition = this.getVisibleBasePosition(preVisibleCousinDataNode, dataNode);
            if (basePosition >= 0) {
                this.addSubtreeToVisibleList(basePosition, dataNode, true);
            }
        } else {
            int sizeToRemove = DataNode.calculateVisibleFlatSize(!currentVisibility, dataNode.isFold(), dataNode.getDescendantVisibleSize());
            this.removeFlattedNodesFromVisibleList(dataNode, sizeToRemove, true);
        }
    }

    void onNodeFoldStateChange(DataNode dataNode, boolean currentFolded) {
        if (this.mVisibleList == null) {
            return;
        }
        if (!dataNode.isVisible()) {
            return;
        }
        int visibleFlatSizeToRemove = DataNode.calculateVisibleFlatSize(dataNode.isVisible(), !currentFolded, dataNode.getDescendantVisibleSize());
        if (currentFolded) {
            this.removeFlattedNodesFromVisibleList(dataNode, visibleFlatSizeToRemove, false);
        } else {
            int basePosition = this.mVisibleList.indexOf(dataNode);
            if (basePosition >= 0) {
                this.addSubtreeToVisibleList(++basePosition, dataNode, false);
            }
        }
    }

    private void removeFlattedNodesFromVisibleList(DataNode dataNode, int size, boolean includeRootNode) {
        int basePosition = this.mVisibleList.indexOf(dataNode);
        if (basePosition < 0) {
            return;
        }
        if (!includeRootNode) {
            ++basePosition;
        }
        for (int i = 0; i < size; ++i) {
            this.mVisibleList.remove(basePosition);
        }
    }

    private int getVisibleBasePosition(DataNode preVisibleSibling, DataNode dataNode) {
        DataNode parentNode = dataNode.getParentNode();
        if (parentNode == null) {
            assert (preVisibleSibling == null);
            return 0;
        }
        int parentVisiblePosition = this.mVisibleList.indexOf(parentNode);
        if (parentVisiblePosition < 0) {
            return -1;
        }
        assert (this.mVisibleList.indexOf(preVisibleSibling) >= 0);
        return this.mVisibleList.indexOf(preVisibleSibling) + preVisibleSibling.getVisibleFlatSize();
    }

    private int getBasePosition(DataNode preCousinNode, DataNode dataNode) {
        DataNode parentNode = dataNode.getParentNode();
        if (preCousinNode == null) {
            if (parentNode == null) {
                assert (this.mList.size() == 0);
                return 0;
            }
            int parentPosition = this.mList.indexOf(dataNode.getParentNode());
            assert (parentPosition >= 0);
            return parentPosition + 1;
        }
        return this.mList.indexOf(preCousinNode) + preCousinNode.getFlatSize();
    }

    private void addSubtreeToVisibleList(int basePosition, DataNode rootNode, boolean includeRootNode) {
        boolean childAddToVisibleList;
        DataNode node;
        int i;
        if (includeRootNode) {
            this.mVisibleList.add(basePosition, rootNode);
            ++basePosition;
        }
        boolean childHasChanceToAddToVisibleList = !rootNode.isFold();
        for (i = 0; i < rootNode.getHeaderNodeSize(); ++i) {
            node = rootNode.getHeaderNode(i);
            boolean bl = childAddToVisibleList = childHasChanceToAddToVisibleList && node.isVisible();
            if (!childAddToVisibleList || !node.isVisible()) continue;
            this.addSubtreeToVisibleList(basePosition, node, true);
            basePosition += node.getVisibleFlatSize();
        }
        for (i = 0; i < rootNode.getChildNodeSize(); ++i) {
            node = rootNode.getChildNode(i);
            boolean bl = childAddToVisibleList = childHasChanceToAddToVisibleList && node.isVisible();
            if (!childAddToVisibleList || !node.isVisible()) continue;
            this.addSubtreeToVisibleList(basePosition, node, true);
            basePosition += node.getVisibleFlatSize();
        }
        for (i = 0; i < rootNode.getFooterNodeSize(); ++i) {
            node = rootNode.getFooterNode(i);
            boolean bl = childAddToVisibleList = childHasChanceToAddToVisibleList && node.isVisible();
            if (!childAddToVisibleList || !node.isVisible()) continue;
            this.addSubtreeToVisibleList(basePosition, node, true);
            basePosition += node.getVisibleFlatSize();
        }
    }

    private void addSubtree(int basePosition, int baseVisiblePosition, DataNode subtree, boolean addToVisibleList) {
        boolean childAddToVisibleList;
        DataNode node;
        int i;
        this.mList.add(basePosition, subtree);
        ++basePosition;
        if (addToVisibleList) {
            this.mVisibleList.add(baseVisiblePosition, subtree);
            ++baseVisiblePosition;
        }
        boolean childHasChanceToAddToVisibleList = addToVisibleList && subtree.isVisible() && !subtree.isFold();
        for (i = 0; i < subtree.getHeaderNodeSize(); ++i) {
            node = subtree.getHeaderNode(i);
            childAddToVisibleList = childHasChanceToAddToVisibleList && node.isVisible();
            this.addSubtree(basePosition, baseVisiblePosition, node, childAddToVisibleList);
            basePosition += node.getFlatSize();
            if (!childAddToVisibleList) continue;
            baseVisiblePosition += node.getVisibleFlatSize();
        }
        for (i = 0; i < subtree.getChildNodeSize(); ++i) {
            node = subtree.getChildNode(i);
            childAddToVisibleList = childHasChanceToAddToVisibleList && node.isVisible();
            this.addSubtree(basePosition, baseVisiblePosition, node, childAddToVisibleList);
            basePosition += node.getFlatSize();
            if (!childAddToVisibleList) continue;
            baseVisiblePosition += node.getVisibleFlatSize();
        }
        for (i = 0; i < subtree.getFooterNodeSize(); ++i) {
            node = subtree.getFooterNode(i);
            childAddToVisibleList = childHasChanceToAddToVisibleList && node.isVisible();
            this.addSubtree(basePosition, baseVisiblePosition, node, childAddToVisibleList);
            basePosition += node.getFlatSize();
            if (!childAddToVisibleList) continue;
            baseVisiblePosition += node.getVisibleFlatSize();
        }
    }

    public class VisibleFlatIndex {
        private VisibleFlatIndex() {
        }

        public DataNode get(int position) {
            if (NodeFlatIndex.this.mIgnoreRoot && NodeFlatIndex.this.mVisibleList.get(0) == NodeFlatIndex.this.mRootNode) {
                return (DataNode)NodeFlatIndex.this.mVisibleList.get(position + 1);
            }
            return (DataNode)NodeFlatIndex.this.mVisibleList.get(position);
        }

        public int indexOf(DataNode dataNode) {
            int index = NodeFlatIndex.this.mVisibleList.indexOf(dataNode);
            if (NodeFlatIndex.this.mIgnoreRoot && NodeFlatIndex.this.mVisibleList.get(0) == NodeFlatIndex.this.mRootNode) {
                return index - 1;
            }
            return index;
        }

        public int size() {
            if (NodeFlatIndex.this.mIgnoreRoot && NodeFlatIndex.this.mVisibleList.get(0) == NodeFlatIndex.this.mRootNode) {
                return NodeFlatIndex.this.mVisibleList.size() - 1;
            }
            return NodeFlatIndex.this.mVisibleList.size();
        }

        public void invalidate() {
            NodeFlatIndex.this.mVisibleList.clear();
            NodeFlatIndex.this.mVisibleList = null;
        }
    }
}

