/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.webbridge;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.webkit.JavascriptInterface;
import com.adjust.sdk.Adjust;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookSDKJSInterface {
    private static final String PROTOCOL = "fbmq-0.1";
    private static final String PARAMETER_FBSDK_PIXEL_REFERRAL = "_fb_pixel_referral_id";
    private static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    private String fbPixelDefaultEventToken;
    private Map<String, String> fbPixelMapping = new HashMap<String, String>();

    private static Map<String, String> jsonStringToMap(String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            HashMap<String, String> stringMap = new HashMap<String, String>(jsonObject.length());
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = jsonObject.getString(key);
                stringMap.put(key, value);
            }
            return stringMap;
        }
        catch (JSONException ignored) {
            return new HashMap<String, String>();
        }
    }

    public static String getApplicationId(Context context) {
        String applicationId = null;
        ApplicationInfo ai = null;
        try {
            ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            AdjustFactory.getLogger().error("Error loading fb ApplicationInfo: %s", new Object[]{e.getMessage()});
            return null;
        }
        Object appId = ai.metaData.get(APPLICATION_ID_PROPERTY);
        if (appId instanceof String) {
            String appIdString = (String)appId;
            applicationId = appIdString.toLowerCase(Locale.ROOT).startsWith("fb") ? appIdString.substring(2) : appIdString;
        } else if (appId instanceof Integer) {
            AdjustFactory.getLogger().error("App Ids cannot be directly placed in the manifest.They must be prefixed by 'fb' or be placed in the string resource file.", new Object[0]);
        } else {
            AdjustFactory.getLogger().error("App Ids is not a string or integer", new Object[0]);
        }
        return applicationId;
    }

    public void setDefaultEventToken(String fbPixelDefaultEventToken) {
        this.fbPixelDefaultEventToken = fbPixelDefaultEventToken;
    }

    public void addFbPixelEventTokenMapping(String key, String value) {
        this.fbPixelMapping.put(key, value);
    }

    @JavascriptInterface
    public void sendEvent(String pixelId, String event_name, String jsonString) {
        if (pixelId == null) {
            AdjustFactory.getLogger().error("Can't bridge an event without a referral Pixel ID. Check your webview Pixel configuration", new Object[0]);
            return;
        }
        String eventToken = this.fbPixelMapping.get(event_name);
        if (eventToken == null) {
            AdjustFactory.getLogger().debug("No mapping found for the fb pixel event %s, trying to fall back to the default event token", new Object[]{event_name});
            eventToken = this.fbPixelDefaultEventToken;
        }
        if (eventToken == null) {
            AdjustFactory.getLogger().warn("There is not a default event token configured or a mapping found for event named: '%s'. It won't be tracked as an adjust event", new Object[]{event_name});
            return;
        }
        AdjustEvent fbPixelEvent = new AdjustEvent(eventToken);
        if (!fbPixelEvent.isValid()) {
            return;
        }
        Map<String, String> stringMap = FacebookSDKJSInterface.jsonStringToMap(jsonString);
        stringMap.put(PARAMETER_FBSDK_PIXEL_REFERRAL, pixelId);
        AdjustFactory.getLogger().debug("FB pixel event received, eventName: %s, payload: %s", new Object[]{event_name, stringMap});
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            String key = entry.getKey();
            fbPixelEvent.addPartnerParameter(key, entry.getValue());
        }
        Adjust.trackEvent((AdjustEvent)fbPixelEvent);
    }

    @JavascriptInterface
    public String getProtocol() {
        return PROTOCOL;
    }
}

