/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.util.Log;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.Logger;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class ActivityState
implements Serializable {
    private static final long serialVersionUID = 9039439291143138148L;
    protected String uuid = Util.createUuid();
    protected Boolean enabled = true;
    protected int eventCount = 0;
    protected int sessionCount = 0;
    protected int subsessionCount = -1;
    protected long sessionLength = -1L;
    protected long timeSpent = -1L;
    protected long lastActivity = -1L;
    protected long createdAt = -1L;
    protected long lastInterval = -1L;

    protected ActivityState() {
    }

    protected void resetSessionAttributes(long now) {
        this.subsessionCount = 1;
        this.sessionLength = 0L;
        this.timeSpent = 0L;
        this.lastActivity = now;
        this.createdAt = -1L;
        this.lastInterval = -1L;
    }

    protected void injectSessionAttributes(PackageBuilder builder) {
        this.injectGeneralAttributes(builder);
        builder.setLastInterval(this.lastInterval);
    }

    protected void injectEventAttributes(PackageBuilder builder) {
        this.injectGeneralAttributes(builder);
        builder.setEventCount(this.eventCount);
    }

    public String toString() {
        return String.format(Locale.US, "ec:%d sc:%d ssc:%d sl:%.1f ts:%.1f la:%s", this.eventCount, this.sessionCount, this.subsessionCount, (double)this.sessionLength / 1000.0, (double)this.timeSpent / 1000.0, ActivityState.stamp(this.lastActivity));
    }

    private void readObject(ObjectInputStream stream) throws NotActiveException, IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.eventCount = fields.get("eventCount", 0);
        this.sessionCount = fields.get("sessionCount", 0);
        this.subsessionCount = fields.get("subsessionCount", -1);
        this.sessionLength = fields.get("sessionLength", -1L);
        this.timeSpent = fields.get("timeSpent", -1L);
        this.lastActivity = fields.get("lastActivity", -1L);
        this.createdAt = fields.get("createdAt", -1L);
        this.lastInterval = fields.get("lastInterval", -1L);
        this.uuid = null;
        this.enabled = true;
        try {
            this.uuid = (String)fields.get("uuid", null);
            this.enabled = fields.get("enabled", true);
        }
        catch (Exception e) {
            Logger logger = AdjustFactory.getLogger();
            logger.debug("Unable to read new field in migration device with error (%s)", e.getMessage());
        }
        if (this.uuid == null) {
            this.uuid = Util.createUuid();
            Log.d((String)"XXX", (String)("migrate " + this.uuid));
        }
    }

    private static String stamp(long dateMillis) {
        Date date = new Date(dateMillis);
        return String.format(Locale.US, "%02d:%02d:%02d", date.getHours(), date.getMinutes(), date.getSeconds());
    }

    private void injectGeneralAttributes(PackageBuilder builder) {
        builder.setSessionCount(this.sessionCount);
        builder.setSubsessionCount(this.subsessionCount);
        builder.setSessionLength(this.sessionLength);
        builder.setTimeSpent(this.timeSpent);
        builder.setCreatedAt(this.createdAt);
        builder.setUuid(this.uuid);
    }
}

