/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class ReferrerReceiver
extends BroadcastReceiver {
    protected static final String REFERRER_KEY = "AdjustInstallReferrer";

    public void onReceive(Context context, Intent intent) {
        String referrer;
        String rawReferrer = intent.getStringExtra("referrer");
        if (null == rawReferrer) {
            return;
        }
        try {
            referrer = URLDecoder.decode(rawReferrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            referrer = "malformed";
        }
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        preferences.edit().putString(REFERRER_KEY, referrer).commit();
    }
}

