/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;

public class AdjustInstance {
    private String referrer;
    private long referrerClickTime;
    private ActivityHandler activityHandler;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public void onCreate(AdjustConfig adjustConfig) {
        if (this.activityHandler != null) {
            AdjustInstance.getLogger().error("Adjust already initialized", new Object[0]);
            return;
        }
        adjustConfig.referrer = this.referrer;
        adjustConfig.referrerClickTime = this.referrerClickTime;
        this.activityHandler = ActivityHandler.getInstance(adjustConfig);
    }

    public void trackEvent(AdjustEvent event) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.trackEvent(event);
    }

    public void onResume() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.trackSubsessionStart();
    }

    public void onPause() {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.trackSubsessionEnd();
    }

    public void setEnabled(boolean enabled) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.setEnabled(enabled);
    }

    public boolean isEnabled() {
        if (!this.checkActivityHandler()) {
            return false;
        }
        return this.activityHandler.isEnabled();
    }

    public void appWillOpenUrl(Uri url) {
        if (!this.checkActivityHandler()) {
            return;
        }
        long clickTime = System.currentTimeMillis();
        this.activityHandler.readOpenUrl(url, clickTime);
    }

    public void sendReferrer(String referrer) {
        long clickTime = System.currentTimeMillis();
        if (this.activityHandler == null) {
            this.referrer = referrer;
            this.referrerClickTime = clickTime;
        } else {
            this.activityHandler.sendReferrer(referrer, clickTime);
        }
    }

    public void setOfflineMode(boolean enabled) {
        if (!this.checkActivityHandler()) {
            return;
        }
        this.activityHandler.setOfflineMode(enabled);
    }

    private boolean checkActivityHandler() {
        if (this.activityHandler == null) {
            AdjustInstance.getLogger().error("Please initialize Adjust by calling 'onCreate' before", new Object[0]);
            return false;
        }
        return true;
    }
}

