/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import org.json.JSONArray;
import org.json.JSONException;

public class SharedPreferencesManager {
    private static final String PREFS_NAME = "adjust_preferences";
    private static final String PREFS_KEY_RAW_REFERRERS = "raw_referrers";
    private static final String PREFS_KEY_PUSH_TOKEN = "push_token";
    private static final String PREFS_KEY_INSTALL_TRACKED = "install_tracked";
    private static final int INDEX_RAW_REFERRER = 0;
    private static final int INDEX_CLICK_TIME = 1;
    private static final int INDEX_IS_SENDING = 2;
    private final SharedPreferences sharedPreferences;

    public SharedPreferencesManager(Context context) {
        this.sharedPreferences = context.getSharedPreferences(PREFS_NAME, 0);
    }

    public synchronized void saveRawReferrer(String rawReferrer, long clickTime) {
        try {
            JSONArray rawReferrerArray = this.getRawReferrerArray();
            if (this.getRawReferrer(rawReferrer, clickTime) != null) {
                return;
            }
            JSONArray newRawReferrer = new JSONArray();
            newRawReferrer.put(0, (Object)rawReferrer);
            newRawReferrer.put(1, clickTime);
            newRawReferrer.put(2, 0);
            rawReferrerArray.put((Object)newRawReferrer);
            this.saveRawReferrerArray(rawReferrerArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public synchronized void saveRawReferrerArray(JSONArray rawReferrerArray) {
        this.saveString(PREFS_KEY_RAW_REFERRERS, rawReferrerArray.toString());
    }

    public synchronized void removeRawReferrer(String rawReferrer, long clickTime) {
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }
        int rawReferrerIndex = this.getRawReferrerIndex(rawReferrer, clickTime);
        if (rawReferrerIndex < 0) {
            return;
        }
        JSONArray rawReferrerArray = this.getRawReferrerArray();
        JSONArray updatedReferrers = new JSONArray();
        for (int i = 0; i < rawReferrerArray.length(); ++i) {
            if (i == rawReferrerIndex) continue;
            try {
                updatedReferrers.put((Object)rawReferrerArray.getJSONArray(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.saveString(PREFS_KEY_RAW_REFERRERS, updatedReferrers.toString());
    }

    public synchronized JSONArray getRawReferrer(String rawReferrer, long clickTime) {
        int rawReferrerIndex = this.getRawReferrerIndex(rawReferrer, clickTime);
        if (rawReferrerIndex >= 0) {
            try {
                return this.getRawReferrerArray().getJSONArray(rawReferrerIndex);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized JSONArray getRawReferrerArray() {
        try {
            String referrerQueueString = this.getString(PREFS_KEY_RAW_REFERRERS);
            if (referrerQueueString != null) {
                return new JSONArray(referrerQueueString);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new JSONArray();
    }

    public synchronized void setSendingReferrersAsNotSent() {
        try {
            JSONArray rawReferrerArray = this.getRawReferrerArray();
            boolean hasRawReferrersBeenChanged = false;
            for (int i = 0; i < rawReferrerArray.length(); ++i) {
                JSONArray rawReferrer = rawReferrerArray.getJSONArray(i);
                int sendingStatus = rawReferrer.optInt(2, -1);
                if (sendingStatus != 1) continue;
                rawReferrer.put(2, 0);
                hasRawReferrersBeenChanged = true;
            }
            if (hasRawReferrersBeenChanged) {
                this.saveRawReferrerArray(rawReferrerArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private synchronized int getRawReferrerIndex(String rawReferrer, long clickTime) {
        try {
            JSONArray rawReferrers = this.getRawReferrerArray();
            for (int i = 0; i < rawReferrers.length(); ++i) {
                long savedClickTime;
                JSONArray savedRawReferrer = rawReferrers.getJSONArray(i);
                String savedRawReferrerString = savedRawReferrer.optString(0, null);
                if (savedRawReferrerString == null || !savedRawReferrerString.equals(rawReferrer) || (savedClickTime = savedRawReferrer.optLong(1, -1L)) != clickTime) continue;
                return i;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return -1;
    }

    public synchronized void savePushToken(String pushToken) {
        this.saveString(PREFS_KEY_PUSH_TOKEN, pushToken);
    }

    public synchronized String getPushToken() {
        return this.getString(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void removePushToken() {
        this.remove(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void setInstallTracked() {
        this.saveBoolean(PREFS_KEY_INSTALL_TRACKED, true);
    }

    public synchronized boolean getInstallTracked() {
        return this.getBoolean(PREFS_KEY_INSTALL_TRACKED, false);
    }

    public synchronized void clear() {
        this.sharedPreferences.edit().clear().apply();
    }

    private synchronized void saveString(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).apply();
    }

    private synchronized void saveBoolean(String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).apply();
    }

    private synchronized String getString(String key) {
        try {
            return this.sharedPreferences.getString(key, null);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private synchronized boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.sharedPreferences.getBoolean(key, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    private synchronized void remove(String key) {
        this.sharedPreferences.edit().remove(key).apply();
    }
}

