/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.plugin;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;

public class MacAddressUtil {
    public static String getMacAddress(Context context) {
        String rawAddress = MacAddressUtil.getRawMacAddress(context);
        if (rawAddress == null) {
            return null;
        }
        String upperAddress = rawAddress.toUpperCase(Locale.US);
        return MacAddressUtil.removeSpaceString(upperAddress);
    }

    private static String getRawMacAddress(Context context) {
        String wlanAddress = MacAddressUtil.loadAddress("wlan0");
        if (wlanAddress != null) {
            return wlanAddress;
        }
        String ethAddress = MacAddressUtil.loadAddress("eth0");
        if (ethAddress != null) {
            return ethAddress;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            String wifiAddress = wifiManager.getConnectionInfo().getMacAddress();
            if (wifiAddress != null) {
                return wifiAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String loadAddress(String interfaceName) {
        try {
            int numRead;
            String filePath = "/sys/class/net/" + interfaceName + "/address";
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(new FileReader(filePath), 1024);
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
            return fileData.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String removeSpaceString(String inputString) {
        if (inputString == null) {
            return null;
        }
        String outputString = inputString.replaceAll("\\s", "");
        if (TextUtils.isEmpty((CharSequence)outputString)) {
            return null;
        }
        return outputString;
    }
}

