/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.TimerOnce;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrer
implements InvocationHandler {
    private static final String PACKAGE_BASE_NAME = "com.android.installreferrer.";
    private static final int STATUS_SERVICE_DISCONNECTED = -1;
    private static final int STATUS_OK = 0;
    private static final int STATUS_SERVICE_UNAVAILABLE = 1;
    private static final int STATUS_FEATURE_NOT_SUPPORTED = 2;
    private static final int STATUS_DEVELOPER_ERROR = 3;
    private int retryWaitTime = 3000;
    private int retries;
    private final AtomicBoolean hasInstallReferrerBeenRead;
    private ILogger logger = AdjustFactory.getLogger();
    private Object referrerClient;
    private Context context;
    private TimerOnce retryTimer;
    private final InstallReferrerReadListener referrerCallback;
    private Object playInstallReferrer;

    public InstallReferrer(Context context, InstallReferrerReadListener referrerCallback) {
        this.playInstallReferrer = this.createInstallReferrer(context, referrerCallback, this.logger);
        this.context = context;
        this.hasInstallReferrerBeenRead = new AtomicBoolean(false);
        this.retries = 0;
        this.retryTimer = new TimerOnce(new Runnable(){

            @Override
            public void run() {
                InstallReferrer.this.startConnection();
            }
        }, "InstallReferrer");
        this.referrerCallback = referrerCallback;
    }

    private Object createInstallReferrer(Context context, InstallReferrerReadListener referrerCallback, ILogger logger) {
        return Reflection.createInstance("com.adjust.sdk.play.InstallReferrer", new Class[]{Context.class, InstallReferrerReadListener.class, ILogger.class}, context, referrerCallback, logger);
    }

    public void startConnection() {
        if (this.playInstallReferrer != null) {
            try {
                Reflection.invokeInstanceMethod(this.playInstallReferrer, "startConnection", null, new Object[0]);
                return;
            }
            catch (Exception e) {
                this.logger.error("Call to Play startConnection error: %s", e.getMessage());
            }
        }
        if (!AdjustFactory.getTryInstallReferrer()) {
            return;
        }
        this.closeReferrerClient();
        if (this.hasInstallReferrerBeenRead.get()) {
            this.logger.debug("Install referrer has already been read", new Object[0]);
            return;
        }
        if (this.context == null) {
            return;
        }
        this.referrerClient = this.createInstallReferrerClient(this.context);
        if (this.referrerClient == null) {
            return;
        }
        Class listenerClass = this.getInstallReferrerStateListenerClass();
        if (listenerClass == null) {
            return;
        }
        Object listenerProxy = this.createProxyInstallReferrerStateListener(listenerClass);
        if (listenerProxy == null) {
            return;
        }
        this.startConnection(listenerClass, listenerProxy);
    }

    private Object createInstallReferrerClient(Context context) {
        try {
            Object builder = Reflection.invokeStaticMethod("com.android.installreferrer.api.InstallReferrerClient", "newBuilder", new Class[]{Context.class}, context);
            return Reflection.invokeInstanceMethod(builder, "build", null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            this.logger.warn("InstallReferrer not integrated in project (%s) thrown by (%s)", ex.getMessage(), ex.getClass().getCanonicalName());
        }
        catch (Exception ex) {
            this.logger.error("createInstallReferrerClient error (%s) from (%s)", ex.getMessage(), ex.getClass().getCanonicalName());
        }
        return null;
    }

    private Class getInstallReferrerStateListenerClass() {
        try {
            return Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
        }
        catch (Exception ex) {
            this.logger.error("getInstallReferrerStateListenerClass error (%s) from (%s)", ex.getMessage(), ex.getClass().getCanonicalName());
            return null;
        }
    }

    private Object createProxyInstallReferrerStateListener(Class installReferrerStateListenerClass) {
        Object proxyInstance = null;
        try {
            proxyInstance = Proxy.newProxyInstance(installReferrerStateListenerClass.getClassLoader(), new Class[]{installReferrerStateListenerClass}, (InvocationHandler)this);
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("InstallReferrer proxy violating parameter restrictions", new Object[0]);
        }
        catch (NullPointerException ex) {
            this.logger.error("Null argument passed to InstallReferrer proxy", new Object[0]);
        }
        return proxyInstance;
    }

    private void startConnection(Class listenerClass, Object listenerProxy) {
        try {
            Reflection.invokeInstanceMethod(this.referrerClient, "startConnection", new Class[]{listenerClass}, listenerProxy);
        }
        catch (InvocationTargetException ex) {
            if (Util.hasRootCause(ex)) {
                this.logger.error("InstallReferrer encountered an InvocationTargetException %s", Util.getRootCause(ex));
            }
        }
        catch (Exception ex) {
            this.logger.error("startConnection error (%s) thrown by (%s)", ex.getMessage(), ex.getClass().getCanonicalName());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method == null) {
            this.logger.error("InstallReferrer invoke method null", new Object[0]);
            return null;
        }
        String methodName = method.getName();
        if (methodName == null) {
            this.logger.error("InstallReferrer invoke method name null", new Object[0]);
            return null;
        }
        this.logger.debug("InstallReferrer invoke method name: %s", methodName);
        if (args == null) {
            this.logger.warn("InstallReferrer invoke args null", new Object[0]);
            args = new Object[]{};
        }
        for (Object arg : args) {
            this.logger.debug("InstallReferrer invoke arg: %s", arg);
        }
        if (methodName.equals("onInstallReferrerSetupFinished")) {
            if (args.length != 1) {
                this.logger.error("InstallReferrer invoke onInstallReferrerSetupFinished args lenght not 1: %d", args.length);
                return null;
            }
            Object arg = args[0];
            if (!(arg instanceof Integer)) {
                this.logger.error("InstallReferrer invoke onInstallReferrerSetupFinished arg not int", new Object[0]);
                return null;
            }
            Integer responseCode = (Integer)arg;
            if (responseCode == null) {
                this.logger.error("InstallReferrer invoke onInstallReferrerSetupFinished responseCode arg is null", new Object[0]);
                return null;
            }
            this.onInstallReferrerSetupFinishedInt(responseCode);
        } else if (methodName.equals("onInstallReferrerServiceDisconnected")) {
            this.logger.debug("Connection to install referrer service was lost. Retrying ...", new Object[0]);
            this.retry();
        }
        return null;
    }

    private void onInstallReferrerSetupFinishedInt(int responseCode) {
        boolean retryAtEnd = false;
        switch (responseCode) {
            case 0: {
                try {
                    Object referrerDetails = this.getInstallReferrer();
                    String installReferrer = this.getStringInstallReferrer(referrerDetails);
                    long clickTime = this.getReferrerClickTimestampSeconds(referrerDetails);
                    long installBegin = this.getInstallBeginTimestampSeconds(referrerDetails);
                    this.logger.debug("installReferrer: %s, clickTime: %d, installBeginTime: %d", installReferrer, clickTime, installBegin);
                    this.logger.debug("Install Referrer read successfully. Closing connection", new Object[0]);
                    this.referrerCallback.onInstallReferrerRead(installReferrer, clickTime, installBegin);
                    this.hasInstallReferrerBeenRead.set(true);
                }
                catch (Exception e) {
                    this.logger.warn("Couldn't get install referrer from client (%s). Retrying...", e.getMessage());
                    retryAtEnd = true;
                }
                break;
            }
            case 2: {
                this.logger.debug("Install Referrer API not supported by the installed Play Store app. Closing connection", new Object[0]);
                break;
            }
            case 1: {
                this.logger.debug("Could not initiate connection to the Install Referrer service. Retrying...", new Object[0]);
                retryAtEnd = true;
                break;
            }
            case -1: {
                this.logger.debug("Play Store service is not connected now. Retrying...", new Object[0]);
                retryAtEnd = true;
                break;
            }
            case 3: {
                this.logger.debug("Install Referrer API general errors caused by incorrect usage. Retrying...", new Object[0]);
                retryAtEnd = true;
                break;
            }
            default: {
                this.logger.debug("Unexpected response code of install referrer response: %d. Closing connection", responseCode);
            }
        }
        if (retryAtEnd) {
            this.retry();
        } else {
            this.closeReferrerClient();
        }
    }

    private Object getInstallReferrer() {
        if (this.referrerClient == null) {
            return null;
        }
        try {
            return Reflection.invokeInstanceMethod(this.referrerClient, "getInstallReferrer", null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("getInstallReferrer error (%s) thrown by (%s)", e.getMessage(), e.getClass().getCanonicalName());
            return null;
        }
    }

    private String getStringInstallReferrer(Object referrerDetails) {
        if (referrerDetails == null) {
            return null;
        }
        try {
            String stringInstallReferrer = (String)Reflection.invokeInstanceMethod(referrerDetails, "getInstallReferrer", null, new Object[0]);
            return stringInstallReferrer;
        }
        catch (Exception e) {
            this.logger.error("getStringInstallReferrer error (%s) thrown by (%s)", e.getMessage(), e.getClass().getCanonicalName());
            return null;
        }
    }

    private long getReferrerClickTimestampSeconds(Object referrerDetails) {
        if (referrerDetails == null) {
            return -1L;
        }
        try {
            Long clickTime = (Long)Reflection.invokeInstanceMethod(referrerDetails, "getReferrerClickTimestampSeconds", null, new Object[0]);
            return clickTime;
        }
        catch (Exception e) {
            this.logger.error("getReferrerClickTimestampSeconds error (%s) thrown by (%s)", e.getMessage(), e.getClass().getCanonicalName());
            return -1L;
        }
    }

    private long getInstallBeginTimestampSeconds(Object referrerDetails) {
        if (referrerDetails == null) {
            return -1L;
        }
        try {
            Long installBeginTime = (Long)Reflection.invokeInstanceMethod(referrerDetails, "getInstallBeginTimestampSeconds", null, new Object[0]);
            return installBeginTime;
        }
        catch (Exception e) {
            this.logger.error("getInstallBeginTimestampSeconds error (%s) thrown by (%s)", e.getMessage(), e.getClass().getCanonicalName());
            return -1L;
        }
    }

    private void retry() {
        if (this.hasInstallReferrerBeenRead.get()) {
            this.logger.debug("Install referrer has already been read", new Object[0]);
            this.closeReferrerClient();
            return;
        }
        if (this.retries + 1 > 2) {
            this.logger.debug("Limit number of retry of %d for install referrer surpassed", 2);
            return;
        }
        long firingIn = this.retryTimer.getFireIn();
        if (firingIn > 0L) {
            this.logger.debug("Already waiting to retry to read install referrer in %d milliseconds", firingIn);
            return;
        }
        ++this.retries;
        this.logger.debug("Retry number %d to connect to install referrer API", this.retries);
        this.retryTimer.startIn(this.retryWaitTime);
    }

    private void closeReferrerClient() {
        if (this.referrerClient == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(this.referrerClient, "endConnection", null, new Object[0]);
            this.logger.debug("Install Referrer API connection closed", new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("closeReferrerClient error (%s) thrown by (%s)", e.getMessage(), e.getClass().getCanonicalName());
        }
        this.referrerClient = null;
    }
}

