/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Reflection;
import java.util.Map;

public class AdjustSigner {
    private static volatile Object signerInstance = null;

    private AdjustSigner() {
    }

    public static void enableSigning(ILogger logger) {
        AdjustSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "enableSigning", null, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer enableSigning() received an error [%s]", e.getMessage());
        }
    }

    public static void disableSigning(ILogger logger) {
        AdjustSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "disableSigning", null, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer disableSigning() received an error [%s]", e.getMessage());
        }
    }

    public static void onResume(ILogger logger) {
        AdjustSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "onResume", null, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer onResume() received an error [%s]", e.getMessage());
        }
    }

    public static void sign(Map<String, String> parameters, String activityKind, String clientSdk, Context context, ILogger logger) {
        AdjustSigner.getSignerInstance();
        if (signerInstance == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(signerInstance, "sign", new Class[]{Context.class, Map.class, String.class, String.class}, context, parameters, activityKind, clientSdk);
        }
        catch (Exception e) {
            logger.warn("Invoking Signer sign() for %s received an error [%s]", activityKind, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getSignerInstance() {
        if (signerInstance != null) return;
        Class<AdjustSigner> clazz = AdjustSigner.class;
        synchronized (AdjustSigner.class) {
            if (signerInstance != null) return;
            signerInstance = Reflection.createDefaultInstance("com.adjust.sdk.sig.Signer");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

