/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.scheduler;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.scheduler.ThreadFactoryWrapper;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SingleThreadCachedScheduler
implements ThreadScheduler {
    private final List<Runnable> queue = new ArrayList<Runnable>();
    private boolean isThreadProcessing = false;
    private boolean isTeardown = false;
    private ThreadPoolExecutor threadPoolExecutor;

    public SingleThreadCachedScheduler(final String source) {
        this.threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryWrapper(source), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
                AdjustFactory.getLogger().warn("Runnable [%s] rejected from [%s] ", runnable.toString(), source);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Runnable task) {
        List<Runnable> list = this.queue;
        synchronized (list) {
            if (this.isTeardown) {
                return;
            }
            if (!this.isThreadProcessing) {
                this.isThreadProcessing = true;
                this.processQueue(task);
            } else {
                this.queue.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(final Runnable task, final long millisecondsDelay) {
        List<Runnable> list = this.queue;
        synchronized (list) {
            if (this.isTeardown) {
                return;
            }
            this.threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(millisecondsDelay);
                    }
                    catch (InterruptedException e) {
                        AdjustFactory.getLogger().warn("Sleep delay exception: %s", e.getMessage());
                    }
                    SingleThreadCachedScheduler.this.submit(task);
                }
            });
        }
    }

    private void processQueue(final Runnable firstRunnable) {
        this.threadPoolExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SingleThreadCachedScheduler.this.tryExecuteRunnable(firstRunnable);
                while (true) {
                    Runnable runnable;
                    List list = SingleThreadCachedScheduler.this.queue;
                    synchronized (list) {
                        if (SingleThreadCachedScheduler.this.isTeardown) {
                            return;
                        }
                        if (SingleThreadCachedScheduler.this.queue.isEmpty()) {
                            SingleThreadCachedScheduler.this.isThreadProcessing = false;
                            break;
                        }
                        runnable = (Runnable)SingleThreadCachedScheduler.this.queue.get(0);
                        SingleThreadCachedScheduler.this.queue.remove(0);
                    }
                    SingleThreadCachedScheduler.this.tryExecuteRunnable(runnable);
                }
            }
        });
    }

    private void tryExecuteRunnable(Runnable runnable) {
        try {
            if (this.isTeardown) {
                return;
            }
            runnable.run();
        }
        catch (Throwable t) {
            AdjustFactory.getLogger().warn("Execution failed: %s", t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardown() {
        List<Runnable> list = this.queue;
        synchronized (list) {
            this.isTeardown = true;
            this.queue.clear();
            this.threadPoolExecutor.shutdown();
        }
    }
}

