/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PreinstallUtil {
    private static final long SYSTEM_PROPERTY_BITMASK = 1L;
    private static final long SYSTEM_PROPERTY_REFLECTION_BITMASK = 2L;
    private static final long SYSTEM_PROPERTY_PATH_BITMASK = 4L;
    private static final long SYSTEM_PROPERTY_PATH_REFLECTION_BITMASK = 8L;
    private static final long CONTENT_PROVIDER_BITMASK = 16L;
    private static final long CONTENT_PROVIDER_INTENT_ACTION_BITMASK = 32L;
    private static final long FILE_SYSTEM_BITMASK = 64L;
    private static final long CONTENT_PROVIDER_NO_PERMISSION_BITMASK = 128L;
    private static final long ALL_LOCATION_BITMASK = 255L;

    public static boolean hasAllLocationsBeenRead(long status) {
        return (status & 0xFFL) == 255L;
    }

    public static boolean hasNotBeenRead(String location, long status) {
        switch (location) {
            case "system_properties": {
                return (status & 1L) != 1L;
            }
            case "system_properties_reflection": {
                return (status & 2L) != 2L;
            }
            case "system_properties_path": {
                return (status & 4L) != 4L;
            }
            case "system_properties_path_reflection": {
                return (status & 8L) != 8L;
            }
            case "content_provider": {
                return (status & 0x10L) != 16L;
            }
            case "content_provider_intent_action": {
                return (status & 0x20L) != 32L;
            }
            case "file_system": {
                return (status & 0x40L) != 64L;
            }
            case "content_provider_no_permission": {
                return (status & 0x80L) != 128L;
            }
        }
        return false;
    }

    public static long markAsRead(String location, long status) {
        switch (location) {
            case "system_properties": {
                return status | 1L;
            }
            case "system_properties_reflection": {
                return status | 2L;
            }
            case "system_properties_path": {
                return status | 4L;
            }
            case "system_properties_path_reflection": {
                return status | 8L;
            }
            case "content_provider": {
                return status | 0x10L;
            }
            case "content_provider_intent_action": {
                return status | 0x20L;
            }
            case "file_system": {
                return status | 0x40L;
            }
            case "content_provider_no_permission": {
                return status | 0x80L;
            }
        }
        return status;
    }

    public static String getPayloadFromSystemProperty(String packageName, ILogger logger) {
        return PreinstallUtil.readSystemProperty("adjust.preinstall." + packageName, logger);
    }

    public static String getPayloadFromSystemPropertyReflection(String packageName, ILogger logger) {
        return PreinstallUtil.readSystemPropertyReflection("adjust.preinstall." + packageName, logger);
    }

    public static String getPayloadFromSystemPropertyFilePath(String packageName, ILogger logger) {
        String filePath = PreinstallUtil.readSystemProperty("adjust.preinstall.path", logger);
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        String content = PreinstallUtil.readFileContent(filePath, logger);
        if (content == null || content.isEmpty()) {
            return null;
        }
        return PreinstallUtil.readPayloadFromJsonString(content, packageName, logger);
    }

    public static String getPayloadFromSystemPropertyFilePathReflection(String packageName, ILogger logger) {
        String filePath = PreinstallUtil.readSystemPropertyReflection("adjust.preinstall.path", logger);
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        String content = PreinstallUtil.readFileContent(filePath, logger);
        if (content == null || content.isEmpty()) {
            return null;
        }
        return PreinstallUtil.readPayloadFromJsonString(content, packageName, logger);
    }

    public static String getPayloadFromContentProviderDefault(Context context, String packageName, ILogger logger) {
        if (!Util.resolveContentProvider(context, "com.adjust.preinstall")) {
            return null;
        }
        String defaultContentUri = Util.formatString("content://%s/%s", "com.adjust.preinstall", "trackers");
        return PreinstallUtil.readContentProvider(context, defaultContentUri, packageName, logger);
    }

    public static List<String> getPayloadsFromContentProviderIntentAction(Context context, String packageName, ILogger logger) {
        return PreinstallUtil.readContentProviderIntentAction(context, packageName, "android.permission.INSTALL_PACKAGES", logger);
    }

    public static List<String> getPayloadsFromContentProviderNoPermission(Context context, String packageName, ILogger logger) {
        return PreinstallUtil.readContentProviderIntentAction(context, packageName, null, logger);
    }

    public static String getPayloadFromFileSystem(String packageName, String filePath, ILogger logger) {
        String content = PreinstallUtil.readFileContent("/data/local/tmp/adjust.preinstall", logger);
        if (content == null || content.isEmpty()) {
            if (filePath != null && !filePath.isEmpty()) {
                content = PreinstallUtil.readFileContent(filePath, logger);
            }
            if (content == null || content.isEmpty()) {
                return null;
            }
        }
        return PreinstallUtil.readPayloadFromJsonString(content, packageName, logger);
    }

    private static String readSystemProperty(String propertyKey, ILogger logger) {
        try {
            return System.getProperty(propertyKey);
        }
        catch (Exception e) {
            logger.error("Exception read system property key [%s] error [%s]", propertyKey, e.getMessage());
            return null;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static String readSystemPropertyReflection(String propertyKey, ILogger logger) {
        try {
            Class<?> classObject = Class.forName("android.os.SystemProperties");
            Method methodObject = classObject.getDeclaredMethod("get", String.class);
            return (String)methodObject.invoke(classObject, propertyKey);
        }
        catch (Exception e) {
            logger.error("Exception read system property using reflection key [%s] error [%s]", propertyKey, e.getMessage());
            return null;
        }
    }

    private static String readContentProvider(Context context, String contentUri, String packageName, ILogger logger) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)contentUri);
            String encryptedDataColunn = "encrypted_data";
            String[] projection = new String[]{"encrypted_data"};
            String selection = "package_name=?";
            String[] selectionArgs = new String[]{packageName};
            Cursor cursor = contentResolver.query(uri, projection, selection, selectionArgs, null);
            if (cursor == null) {
                logger.debug("Read content provider cursor null content uri [%s]", contentUri);
                return null;
            }
            if (!cursor.moveToFirst()) {
                logger.debug("Read content provider cursor empty content uri [%s]", contentUri);
                cursor.close();
                return null;
            }
            String payload = cursor.getString(0);
            cursor.close();
            return payload;
        }
        catch (Exception e) {
            logger.error("Exception read content provider uri [%s] error [%s]", contentUri, e.getMessage());
            return null;
        }
    }

    private static List<String> readContentProviderIntentAction(Context context, String packageName, String permission2, ILogger logger) {
        if (Build.VERSION.SDK_INT >= 19) {
            List providers = context.getPackageManager().queryIntentContentProviders(new Intent("com.attribution.REFERRAL_PROVIDER"), 0);
            ArrayList<String> payloads = new ArrayList<String>();
            for (ResolveInfo provider : providers) {
                String contentUri;
                String payload;
                String authority;
                int result;
                boolean permissionGranted = true;
                if (permission2 != null && (result = context.getPackageManager().checkPermission(permission2, provider.providerInfo.packageName)) != 0) {
                    permissionGranted = false;
                }
                if (!permissionGranted || (authority = provider.providerInfo.authority) == null || authority.isEmpty() || (payload = PreinstallUtil.readContentProvider(context, contentUri = Util.formatString("content://%s/%s", authority, "trackers"), packageName, logger)) == null || payload.isEmpty()) continue;
                payloads.add(payload);
            }
            if (!payloads.isEmpty()) {
                return payloads;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFileContent(String filePath, ILogger logger) {
        File file = new File(filePath);
        if (!file.exists()) return null;
        if (!file.isFile()) return null;
        if (!file.canRead()) return null;
        try {
            int length = (int)file.length();
            if (length <= 0) {
                logger.debug("Read file content empty file", new Object[0]);
                return null;
            }
            byte[] bytes = new byte[length];
            try (FileInputStream in = new FileInputStream(file);){
                in.read(bytes);
                return new String(bytes);
            }
        }
        catch (Exception e2) {
            logger.error("Exception read file content error [%s]", e2.getMessage());
        }
        return null;
    }

    private static String readPayloadFromJsonString(String jsonString, String packageName, ILogger logger) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString.trim());
            return jsonObject.optString(packageName);
        }
        catch (Exception e) {
            logger.error("Exception read payload from json string error [%s]", e.getMessage());
            return null;
        }
    }
}

