/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerCycle {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture waitingTask;
    private String name;
    private Runnable command;
    private long initialDelay;
    private long cycleDelay;
    private String cycleDelaySeconds;
    private boolean isPaused;
    private ILogger logger;

    public TimerCycle(Runnable command, long initialDelay, long cycleDelay, String name) {
        this.name = name;
        this.command = command;
        this.initialDelay = initialDelay;
        this.cycleDelay = cycleDelay;
        this.isPaused = true;
        this.logger = AdjustFactory.getLogger();
        this.cycleDelaySeconds = Util.SecondsDisplayFormat.format((double)cycleDelay / 1000.0);
    }

    public void start() {
        if (!this.isPaused) {
            this.logger.verbose("%s is already started", this.name);
            return;
        }
        String initialDelaySeconds = Util.SecondsDisplayFormat.format((double)this.initialDelay / 1000.0);
        this.logger.verbose("%s starting in %s seconds and cycle every %s seconds", this.name, initialDelaySeconds, this.cycleDelaySeconds);
        this.waitingTask = this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TimerCycle.this.logger.verbose("%s fired", TimerCycle.this.name);
                TimerCycle.this.command.run();
            }
        }, this.initialDelay, this.cycleDelay, TimeUnit.MILLISECONDS);
        this.isPaused = false;
    }

    public void suspend() {
        if (this.isPaused) {
            this.logger.verbose("%s is already suspended", this.name);
            return;
        }
        this.initialDelay = this.waitingTask.getDelay(TimeUnit.MILLISECONDS);
        this.waitingTask.cancel(false);
        this.waitingTask = null;
        String initialDelaySeconds = Util.SecondsDisplayFormat.format((double)this.initialDelay / 1000.0);
        this.logger.verbose("%s suspended with %s seconds left", this.name, initialDelaySeconds);
        this.isPaused = true;
    }
}

