/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.EpoxyAttribute;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.KotlinUtilsKt;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.SynchronizationKt;
import com.airbnb.epoxy.processor.Utils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class BaseModelAttributeInfo
extends AttributeInfo {
    private final TypeElement classElement;
    protected Types typeUtils;

    BaseModelAttributeInfo(Element attribute, Types typeUtils, Elements elements, Logger logger2, Memoizer memoizer2) {
        this.typeUtils = typeUtils;
        this.setFieldName(attribute.getSimpleName().toString());
        this.setTypeMirror(attribute.asType(), memoizer2);
        this.setJavaDocString(elements.getDocComment(attribute));
        this.classElement = (TypeElement)attribute.getEnclosingElement();
        this.setRootClass(this.classElement.getSimpleName().toString());
        this.setPackageName(elements.getPackageOf(this.classElement).getQualifiedName().toString());
        this.setHasSuperSetter(this.hasSuperMethod(this.classElement, attribute));
        this.setHasFinalModifier(attribute.getModifiers().contains((Object)Modifier.FINAL));
        this.setPackagePrivate(Utils.isFieldPackagePrivate(attribute));
        EpoxyAttribute annotation = SynchronizationKt.getAnnotationThreadSafe(attribute, EpoxyAttribute.class);
        HashSet<EpoxyAttribute.Option> options = new HashSet<EpoxyAttribute.Option>(Arrays.asList(annotation.value()));
        this.validateAnnotationOptions(logger2, annotation, options);
        this.setUseInHash(annotation.hash() && !options.contains(EpoxyAttribute.Option.DoNotHash));
        this.setIgnoreRequireHashCode(options.contains(EpoxyAttribute.Option.IgnoreRequireHashCode));
        this.setDoNotUseInToString(options.contains(EpoxyAttribute.Option.DoNotUseInToString));
        this.setGenerateSetter(annotation.setter() && !options.contains(EpoxyAttribute.Option.NoSetter));
        this.setGenerateGetter(!options.contains(EpoxyAttribute.Option.NoGetter));
        this.setPrivate(attribute.getModifiers().contains((Object)Modifier.PRIVATE));
        if (this.isPrivate()) {
            this.findGetterAndSetterForPrivateField(logger2);
        }
        this.buildAnnotationLists(SynchronizationKt.getAnnotationMirrorsThreadSafe(attribute));
    }

    protected boolean hasSuperMethod(TypeElement classElement, Element attribute) {
        if (!Utils.isEpoxyModel(classElement.asType())) {
            return false;
        }
        for (Element subElement : SynchronizationKt.getEnclosedElementsThreadSafe(classElement)) {
            if (subElement.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)subElement;
            List<VariableElement> parameters = SynchronizationKt.getParametersThreadSafe(method);
            if (method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getSimpleName().toString().equals(attribute.getSimpleName().toString()) || parameters.size() != 1 || !parameters.get(0).asType().equals(attribute.asType())) continue;
            return true;
        }
        TypeElement superClass = KotlinUtilsKt.superClassElement(classElement, this.typeUtils);
        return superClass instanceof TypeElement && this.hasSuperMethod(superClass, attribute);
    }

    private void validateAnnotationOptions(Logger logger2, EpoxyAttribute annotation, Set<EpoxyAttribute.Option> options) {
        if (options.contains(EpoxyAttribute.Option.IgnoreRequireHashCode) && options.contains(EpoxyAttribute.Option.DoNotHash)) {
            logger2.logError("Illegal to use both %s and %s options in an %s annotation. (%s#%s)", EpoxyAttribute.Option.DoNotHash, EpoxyAttribute.Option.IgnoreRequireHashCode, EpoxyAttribute.class.getSimpleName(), this.classElement.getSimpleName(), this.getFieldName());
        }
        if (!options.isEmpty()) {
            if (!annotation.hash()) {
                logger2.logError("Don't use hash=false in an %s if you are using options. Instead, use the %s option. (%s#%s)", EpoxyAttribute.class.getSimpleName(), EpoxyAttribute.Option.DoNotHash, this.classElement.getSimpleName(), this.getFieldName());
            }
            if (!annotation.setter()) {
                logger2.logError("Don't use setter=false in an %s if you are using options. Instead, use the %s option. (%s#%s)", EpoxyAttribute.class.getSimpleName(), EpoxyAttribute.Option.NoSetter, this.classElement.getSimpleName(), this.getFieldName());
            }
        }
    }

    private void findGetterAndSetterForPrivateField(Logger logger2) {
        for (Element element : SynchronizationKt.getEnclosedElementsThreadSafe(this.classElement)) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            String methodName = method.getSimpleName().toString();
            List<VariableElement> parameters = SynchronizationKt.getParametersThreadSafe(method);
            if ((methodName.equals(String.format("get%s", Utils.capitalizeFirstLetter(this.getFieldName()))) || methodName.equals(String.format("is%s", Utils.capitalizeFirstLetter(this.getFieldName()))) || methodName.equals(this.getFieldName()) && Utils.startsWithIs(this.getFieldName())) && !method.getModifiers().contains((Object)Modifier.PRIVATE) && !method.getModifiers().contains((Object)Modifier.STATIC) && parameters.isEmpty()) {
                this.setGetterMethodName(methodName);
            }
            if (!methodName.equals(String.format("set%s", Utils.capitalizeFirstLetter(this.getFieldName()))) && (!Utils.startsWithIs(this.getFieldName()) || !methodName.equals(String.format("set%s", this.getFieldName().substring(2, this.getFieldName().length())))) || method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.STATIC) || parameters.size() != 1) continue;
            this.setSetterMethodName(methodName);
        }
        if (this.getGetterMethodName() == null || this.getSetterMethodName() == null) {
            this.setPrivate(false);
            logger2.logError("%s annotations must not be on private fields without proper getter and setter methods. (class: %s, field: %s)", EpoxyAttribute.class.getSimpleName(), this.classElement.getSimpleName(), this.getFieldName());
        }
    }

    private void buildAnnotationLists(List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            ClassName annotationClass;
            if (!annotationMirror.getElementValues().isEmpty() || (annotationClass = ClassName.bestGuess((String)annotationMirror.getAnnotationType().toString())).equals((Object)ClassName.get(EpoxyAttribute.class))) continue;
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Target targetAnnotation = SynchronizationKt.getAnnotationThreadSafe(annotationType.asElement(), Target.class);
            List<ElementType> elementTypes = Arrays.asList(targetAnnotation == null ? ElementType.values() : targetAnnotation.value());
            AnnotationSpec annotationSpec = AnnotationSpec.builder((ClassName)annotationClass).build();
            if (elementTypes.contains((Object)ElementType.PARAMETER)) {
                this.getSetterAnnotations().add(annotationSpec);
            }
            if (!elementTypes.contains((Object)ElementType.METHOD)) continue;
            this.getGetterAnnotations().add(annotationSpec);
        }
    }
}

