/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.PackageEpoxyConfig;
import com.airbnb.epoxy.PackageModelViewConfig;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.ControllerClassInfo;
import com.airbnb.epoxy.processor.GeneratedModelInfo;
import com.airbnb.epoxy.processor.ModelViewInfo;
import com.airbnb.epoxy.processor.PackageConfigSettings;
import com.airbnb.epoxy.processor.PackageModelViewSettings;
import com.airbnb.epoxy.processor.SynchronizationKt;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.ViewAttributeInfo;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 G2\u00020\u0001:\u0001GB+\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020 H\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0004H\u0002J\u0010\u00101\u001a\u0004\u0018\u0001022\u0006\u0010)\u001a\u00020*J\u0012\u00103\u001a\u0004\u0018\u00010\u001d2\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00103\u001a\u0004\u0018\u00010\u001d2\u0006\u0010)\u001a\u00020 J\u000e\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*J\u0018\u0010:\u001a\f\u0012\b\u0012\u00060<j\u0002`=0;2\u0006\u0010>\u001a\u00020?J\u0018\u0010@\u001a\f\u0012\b\u0012\u00060<j\u0002`=0;2\u0006\u0010>\u001a\u00020?J\u000e\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020*J\u000e\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020\u000eR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/airbnb/epoxy/processor/ConfigManager;", "", "options", "", "", "elementUtils", "Ljavax/lang/model/util/Elements;", "typeUtils", "Ljavax/lang/model/util/Types;", "(Ljava/util/Map;Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;)V", "configurationMap", "", "Lcom/airbnb/epoxy/processor/PackageConfigSettings;", "disableDslMarker", "", "getDisableDslMarker", "()Z", "disableGenerateBuilderOverloads", "disableGenerateGetters", "disableGenerateReset", "disableKotlinExtensionGeneration", "enableCoroutines", "getEnableCoroutines", "globalImplicitlyAddAutoModels", "globalRequireAbstractModels", "globalRequireHashCode", "logTimings", "getLogTimings", "modelViewNamingMap", "Lcom/airbnb/epoxy/processor/PackageModelViewSettings;", "packageEpoxyConfigElements", "", "Ljavax/lang/model/element/Element;", "getPackageEpoxyConfigElements", "()Ljava/util/List;", "packageModelViewConfigElements", "getPackageModelViewConfigElements", "validateModelUsage", "modelInfo", "Lcom/airbnb/epoxy/processor/GeneratedModelInfo;", "generatedModelSuffix", "viewElement", "Ljavax/lang/model/element/TypeElement;", "getConfigurationForElement", "element", "getConfigurationForPackage", "packageElement", "Ljavax/lang/model/element/PackageElement;", "packageName", "getDefaultBaseModel", "Ljavax/lang/model/type/TypeMirror;", "getModelViewConfig", "modelViewInfo", "Lcom/airbnb/epoxy/processor/ModelViewInfo;", "implicitlyAddAutoModels", "controller", "Lcom/airbnb/epoxy/processor/ControllerClassInfo;", "includeAlternateLayoutsForViews", "processPackageEpoxyConfig", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "processPackageModelViewConfig", "requiresAbstractModels", "classElement", "requiresHashCode", "attributeInfo", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "shouldValidateModelUsage", "Companion", "epoxy-processor"})
public final class ConfigManager {
    @NotNull
    private final List<Element> packageEpoxyConfigElements;
    @NotNull
    private final List<Element> packageModelViewConfigElements;
    private final Map<String, PackageConfigSettings> configurationMap;
    private final Map<String, PackageModelViewSettings> modelViewNamingMap;
    private final boolean validateModelUsage;
    private final boolean globalRequireHashCode;
    private final boolean globalRequireAbstractModels;
    private final boolean globalImplicitlyAddAutoModels;
    private final boolean disableKotlinExtensionGeneration;
    private final boolean disableGenerateReset;
    private final boolean disableGenerateGetters;
    private final boolean disableGenerateBuilderOverloads;
    private final boolean disableDslMarker;
    private final boolean logTimings;
    private final boolean enableCoroutines;
    private final Elements elementUtils;
    private final Types typeUtils;
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_DLS_MARKER = "epoxyDisableDslMarker";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_GENERATE_RESET = "epoxyDisableGenerateReset";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_GENERATE_GETTERS = "epoxyDisableGenerateGetters";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_GENERATE_BUILDER_OVERLOADS = "epoxyDisableGenerateOverloads";
    @NotNull
    public static final String PROCESSOR_OPTION_LOG_TIMINGS = "logEpoxyTimings";
    @NotNull
    public static final String PROCESSOR_OPTION_ENABLE_PARALLEL = "enableParallelEpoxyProcessing";
    @NotNull
    public static final String PROCESSOR_OPTION_VALIDATE_MODEL_USAGE = "validateEpoxyModelUsage";
    @NotNull
    public static final String PROCESSOR_OPTION_REQUIRE_HASHCODE = "requireHashCodeInEpoxyModels";
    @NotNull
    public static final String PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS = "requireAbstractEpoxyModels";
    @NotNull
    public static final String PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS = "implicitlyAddAutoModels";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION = "disableEpoxyKotlinExtensionGeneration";
    private static final PackageConfigSettings DEFAULT_PACKAGE_CONFIG_SETTINGS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<Element> getPackageEpoxyConfigElements() {
        return this.packageEpoxyConfigElements;
    }

    @NotNull
    public final List<Element> getPackageModelViewConfigElements() {
        return this.packageModelViewConfigElements;
    }

    public final boolean getDisableDslMarker() {
        return this.disableDslMarker;
    }

    public final boolean getLogTimings() {
        return this.logTimings;
    }

    public final boolean getEnableCoroutines() {
        return this.enableCoroutines;
    }

    @NotNull
    public final List<Exception> processPackageEpoxyConfig(@NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        boolean bl = false;
        List errors = new ArrayList();
        Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(PackageEpoxyConfig.class).iterator();
        while (iterator.hasNext()) {
            PackageEpoxyConfig annotation;
            Element element;
            Element element2 = element = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
            this.packageEpoxyConfigElements.add(element2);
            PackageElement packageElement = this.elementUtils.getPackageOf(element);
            Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"elementUtils.getPackageOf(element)");
            String packageName = packageElement.getQualifiedName().toString();
            if (this.configurationMap.containsKey(packageName)) {
                errors.add(Utils.buildEpoxyException("Only one Epoxy configuration annotation is allowed per package (%s)", packageName));
                continue;
            }
            Element $this$getAnnotation$iv = element;
            boolean $i$f$getAnnotation = false;
            Intrinsics.checkNotNull((Object)SynchronizationKt.getAnnotationThreadSafe($this$getAnnotation$iv, PackageEpoxyConfig.class));
            this.configurationMap.put(packageName, PackageConfigSettings.Companion.create(annotation));
        }
        return errors;
    }

    @NotNull
    public final List<Exception> processPackageModelViewConfig(@NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        boolean bl = false;
        List errors = new ArrayList();
        Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(PackageModelViewConfig.class).iterator();
        while (iterator.hasNext()) {
            PackageModelViewConfig annotation;
            String rLayoutClassString;
            Element element;
            Element element2 = element = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
            this.packageModelViewConfigElements.add(element2);
            PackageElement packageElement = this.elementUtils.getPackageOf(element);
            Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"elementUtils.getPackageOf(element)");
            String packageName = packageElement.getQualifiedName().toString();
            if (this.modelViewNamingMap.containsKey(packageName)) {
                errors.add(Utils.buildEpoxyException("Only one %s annotation is allowed per package (%s)", PackageModelViewConfig.class.getSimpleName(), packageName));
                continue;
            }
            ClassName rClassName = Utils.INSTANCE.getClassParamFromAnnotation(element, PackageModelViewConfig.class, "rClass", this.typeUtils);
            if (rClassName == null) {
                errors.add(Utils.buildEpoxyException("Unable to get R class details from annotation %s (package: %s)", PackageModelViewConfig.class.getSimpleName(), packageName));
                continue;
            }
            String string = rLayoutClassString = rClassName.reflectionName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rLayoutClassString");
            if (!StringsKt.endsWith$default((String)string, (String)".R", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)rLayoutClassString, (String)".R2", (boolean)false, (int)2, null)) {
                errors.add(Utils.buildEpoxyException("Invalid R class in %s. Was '%s' (package: %s)", PackageModelViewConfig.class.getSimpleName(), rLayoutClassString, packageName));
                continue;
            }
            Element $this$getAnnotation$iv = element;
            boolean $i$f$getAnnotation = false;
            Intrinsics.checkNotNull((Object)SynchronizationKt.getAnnotationThreadSafe($this$getAnnotation$iv, PackageModelViewConfig.class));
            this.modelViewNamingMap.put(packageName, new PackageModelViewSettings(rClassName, annotation));
        }
        return errors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean requiresHashCode(@NotNull AttributeInfo attributeInfo) {
        Intrinsics.checkNotNullParameter((Object)attributeInfo, (String)"attributeInfo");
        if (attributeInfo instanceof ViewAttributeInfo) {
            return true;
        }
        if (this.globalRequireHashCode) return true;
        String string = attributeInfo.getPackageName();
        if (string == null) return false;
        String string2 = string;
        boolean bl = false;
        boolean bl2 = false;
        String packageName = string2;
        boolean bl3 = false;
        if (!this.getConfigurationForPackage(packageName).getRequireHashCode()) return false;
        return true;
    }

    public final boolean requiresAbstractModels(@NotNull TypeElement classElement) {
        Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
        return this.globalRequireAbstractModels || this.getConfigurationForElement(classElement).getRequireAbstractModels();
    }

    public final boolean implicitlyAddAutoModels(@NotNull ControllerClassInfo controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        return this.globalImplicitlyAddAutoModels || this.getConfigurationForElement(controller.getControllerClassElement()).getImplicitlyAddAutoModels();
    }

    public final boolean disableKotlinExtensionGeneration() {
        return this.disableKotlinExtensionGeneration;
    }

    public final boolean shouldValidateModelUsage() {
        return this.validateModelUsage;
    }

    @Nullable
    public final PackageModelViewSettings getModelViewConfig(@Nullable ModelViewInfo modelViewInfo) {
        if (modelViewInfo == null) {
            return null;
        }
        return this.getModelViewConfig(modelViewInfo.getViewElement());
    }

    @Nullable
    public final PackageModelViewSettings getModelViewConfig(@NotNull Element viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        PackageElement packageElement = this.elementUtils.getPackageOf(viewElement);
        Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"elementUtils.getPackageOf(viewElement)");
        String packageName = packageElement.getQualifiedName().toString();
        return (PackageModelViewSettings)ConfigManager.Companion.getObjectFromPackageMap(this.modelViewNamingMap, packageName, null);
    }

    @Nullable
    public final TypeMirror getDefaultBaseModel(@NotNull TypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        PackageModelViewSettings packageModelViewSettings = this.getModelViewConfig(viewElement);
        return packageModelViewSettings != null ? packageModelViewSettings.getDefaultBaseModel() : null;
    }

    public final boolean includeAlternateLayoutsForViews(@NotNull TypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        PackageModelViewSettings packageModelViewSettings = this.getModelViewConfig(viewElement);
        return packageModelViewSettings != null ? packageModelViewSettings.getIncludeAlternateLayouts() : false;
    }

    @NotNull
    public final String generatedModelSuffix(@NotNull TypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        Object object = this.getModelViewConfig(viewElement);
        if (object == null || (object = ((PackageModelViewSettings)object).getGeneratedModelSuffix()) == null) {
            object = "Model_";
        }
        return object;
    }

    public final boolean disableGenerateBuilderOverloads(@NotNull GeneratedModelInfo modelInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        GeneratedModelInfo generatedModelInfo = modelInfo;
        if (!(generatedModelInfo instanceof ModelViewInfo)) {
            generatedModelInfo = null;
        }
        return (object = this.getModelViewConfig((ModelViewInfo)generatedModelInfo)) != null && (object = ((PackageModelViewSettings)object).getDisableGenerateBuilderOverloads()) != null ? (Boolean)object : this.disableGenerateBuilderOverloads;
    }

    public final boolean disableGenerateReset(@NotNull GeneratedModelInfo modelInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        GeneratedModelInfo generatedModelInfo = modelInfo;
        if (!(generatedModelInfo instanceof ModelViewInfo)) {
            generatedModelInfo = null;
        }
        return (object = this.getModelViewConfig((ModelViewInfo)generatedModelInfo)) != null && (object = ((PackageModelViewSettings)object).getDisableGenerateReset()) != null ? (Boolean)object : this.disableGenerateReset;
    }

    public final boolean disableGenerateGetters(@NotNull GeneratedModelInfo modelInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        GeneratedModelInfo generatedModelInfo = modelInfo;
        if (!(generatedModelInfo instanceof ModelViewInfo)) {
            generatedModelInfo = null;
        }
        return (object = this.getModelViewConfig((ModelViewInfo)generatedModelInfo)) != null && (object = ((PackageModelViewSettings)object).getDisableGenerateGetters()) != null ? (Boolean)object : this.disableGenerateGetters;
    }

    private final PackageConfigSettings getConfigurationForElement(Element element) {
        PackageElement packageElement = this.elementUtils.getPackageOf(element);
        Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"elementUtils.getPackageOf(element)");
        return this.getConfigurationForPackage(packageElement);
    }

    private final PackageConfigSettings getConfigurationForPackage(PackageElement packageElement) {
        String packageName = packageElement.getQualifiedName().toString();
        return this.getConfigurationForPackage(packageName);
    }

    private final PackageConfigSettings getConfigurationForPackage(String packageName) {
        Object object = ConfigManager.Companion.getObjectFromPackageMap(this.configurationMap, packageName, ConfigManager.DEFAULT_PACKAGE_CONFIG_SETTINGS);
        Intrinsics.checkNotNull((Object)object);
        return (PackageConfigSettings)object;
    }

    public ConfigManager(@NotNull Map<String, String> options, @NotNull Elements elementUtils, @NotNull Types typeUtils) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        boolean bl = false;
        this.packageEpoxyConfigElements = new ArrayList();
        bl = false;
        this.packageModelViewConfigElements = new ArrayList();
        bl = false;
        this.configurationMap = new LinkedHashMap();
        bl = false;
        this.modelViewNamingMap = new LinkedHashMap();
        this.validateModelUsage = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_VALIDATE_MODEL_USAGE, true);
        this.globalRequireHashCode = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_REQUIRE_HASHCODE, false);
        this.globalRequireAbstractModels = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS, false);
        this.globalImplicitlyAddAutoModels = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS, false);
        this.disableKotlinExtensionGeneration = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION, false);
        this.logTimings = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_LOG_TIMINGS, false);
        this.enableCoroutines = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_ENABLE_PARALLEL, false);
        this.disableGenerateReset = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_GENERATE_RESET, false);
        this.disableGenerateGetters = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_GENERATE_GETTERS, false);
        this.disableGenerateBuilderOverloads = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_GENERATE_BUILDER_OVERLOADS, false);
        this.disableDslMarker = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_DLS_MARKER, false);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_PACKAGE_CONFIG_SETTINGS = PackageConfigSettings.Companion.forDefaults();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J9\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00180\u00142\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/airbnb/epoxy/processor/ConfigManager$Companion;", "", "()V", "DEFAULT_PACKAGE_CONFIG_SETTINGS", "Lcom/airbnb/epoxy/processor/PackageConfigSettings;", "PROCESSOR_OPTION_DISABLE_DLS_MARKER", "", "PROCESSOR_OPTION_DISABLE_GENERATE_BUILDER_OVERLOADS", "PROCESSOR_OPTION_DISABLE_GENERATE_GETTERS", "PROCESSOR_OPTION_DISABLE_GENERATE_RESET", "PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION", "PROCESSOR_OPTION_ENABLE_PARALLEL", "PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS", "PROCESSOR_OPTION_LOG_TIMINGS", "PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS", "PROCESSOR_OPTION_REQUIRE_HASHCODE", "PROCESSOR_OPTION_VALIDATE_MODEL_USAGE", "getBooleanOption", "", "options", "", "option", "defaultValue", "getObjectFromPackageMap", "T", "map", "packageName", "ifNotFound", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "epoxy-processor"})
    public static final class Companion {
        private final boolean getBooleanOption(Map<String, String> options, String option, boolean defaultValue) {
            String value;
            String string = options.get(option);
            if (string == null) {
                return defaultValue;
            }
            String string2 = value = string;
            boolean bl = false;
            return Boolean.parseBoolean(string2);
        }

        /*
         * WARNING - void declaration
         */
        private final <T> T getObjectFromPackageMap(Map<String, ? extends T> map2, String packageName, T ifNotFound) {
            if (map2.containsKey(packageName)) {
                return map2.get(packageName);
            }
            T matchValue = null;
            int matchLength = 0;
            Map<String, T> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Map<String, T> map3 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, T>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                void entryPackage;
                Map.Entry<String, T> element$iv;
                Map.Entry<String, T> $dstr$entryPackage$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, T> entry = $dstr$entryPackage$value;
                boolean bl3 = false;
                String string = entry.getKey();
                entry = $dstr$entryPackage$value;
                bl3 = false;
                T value = entry.getValue();
                if (!StringsKt.startsWith$default((String)packageName, (String)((String)entryPackage + '.'), (boolean)false, (int)2, null) || matchLength >= entryPackage.length()) continue;
                matchLength = entryPackage.length();
                matchValue = value;
            }
            T t = matchValue;
            if (t == null) {
                t = ifNotFound;
            }
            return t;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

