/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.ResourceProcessor;
import com.airbnb.epoxy.processor.Utils;
import com.squareup.javapoet.ClassName;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/airbnb/epoxy/processor/DataBindingModuleLookup;", "", "elements", "Ljavax/lang/model/util/Elements;", "types", "Ljavax/lang/model/util/Types;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "resourceProcessor", "Lcom/airbnb/epoxy/processor/ResourceProcessor;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;Lcom/airbnb/epoxy/processor/Logger;Lcom/airbnb/epoxy/processor/ResourceProcessor;)V", "getModuleName", "", "element", "Ljavax/lang/model/element/Element;", "getModuleNameViaGuessing", "packageName", "getModuleNameViaResources", "epoxy-processor"})
public final class DataBindingModuleLookup {
    private final Elements elements;
    private final Types types;
    private final Logger logger;
    private final ResourceProcessor resourceProcessor;

    @NotNull
    public final String getModuleName(@NotNull Element element) {
        PackageElement packageOf;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PackageElement packageElement = packageOf = this.elements.getPackageOf(element);
        Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"packageOf");
        String packageName = packageElement.getQualifiedName().toString();
        String moduleName = this.getModuleNameViaResources(packageName);
        if (moduleName == null) {
            moduleName = this.getModuleNameViaGuessing(packageName);
        }
        if (moduleName == null) {
            this.logger.logError("Could not find module name for DataBinding BR class.", new Object[0]);
            moduleName = packageName;
        }
        return moduleName;
    }

    /*
     * WARNING - void declaration
     */
    private final String getModuleNameViaResources(String packageName) {
        List<ClassName> rClasses = this.resourceProcessor.getRClassNames();
        if (rClasses.isEmpty()) {
            return packageName;
        }
        if (rClasses.size() == 1) {
            String string = rClasses.get(0).packageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rClasses[0].packageName()");
            return string;
        }
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)packageName, (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] packageNames = stringArray;
        ClassName bestMatch = null;
        int bestNumMatches = -1;
        for (ClassName rClass : rClasses) {
            void i;
            String[] rModuleNames;
            String string = rClass.packageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rClass.packageName()");
            Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
            int $i$f$toTypedArray2 = 0;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            if (thisCollection$iv2.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int numNameMatches = 0;
            $i$f$toTypedArray2 = 0;
            int n = packageNames.length;
            int n2 = rModuleNames.length;
            boolean bl = false;
            int n3 = Math.min(n, n2);
            while ($i$f$toTypedArray2 < n3 && Intrinsics.areEqual((Object)packageNames[i], (Object)rModuleNames[i])) {
                ++numNameMatches;
                ++i;
            }
            if (numNameMatches <= bestNumMatches) continue;
            bestMatch = rClass;
        }
        ClassName className = bestMatch;
        Intrinsics.checkNotNull((Object)className);
        String string = className.packageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bestMatch!!.packageName()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getModuleNameViaGuessing(String packageName) {
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)packageName, (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
        int $i$f$toTypedArray = 0;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] packageNameParts = stringArray;
        String moduleName = "";
        $i$f$toTypedArray = 0;
        int n = packageNameParts.length;
        while ($i$f$toTypedArray < n) {
            void i;
            Element rClass = Utils.INSTANCE.getElementByNameNullable((moduleName = moduleName + packageNameParts[i]) + ".R", this.elements, this.types);
            if (rClass != null) {
                return moduleName;
            }
            moduleName = moduleName + ".";
            ++i;
        }
        return null;
    }

    public DataBindingModuleLookup(@NotNull Elements elements, @NotNull Types types, @NotNull Logger logger2, @NotNull ResourceProcessor resourceProcessor) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceProcessor, (String)"resourceProcessor");
        this.elements = elements;
        this.types = types;
        this.logger = logger2;
        this.resourceProcessor = resourceProcessor;
    }
}

