/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.EpoxyProcessorException;
import com.airbnb.epoxy.processor.KotlinUtilsKt;
import com.airbnb.epoxy.processor.SynchronizationKt;
import com.airbnb.epoxy.processor.Utils;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class HashCodeValidator {
    private static final List<String> WHITE_LISTED_TYPES = Arrays.asList("java.lang.CharSequence");
    private static final MethodSpec HASH_CODE_METHOD = MethodSpec.methodBuilder((String)"hashCode").returns(TypeName.INT).build();
    private static final MethodSpec EQUALS_METHOD = MethodSpec.methodBuilder((String)"equals").addParameter((TypeName)TypeName.OBJECT, "obj", new Modifier[0]).returns(TypeName.BOOLEAN).build();
    private final Types typeUtils;
    private final Elements elements;

    HashCodeValidator(Types typeUtils, Elements elements) {
        this.typeUtils = typeUtils;
        this.elements = elements;
    }

    boolean implementsHashCodeAndEquals(TypeMirror mirror) {
        SynchronizationKt.ensureLoaded(mirror);
        try {
            this.validateImplementsHashCode(mirror);
            return true;
        }
        catch (EpoxyProcessorException e) {
            return false;
        }
    }

    void validate(AttributeInfo attribute) throws EpoxyProcessorException {
        try {
            this.validateImplementsHashCode(attribute.getTypeMirror());
        }
        catch (EpoxyProcessorException e) {
            Utils.throwError(e.getMessage() + " (%s) Epoxy requires every model attribute to implement equals and hashCode so that changes in the model can be tracked. If you want the attribute to be excluded, use the option 'DoNotHash'. If you want to ignore this warning use the option 'IgnoreRequireHashCode'", attribute);
        }
    }

    private void validateImplementsHashCode(TypeMirror mirror) throws EpoxyProcessorException {
        if (mirror.getKind() == TypeKind.ERROR) {
            return;
        }
        if (KotlinUtilsKt.typeNameSynchronized(mirror).isPrimitive()) {
            return;
        }
        if (mirror.getKind() == TypeKind.ARRAY) {
            this.validateArrayType((ArrayType)mirror);
            return;
        }
        if (!(mirror instanceof DeclaredType)) {
            return;
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        Element element = this.typeUtils.asElement(mirror);
        TypeElement clazz = (TypeElement)element;
        if (Utils.isIterableType(clazz)) {
            this.validateIterableType(declaredType);
            return;
        }
        if (this.isAutoValueType(element)) {
            return;
        }
        if (this.isWhiteListedType(element)) {
            return;
        }
        if (!this.hasHashCodeInClassHierarchy(clazz)) {
            Utils.throwError("Attribute does not implement hashCode", new Object[0]);
        }
        if (!this.hasEqualsInClassHierarchy(clazz)) {
            Utils.throwError("Attribute does not implement equals", new Object[0]);
        }
    }

    private boolean hasHashCodeInClassHierarchy(TypeElement clazz) {
        ExecutableElement methodOnClass = Utils.getMethodOnClass(clazz, HASH_CODE_METHOD, this.typeUtils, this.elements);
        if (methodOnClass == null) {
            return false;
        }
        Element implementingClass = methodOnClass.getEnclosingElement();
        return !implementingClass.getSimpleName().toString().equals("Object");
    }

    private boolean hasEqualsInClassHierarchy(TypeElement clazz) {
        ExecutableElement methodOnClass = Utils.getMethodOnClass(clazz, EQUALS_METHOD, this.typeUtils, this.elements);
        if (methodOnClass == null) {
            return false;
        }
        Element implementingClass = methodOnClass.getEnclosingElement();
        return !implementingClass.getSimpleName().toString().equals("Object");
    }

    private void validateArrayType(ArrayType mirror) throws EpoxyProcessorException {
        TypeMirror arrayType = mirror.getComponentType();
        try {
            this.validateImplementsHashCode(arrayType);
        }
        catch (EpoxyProcessorException e) {
            Utils.throwError("Type in array does not implement hashCode. Type: %s", arrayType.toString());
        }
    }

    private void validateIterableType(DeclaredType declaredType) throws EpoxyProcessorException {
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            try {
                this.validateImplementsHashCode(typeMirror);
            }
            catch (EpoxyProcessorException e) {
                Utils.throwError("Type in Iterable does not implement hashCode. Type: %s", typeMirror.toString());
            }
        }
    }

    private boolean isWhiteListedType(Element element) {
        for (String whiteListedType : WHITE_LISTED_TYPES) {
            if (!Utils.isSubtypeOfType(element.asType(), whiteListedType)) continue;
            return true;
        }
        return false;
    }

    private boolean isAutoValueType(Element element) {
        for (AnnotationMirror annotationMirror : SynchronizationKt.getAnnotationMirrorsThreadSafe(element)) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            boolean isAutoValue = Utils.isSubtypeOfType(annotationType, "com.google.auto.value.AutoValue");
            if (!isAutoValue) continue;
            return true;
        }
        return false;
    }
}

