/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.processor.SynchronizationKt;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner7;

public class ImportScanner
extends ElementScanner7<Void, Void> {
    private Set<String> types = new HashSet<String>();

    public Set<String> getImportedTypes() {
        return this.types;
    }

    @Override
    public Void visitType(TypeElement e, Void p) {
        for (TypeMirror typeMirror : e.getInterfaces()) {
            this.types.add(typeMirror.toString());
        }
        TypeMirror superclass = e.getSuperclass();
        SynchronizationKt.ensureLoaded(superclass);
        this.types.add(superclass.toString());
        return (Void)super.visitType(e, p);
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void p) {
        if (e.getReturnType().getKind() == TypeKind.DECLARED) {
            this.types.add(e.getReturnType().toString());
        }
        return (Void)super.visitExecutable(e, p);
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, Void p) {
        if (e.asType().getKind() == TypeKind.DECLARED) {
            this.types.add(e.asType().toString());
        }
        return (Void)super.visitTypeParameter(e, p);
    }

    @Override
    public Void visitVariable(VariableElement e, Void p) {
        if (e.asType().getKind() == TypeKind.DECLARED) {
            this.types.add(e.asType().toString());
        }
        return (Void)super.visitVariable(e, p);
    }
}

