/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.processor.EpoxyProcessorException;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.LoggerKt;
import com.airbnb.epoxy.processor.Timing;
import com.airbnb.epoxy.processor.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0007J\u0018\u0010\u001b\u001a\u00020\u00132\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001dJU\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\"\u001a\u00020\u00152\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00052\u001c\u0010&\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0(\u0012\u0006\u0012\u0004\u0018\u00010\u00010'H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0015J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010.\u001a\u00020\u0013J\f\u0010/\u001a\u00020\u0015*\u00020\u000eH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lcom/airbnb/epoxy/processor/Logger;", "", "messager", "Ljavax/annotation/processing/Messager;", "logTimings", "", "(Ljavax/annotation/processing/Messager;Z)V", "currentTimingBlocks", "Ljava/util/Stack;", "", "Lcom/airbnb/epoxy/processor/Timing;", "getLogTimings", "()Z", "loggedExceptions", "", "getMessager", "()Ljavax/annotation/processing/Messager;", "timings", "logError", "", "msg", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "e", "message", "logErrors", "exceptions", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "measure", "T", "name", "numItems", "", "isParallel", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "note", "printTimings", "processorName", "warn", "writeExceptions", "stackTraceString", "epoxy-processor"})
public final class Logger {
    private final List<Timing> timings;
    private final Stack<List<Timing>> currentTimingBlocks;
    private final List<Throwable> loggedExceptions;
    @NotNull
    private final Messager messager;
    private final boolean logTimings;

    public final void writeExceptions() {
        Iterable $this$forEach$iv = this.loggedExceptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable it = (Throwable)element$iv;
            boolean bl = false;
            this.messager.printMessage(Diagnostic.Kind.ERROR, it.getClass().getSimpleName() + ": " + it.getLocalizedMessage() + "\n" + this.stackTraceString(it));
        }
    }

    private final String stackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    public final void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    public final void logErrors(@NotNull List<? extends Exception> exceptions) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Iterable $this$forEach$iv = exceptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Exception it = (Exception)element$iv;
            boolean bl = false;
            Logger.logError$default(this, it, null, 2, null);
        }
    }

    public final void logError(@NotNull String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Logger.logError$default(this, Utils.buildEpoxyException(msg, Arrays.copyOf(args, args.length)), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logError(@NotNull Throwable e, @Nullable String message) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<Throwable> list = this.loggedExceptions;
        String string = message;
        if (string != null) {
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            List<Throwable> list2 = list;
            boolean bl3 = false;
            EpoxyProcessorException epoxyProcessorException = new EpoxyProcessorException((String)it, e);
            list = list2;
            throwable = epoxyProcessorException;
        } else {
            throwable = e;
        }
        list.add(throwable);
    }

    public static /* synthetic */ void logError$default(Logger logger2, Throwable throwable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        logger2.logError(throwable, string);
    }

    @JvmOverloads
    public final void logError(@NotNull Throwable e) {
        Logger.logError$default(this, e, null, 2, null);
    }

    public final void note(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messager.printMessage(Diagnostic.Kind.NOTE, message + "\n ");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object measure(@NotNull String var1_1, @Nullable Integer var2_2, @Nullable Boolean var3_3, @NotNull Function1<? super Continuation<? super T>, ? extends Object> var4_4, @NotNull Continuation<? super T> var5_5) {
        if (!(var5_5 instanceof measure.1)) ** GOTO lbl-1000
        var13_6 = var5_5;
        if ((var13_6.label & -2147483648) != 0) {
            var13_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ Logger this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.measure((String)null, (Integer)null, (Boolean)null, null, this);
                }
                {
                    this.this$0 = logger2;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.logTimings) break;
                $continuation.label = 1;
                v0 = block.invoke((Object)$continuation);
                if (v0 == var14_8) {
                    return var14_8;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                return v0;
            }
        }
        var6_9 = false;
        this.currentTimingBlocks.add((List<Timing>)new ArrayList<E>());
        start = System.nanoTime();
        $continuation.L$0 = this;
        $continuation.L$1 = name;
        $continuation.L$2 = numItems;
        $continuation.L$3 = isParallel;
        $continuation.J$0 = start;
        $continuation.label = 2;
        v1 = block.invoke((Object)$continuation);
        if (v1 == var14_8) {
            return var14_8;
        }
        ** GOTO lbl44
        {
            case 2: {
                start = $continuation.J$0;
                isParallel = (Boolean)$continuation.L$3;
                numItems = (Integer)$continuation.L$2;
                name = (String)$continuation.L$1;
                this = (Logger)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                result = v1;
                elapsed = (System.nanoTime() - start) / (long)1000000;
                v2 = this.currentTimingBlocks.pop();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"currentTimingBlocks.pop()");
                timing = new Timing(var1_1, elapsed, v2, var2_2, var3_3);
                v3 = (List<Timing>)CollectionsKt.lastOrNull((List)this.currentTimingBlocks);
                if (v3 == null) {
                    v3 = this.timings;
                }
                v3.add(timing);
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object measure$default(Logger logger2, String string, Integer n, Boolean bl, Function1 function1, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            bl = null;
        }
        return logger2.measure(string, n, bl, function1, continuation);
    }

    /*
     * WARNING - void declaration
     */
    public final void printTimings(@NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        if (!this.logTimings) {
            return;
        }
        String timingString = LoggerKt.access$joinToString(this.timings, 1);
        Iterable $this$sumBy$iv = this.timings;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Timing timing = (Timing)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = (int)it.getDurationMs();
            sum$iv = n + n2;
        }
        int totalDuration = sum$iv;
        this.warn(processorName + " completed in " + totalDuration + " ms:\n" + timingString + "\n ");
    }

    @NotNull
    public final Messager getMessager() {
        return this.messager;
    }

    public final boolean getLogTimings() {
        return this.logTimings;
    }

    public Logger(@NotNull Messager messager, boolean logTimings) {
        Intrinsics.checkNotNullParameter((Object)messager, (String)"messager");
        this.messager = messager;
        this.logTimings = logTimings;
        boolean bl = false;
        this.timings = new ArrayList();
        this.currentTimingBlocks = new Stack();
        bl = false;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.synchronizedList(mutableListOf())");
        this.loggedExceptions = list;
    }
}

