/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.EpoxyDataBindingLayouts;
import com.airbnb.epoxy.EpoxyModelClass;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Mutex;
import com.airbnb.epoxy.processor.ResourceValue;
import com.airbnb.epoxy.processor.SynchronizationKt;
import com.airbnb.epoxy.processor.Utils;
import com.squareup.javapoet.ClassName;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u000245B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u001a\u001a\u00020\u0014J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\"\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010$\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0 J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0 J,\u0010'\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\b\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010(\u001a\u00020)J8\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\b\u0010#\u001a\u0004\u0018\u00010\r2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0\u0010J\"\u0010,\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010(\u001a\u00020)J\u001e\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u00100\u001a\u00020)H\u0002J\u001a\u00101\u001a\u0002022\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u00103\u001a\u00020\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/airbnb/epoxy/processor/ResourceProcessor;", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "elementUtils", "Ljavax/lang/model/util/Elements;", "typeUtils", "Ljavax/lang/model/util/Types;", "(Ljavax/annotation/processing/ProcessingEnvironment;Lcom/airbnb/epoxy/processor/Logger;Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;)V", "rClassNameMap", "", "", "Lcom/squareup/javapoet/ClassName;", "rClassNames", "", "getRClassNames", "()Ljava/util/List;", "rClassResources", "Lcom/airbnb/epoxy/processor/ResourceValue;", "trees", "Lcom/sun/source/util/Trees;", "getTrees", "()Lcom/sun/source/util/Trees;", "getAlternateLayouts", "layout", "getAnnotationMirror", "Ljavax/lang/model/element/AnnotationMirror;", "element", "Ljavax/lang/model/element/Element;", "annotationClass", "Ljava/lang/Class;", "getClassName", "rClass", "resourceType", "getLayoutInAnnotation", "", "getLayoutsInAnnotation", "getResourceInAnnotation", "resourceValue", "", "getResourcesInAnnotation", "resourceValues", "getStringResourceInAnnotation", "isLayoutValueInResources", "", "resources", "layoutValue", "saveResourceValuesForRClass", "", "resourceClass", "AnnotationResourceParamScanner", "Companion", "epoxy-processor"})
public final class ResourceProcessor {
    private final Map<String, ClassName> rClassNameMap;
    @Nullable
    private final Trees trees;
    private final Map<ClassName, List<ResourceValue>> rClassResources;
    private final Logger logger;
    private final Elements elementUtils;
    private final Types typeUtils;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Trees getTrees() {
        return this.trees;
    }

    @NotNull
    public final ResourceValue getLayoutInAnnotation(@NotNull Element element, @NotNull Class<? extends Annotation> annotationClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        List<ResourceValue> layouts = this.getLayoutsInAnnotation(element, annotationClass);
        if (layouts.size() != 1) {
            Object[] objectArray = new Object[3];
            String string = annotationClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.simpleName");
            objectArray[0] = string;
            objectArray[1] = layouts.size();
            Name name = element.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"element.simpleName");
            objectArray[2] = name;
            this.logger.logError("Expected exactly 1 layout resource in the %s annotation but received %s. Annotated element is %s", objectArray);
            if (layouts.isEmpty()) {
                return new ResourceValue(0);
            }
        }
        return layouts.get(0);
    }

    @NotNull
    public final List<ResourceValue> getLayoutsInAnnotation(@NotNull Element element, @NotNull Class<? extends Annotation> annotationClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        List layoutValues = ResourceProcessor.Companion.getLayoutValues(element, annotationClass);
        return this.getResourcesInAnnotation(element, annotationClass, "layout", layoutValues);
    }

    @NotNull
    public final ResourceValue getStringResourceInAnnotation(@NotNull Element element, @NotNull Class<?> annotationClass, int resourceValue) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        return this.getResourceInAnnotation(element, annotationClass, "string", resourceValue);
    }

    @NotNull
    public final ResourceValue getResourceInAnnotation(@NotNull Element element, @NotNull Class<?> annotationClass, @Nullable String resourceType, int resourceValue) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        List<ResourceValue> layouts = this.getResourcesInAnnotation(element, annotationClass, resourceType, CollectionsKt.listOf((Object)resourceValue));
        if (layouts.size() != 1) {
            Object[] objectArray = new Object[4];
            String string = resourceType;
            Intrinsics.checkNotNull((Object)string);
            objectArray[0] = string;
            String string2 = annotationClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotationClass.simpleName");
            objectArray[1] = string2;
            objectArray[2] = layouts.size();
            Name name = element.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"element.simpleName");
            objectArray[3] = name;
            this.logger.logError("Expected exactly 1 %s resource in the %s annotation but received %s. Annotated element is %s", objectArray);
            if (layouts.isEmpty()) {
                return new ResourceValue(0);
            }
        }
        return layouts.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ResourceValue> getResourcesInAnnotation(@NotNull Element element, @NotNull Class<?> annotationClass, @Nullable String resourceType, @NotNull List<Integer> resourceValues) {
        JCTree jCTree;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter(resourceValues, (String)"resourceValues");
        List resources = new ArrayList(resourceValues.size());
        Trees trees = this.trees;
        boolean bl = false;
        boolean bl2 = false;
        if (trees == null) {
            boolean bl3 = false;
            String string = "Compiler Trees instance was not found in processing environment";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Trees trees2 = this.trees;
        bl2 = false;
        boolean bl4 = false;
        synchronized (trees2) {
            boolean bl5 = false;
            Tree tree = this.trees.getTree(element, this.getAnnotationMirror(element, annotationClass));
            if (!(tree instanceof JCTree)) {
                tree = null;
            }
            jCTree = (JCTree)tree;
        }
        JCTree tree = jCTree;
        if (tree != null) {
            AnnotationResourceParamScanner scanner = new AnnotationResourceParamScanner();
            scanner.setCurrentAnnotationDetails(element, annotationClass, resourceType);
            tree.accept(scanner);
            resources.addAll((Collection)scanner.getResults());
        }
        if (resources.size() != resourceValues.size()) {
            Iterator<Integer> iterator = resourceValues.iterator();
            while (iterator.hasNext()) {
                int layoutValue = ((Number)iterator.next()).intValue();
                if (this.isLayoutValueInResources(resources, layoutValue)) continue;
                resources.add(new ResourceValue(layoutValue));
            }
        }
        return resources;
    }

    private final boolean isLayoutValueInResources(List<ResourceValue> resources, int layoutValue) {
        for (ResourceValue resource : resources) {
            if (resource.getValue() != layoutValue) continue;
            return true;
        }
        return false;
    }

    private final AnnotationMirror getAnnotationMirror(Element element, Class<?> annotationClass) {
        for (AnnotationMirror annotationMirror : SynchronizationKt.getAnnotationMirrorsThreadSafe(element)) {
            if (!Intrinsics.areEqual((Object)annotationMirror.getAnnotationType().toString(), (Object)annotationClass.getCanonicalName())) continue;
            return annotationMirror;
        }
        Object[] objectArray = new Object[2];
        String string = annotationClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.simpleName");
        objectArray[0] = string;
        Name name = element.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"element.simpleName");
        objectArray[1] = name;
        this.logger.logError("Unable to get %s annotation on model %", objectArray);
        return null;
    }

    @NotNull
    public final List<ClassName> getRClassNames() {
        return CollectionsKt.toList((Iterable)this.rClassNameMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceValue> getAlternateLayouts(@NotNull ResourceValue layout) {
        void $this$filterTo$iv$iv;
        Element rLayoutClassElement;
        boolean bl4;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        ClassName className = layout.getClassName();
        if (className == null) {
            return CollectionsKt.emptyList();
        }
        ClassName layoutClassName = className;
        boolean $i$f$synchronizedByValue = false;
        if (SynchronizationKt.getSynchronizationEnabled()) {
            Mutex mutex = SynchronizationKt.mutex(layoutClassName);
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (mutex) {
                bl4 = false;
                if (this.rClassResources.isEmpty()) {
                    rLayoutClassElement = Utils.INSTANCE.getElementByName(layoutClassName, this.elementUtils, this.typeUtils);
                    this.saveResourceValuesForRClass(layoutClassName, rLayoutClassElement);
                }
                Unit unit = Unit.INSTANCE;
            }
        } else {
            bl4 = false;
            if (this.rClassResources.isEmpty()) {
                rLayoutClassElement = Utils.INSTANCE.getElementByName(layoutClassName, this.elementUtils, this.typeUtils);
                this.saveResourceValuesForRClass(layoutClassName, rLayoutClassElement);
            }
        }
        List<ResourceValue> layouts = this.rClassResources.get(layoutClassName);
        if (layouts == null) {
            this.logger.logError("No layout files found for R class: %s", layoutClassName);
            return CollectionsKt.emptyList();
        }
        String target = Intrinsics.stringPlus((String)layout.getResourceName(), (Object)"_");
        Iterable $this$filter$iv = layouts;
        boolean $i$f$filter = false;
        Iterable bl4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceValue otherLayout = (ResourceValue)element$iv$iv;
            boolean bl5 = false;
            String string = otherLayout.getResourceName();
            if (!(string != null && StringsKt.startsWith$default((String)string, (String)target, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveResourceValuesForRClass(ClassName rClass, Element resourceClass) {
        if (rClass == null) {
            return;
        }
        boolean $i$f$synchronizedByValue = false;
        if (SynchronizationKt.getSynchronizationEnabled()) {
            Mutex mutex = SynchronizationKt.mutex(rClass);
            boolean bl = false;
            boolean bl2 = false;
            synchronized (mutex) {
                Object object;
                String it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                boolean bl3 = false;
                if (this.rClassResources.containsKey(rClass)) {
                    return;
                }
                Iterable iterable = SynchronizationKt.getEnclosedElementsThreadSafe(resourceClass);
                boolean $i$f$filterIsInstance = false;
                void var10_15 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof VariableElement)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VariableElement variableElement = (VariableElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    object = it.getSimpleName().toString();
                    collection.add(object);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    object = new ResourceValue(rClass, it, 0);
                    collection.add(object);
                }
                List resourceNames = (List)destination$iv$iv;
                this.rClassResources.put(rClass, resourceNames);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            Object object;
            Collection collection;
            Object it;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            boolean bl = false;
            if (this.rClassResources.containsKey(rClass)) {
                return;
            }
            Iterable $this$map$iv = SynchronizationKt.getEnclosedElementsThreadSafe(resourceClass);
            boolean $i$f$filterIsInstance = false;
            Iterable $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VariableElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VariableElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                object = it.getSimpleName().toString();
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                object = new ResourceValue(rClass, (String)it, 0);
                collection.add(object);
            }
            List resourceNames = (List)destination$iv$iv;
            this.rClassResources.put(rClass, resourceNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ClassName getClassName(String rClass, String resourceType) {
        ClassName className;
        Map<String, ClassName> map2 = this.rClassNameMap;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map2) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl3 = false;
            Map<String, ClassName> map3 = this.rClassNameMap;
            String key$iv = rClass;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                Element rClassElement = Utils.INSTANCE.getElementByName(rClass, this.elementUtils, this.typeUtils);
                PackageElement packageElement = this.elementUtils.getPackageOf(rClassElement);
                Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"elementUtils.getPackageOf(rClassElement)");
                String rClassPackageName = packageElement.getQualifiedName().toString();
                ClassName className2 = ClassName.get((String)rClassPackageName, (String)"R", (String[])new String[]{resourceType});
                Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"ClassName.get(rClassPack\u2026eName, \"R\", resourceType)");
                ClassName answer$iv = className2;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            className = (ClassName)object;
        }
        return className;
    }

    /*
     * WARNING - void declaration
     */
    public ResourceProcessor(@NotNull ProcessingEnvironment processingEnv, @NotNull Logger logger2, @NotNull Elements elementUtils, @NotNull Types typeUtils) {
        Trees trees;
        ResourceProcessor resourceProcessor;
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        this.logger = logger2;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.rClassNameMap = new ConcurrentHashMap();
        this.rClassResources = new ConcurrentHashMap();
        ResourceProcessor resourceProcessor2 = this;
        try {
            resourceProcessor = resourceProcessor2;
            trees = Trees.instance(processingEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object object;
            try {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Field[] fieldArray = processingEnv.getClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"processingEnv.javaClass.declaredFields");
                object = fieldArray;
                ResourceProcessor resourceProcessor3 = resourceProcessor2;
                boolean $i$f$mapNotNull = false;
                void var9_12 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                void var14_17 = $this$forEach$iv$iv$iv;
                int n = ((void)var14_17).length;
                for (int i = 0; i < n; ++i) {
                    Trees trees2;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = var14_17[i];
                    boolean bl = false;
                    void field = element$iv$iv;
                    boolean bl2 = false;
                    void v2 = field;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"field");
                    if (Intrinsics.areEqual((Object)v2.getName(), (Object)"delegate") || Intrinsics.areEqual((Object)field.getName(), (Object)"processingEnv")) {
                        field.setAccessible(true);
                        Object object2 = field.get(processingEnv);
                        if (object2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type javax.annotation.processing.ProcessingEnvironment");
                        }
                        ProcessingEnvironment javacEnv = (ProcessingEnvironment)object2;
                        trees2 = Trees.instance(javacEnv);
                    } else {
                        trees2 = null;
                    }
                    if (trees2 == null) continue;
                    Trees trees3 = trees2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Trees it$iv$iv = trees3;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                resourceProcessor = resourceProcessor3;
                object = (Trees)CollectionsKt.firstOrNull((List)list);
            }
            catch (Throwable $i$f$mapNotNull) {
                resourceProcessor = resourceProcessor2;
                object = null;
            }
            trees = object;
        }
        resourceProcessor.trees = trees;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/airbnb/epoxy/processor/ResourceProcessor$AnnotationResourceParamScanner;", "Lcom/sun/tools/javac/tree/TreeScanner;", "(Lcom/airbnb/epoxy/processor/ResourceProcessor;)V", "annotationClass", "Ljava/lang/Class;", "element", "Ljavax/lang/model/element/Element;", "resourceType", "", "results", "", "Lcom/airbnb/epoxy/processor/ResourceValue;", "getResults", "", "parseResourceSymbol", "symbol", "Ljavax/lang/model/element/VariableElement;", "setCurrentAnnotationDetails", "", "visitSelect", "jcFieldAccess", "Lcom/sun/tools/javac/tree/JCTree$JCFieldAccess;", "epoxy-processor"})
    private final class AnnotationResourceParamScanner
    extends TreeScanner {
        private final List<ResourceValue> results = new ArrayList();
        private Element element;
        private Class<?> annotationClass;
        private String resourceType;

        @NotNull
        public final List<ResourceValue> getResults() {
            return this.results;
        }

        @Override
        public void visitSelect(@NotNull JCTree.JCFieldAccess jcFieldAccess) {
            Intrinsics.checkNotNullParameter((Object)jcFieldAccess, (String)"jcFieldAccess");
            Symbol symbol = jcFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol && symbol.getEnclosingElement() != null) {
                Symbol symbol2 = symbol.getEnclosingElement();
                Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"symbol.getEnclosingElement()");
                if (symbol2.getEnclosingElement() != null) {
                    ResourceValue result;
                    Symbol symbol3 = symbol.getEnclosingElement();
                    Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"symbol.getEnclosingElement()");
                    if (symbol3.getEnclosingElement().enclClass() != null && (result = this.parseResourceSymbol((VariableElement)((Object)symbol))) != null) {
                        this.results.add(result);
                    }
                }
            }
        }

        private final ResourceValue parseResourceSymbol(VariableElement symbol) {
            Element element = symbol.getEnclosingElement();
            if (element == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            TypeElement resourceClass = (TypeElement)element;
            Element element2 = resourceClass.getEnclosingElement();
            if (element2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            String rClass = ((TypeElement)element2).getQualifiedName().toString();
            String resourceClassName = resourceClass.getQualifiedName().toString();
            if (Intrinsics.areEqual((Object)(rClass + '.' + this.resourceType), (Object)resourceClassName) ^ true) {
                Logger logger2 = ResourceProcessor.this.logger;
                Object[] objectArray = new Object[4];
                Class<?> clazz = this.annotationClass;
                Intrinsics.checkNotNull(clazz);
                String string = clazz.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass!!.simpleName");
                objectArray[0] = string;
                String string2 = this.resourceType;
                Intrinsics.checkNotNull((Object)string2);
                objectArray[1] = string2;
                objectArray[2] = resourceClass;
                Element element3 = this.element;
                Intrinsics.checkNotNull((Object)element3);
                Name name = element3.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"element!!.simpleName");
                objectArray[3] = name;
                logger2.logError("%s annotation requires a %s resource but received %s. (Element: %s)", objectArray);
                return null;
            }
            String resourceName = symbol.getSimpleName().toString();
            Object resourceValue = symbol.getConstantValue();
            if (!(resourceValue instanceof Integer)) {
                Logger logger3 = ResourceProcessor.this.logger;
                Object[] objectArray = new Object[3];
                Class<?> clazz = this.annotationClass;
                Intrinsics.checkNotNull(clazz);
                String string = clazz.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass!!.simpleName");
                objectArray[0] = string;
                Name name = symbol.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"symbol.simpleName");
                objectArray[1] = name;
                Element element4 = this.element;
                Intrinsics.checkNotNull((Object)element4);
                Name name2 = element4.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"element!!.simpleName");
                objectArray[2] = name2;
                logger3.logError("%s annotation requires an int value but received %s. (Element: %s)", objectArray);
                return null;
            }
            ClassName rClassName = ResourceProcessor.this.getClassName(resourceClassName, this.resourceType);
            ResourceProcessor.this.saveResourceValuesForRClass(rClassName, resourceClass);
            ClassName className = rClassName;
            Intrinsics.checkNotNull((Object)className);
            return new ResourceValue(className, resourceName, ((Number)resourceValue).intValue());
        }

        public final void setCurrentAnnotationDetails(@Nullable Element element, @Nullable Class<?> annotationClass, @Nullable String resourceType) {
            this.element = element;
            this.annotationClass = annotationClass;
            this.resourceType = resourceType;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/airbnb/epoxy/processor/ResourceProcessor$Companion;", "", "()V", "getLayoutValues", "", "", "element", "Ljavax/lang/model/element/Element;", "annotationClass", "Ljava/lang/Class;", "", "epoxy-processor"})
    public static final class Companion {
        private final List<Integer> getLayoutValues(Element element, Class<? extends Annotation> annotationClass) {
            SynchronizationKt.ensureLoaded(element);
            Annotation annotation = SynchronizationKt.getAnnotationThreadSafe(element, annotationClass);
            return annotation instanceof EpoxyModelClass ? CollectionsKt.listOf((Object)((EpoxyModelClass)annotation).layout()) : (annotation instanceof EpoxyDataBindingLayouts ? ArraysKt.toList((int[])((EpoxyDataBindingLayouts)annotation).value()) : (annotation instanceof ModelView ? CollectionsKt.listOf((Object)((ModelView)annotation).defaultLayout()) : CollectionsKt.emptyList()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

