/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.processor.EpoxyProcessorException;
import com.airbnb.epoxy.processor.KotlinUtilsKt;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Mutex;
import com.airbnb.epoxy.processor.SynchronizationKt;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010$\u001a\u00020%J/\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0016\u0010-\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010.\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020807H\u0002J\u001a\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\u0004H\u0002J\u0014\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\u0006\u0010>\u001a\u00020?J8\u0010@\u001a\u0004\u0018\u00010?\"\b\b\u0000\u0010A*\u0002082\u0006\u0010B\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002HA072\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020#J\u000e\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020GJ\u001e\u0010H\u001a\u00020(2\u0006\u0010>\u001a\u00020?2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\u001e\u0010H\u001a\u0002052\u0006\u0010>\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J \u0010I\u001a\u0004\u0018\u00010(2\u0006\u0010>\u001a\u00020?2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\"\u0010I\u001a\u0004\u0018\u0001052\b\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\u0018\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020(2\u0006\u0010D\u001a\u00020#J*\u0010M\u001a\u0004\u0018\u00010\u001f2\u0006\u0010L\u001a\u00020(2\u0006\u0010N\u001a\u00020!2\u0006\u0010D\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J&\u0010O\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020(2\u0006\u0010N\u001a\u00020!2\u0006\u0010D\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u001e\u0010P\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020K2\u0006\u0010R\u001a\u00020K2\u0006\u0010\"\u001a\u00020#J\u000e\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020(J\u000e\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020(J\u000e\u0010W\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020(J\u0010\u0010W\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020KH\u0007J\u000e\u0010X\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020(J\u0010\u0010Y\u001a\u00020\u001d2\u0006\u0010T\u001a\u000205H\u0007J\u0010\u0010Z\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020(H\u0007J\u000e\u0010[\u001a\u00020\u001d2\u0006\u0010T\u001a\u000205J\u001e\u0010\\\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020(2\u0006\u0010R\u001a\u00020(2\u0006\u0010\"\u001a\u00020#J \u0010\\\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020K2\u0006\u0010R\u001a\u00020K2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010]\u001a\u00020\u001d2\u0006\u0010^\u001a\u00020K2\u0006\u0010_\u001a\u00020\u0004H\u0007J\u0016\u0010`\u001a\u00020\u001d2\u0006\u0010^\u001a\u00020K2\u0006\u0010_\u001a\u00020\u0004J\u000e\u0010a\u001a\u00020\u00042\u0006\u0010b\u001a\u00020\u0004J\u0010\u0010c\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0004H\u0007J/\u0010d\u001a\u00020e2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0016\u0010-\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010.\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010fJ\u000e\u0010g\u001a\u00020\u00042\u0006\u0010h\u001a\u00020\u0004J.\u0010i\u001a\u00020e2\u0006\u0010j\u001a\u0002052\n\u00106\u001a\u0006\u0012\u0002\b\u0003072\u0006\u0010k\u001a\u00020l2\b\b\u0002\u0010m\u001a\u00020\u001dH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/airbnb/epoxy/processor/Utils;", "", "()V", "ANDROID_VIEW_TYPE", "", "DATA_BINDING_MODEL_TYPE", "EPOXY_CONTROLLER_TYPE", "EPOXY_HOLDER_TYPE", "EPOXY_MODEL_TYPE", "EPOXY_MODEL_WITH_HOLDER_TYPE", "EPOXY_VIEW_HOLDER_TYPE", "GENERATED_MODEL_INTERFACE", "MODEL_CHECKED_CHANGE_LISTENER_TYPE", "MODEL_CLICK_LISTENER_TYPE", "MODEL_LONG_CLICK_LISTENER_TYPE", "ON_BIND_MODEL_LISTENER_TYPE", "ON_UNBIND_MODEL_LISTENER_TYPE", "ON_VISIBILITY_MODEL_LISTENER_TYPE", "ON_VISIBILITY_STATE_MODEL_LISTENER_TYPE", "PATTERN_STARTS_WITH_SET", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "UNTYPED_EPOXY_MODEL_TYPE", "VIEW_CHECKED_CHANGE_LISTENER_TYPE", "VIEW_CLICK_LISTENER_TYPE", "VIEW_LONG_CLICK_LISTENER_TYPE", "WRAPPED_CHECKED_LISTENER_TYPE", "WRAPPED_LISTENER_TYPE", "areParamsTheSame", "", "method1", "Ljavax/lang/model/element/ExecutableElement;", "method2", "Lcom/squareup/javapoet/MethodSpec;", "types", "Ljavax/lang/model/util/Types;", "elements", "Ljavax/lang/model/util/Elements;", "belongToTheSamePackage", "class1", "Ljavax/lang/model/element/TypeElement;", "class2", "buildEpoxyException", "Lcom/airbnb/epoxy/processor/EpoxyProcessorException;", "msg", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/airbnb/epoxy/processor/EpoxyProcessorException;", "capitalizeFirstLetter", "original", "getAnnotationMirror", "Ljavax/lang/model/element/AnnotationMirror;", "typeElement", "Ljavax/lang/model/element/Element;", "annotationClass", "Ljava/lang/Class;", "", "getAnnotationValue", "Ljavax/lang/model/element/AnnotationValue;", "annotationMirror", "key", "getClass", "name", "Lcom/squareup/javapoet/ClassName;", "getClassParamFromAnnotation", "T", "annotatedElement", "paramName", "typeUtils", "getDefaultValue", "attributeType", "Lcom/squareup/javapoet/TypeName;", "getElementByName", "getElementByNameNullable", "getEpoxyObjectType", "Ljavax/lang/model/type/TypeMirror;", "clazz", "getMethodOnClass", "method", "implementsMethod", "isAssignable", "e1", "e2", "isController", "element", "isDataBindingModel", "type", "isEpoxyModel", "isEpoxyModelWithHolder", "isFieldPackagePrivate", "isIterableType", "isSetterMethod", "isSubtype", "isSubtypeOfType", "typeMirror", "otherType", "isType", "removeSetPrefix", "string", "startsWithIs", "throwError", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "toSnakeCase", "s", "validateFieldAccessibleViaGeneratedCode", "fieldElement", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "skipPrivateFieldCheck", "epoxy-processor"})
public final class Utils {
    private static final Pattern PATTERN_STARTS_WITH_SET;
    @NotNull
    public static final String EPOXY_MODEL_TYPE = "com.airbnb.epoxy.EpoxyModel<?>";
    @NotNull
    public static final String UNTYPED_EPOXY_MODEL_TYPE = "com.airbnb.epoxy.EpoxyModel";
    @NotNull
    public static final String EPOXY_MODEL_WITH_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyModelWithHolder<?>";
    @NotNull
    public static final String EPOXY_VIEW_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyViewHolder";
    @NotNull
    public static final String EPOXY_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyHolder";
    @NotNull
    public static final String ANDROID_VIEW_TYPE = "android.view.View";
    @NotNull
    public static final String EPOXY_CONTROLLER_TYPE = "com.airbnb.epoxy.EpoxyController";
    @NotNull
    public static final String VIEW_CLICK_LISTENER_TYPE = "android.view.View.OnClickListener";
    @NotNull
    public static final String VIEW_LONG_CLICK_LISTENER_TYPE = "android.view.View.OnLongClickListener";
    @NotNull
    public static final String VIEW_CHECKED_CHANGE_LISTENER_TYPE = "android.widget.CompoundButton.OnCheckedChangeListener";
    @NotNull
    public static final String GENERATED_MODEL_INTERFACE = "com.airbnb.epoxy.GeneratedModel";
    @NotNull
    public static final String MODEL_CLICK_LISTENER_TYPE = "com.airbnb.epoxy.OnModelClickListener";
    @NotNull
    public static final String MODEL_LONG_CLICK_LISTENER_TYPE = "com.airbnb.epoxy.OnModelLongClickListener";
    @NotNull
    public static final String MODEL_CHECKED_CHANGE_LISTENER_TYPE = "com.airbnb.epoxy.OnModelCheckedChangeListener";
    @NotNull
    public static final String ON_BIND_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelBoundListener";
    @NotNull
    public static final String ON_UNBIND_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelUnboundListener";
    @NotNull
    public static final String WRAPPED_LISTENER_TYPE = "com.airbnb.epoxy.WrappedEpoxyModelClickListener";
    @NotNull
    public static final String WRAPPED_CHECKED_LISTENER_TYPE = "com.airbnb.epoxy.WrappedEpoxyModelCheckedChangeListener";
    @NotNull
    public static final String DATA_BINDING_MODEL_TYPE = "com.airbnb.epoxy.DataBindingEpoxyModel";
    @NotNull
    public static final String ON_VISIBILITY_STATE_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelVisibilityStateChangedListener";
    @NotNull
    public static final String ON_VISIBILITY_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelVisibilityChangedListener";
    @NotNull
    public static final Utils INSTANCE;

    @JvmStatic
    public static final void throwError(@Nullable String msg, Object ... args) throws EpoxyProcessorException {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = msg;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        throw (Throwable)new EpoxyProcessorException(string3, null, 2, null);
    }

    @Nullable
    public final Class<?> getClass(@NotNull ClassName name) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            clazz = Class.forName(name.reflectionName());
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        catch (NoClassDefFoundError e) {
            clazz = null;
        }
        return clazz;
    }

    @NotNull
    public final TypeElement getElementByName(@NotNull ClassName name, @NotNull Elements elements, @NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        TypeElement typeElement = this.getElementByNameNullable(name, elements, types);
        if (typeElement == null) {
            String string = "No element found for " + name;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return typeElement;
    }

    @Nullable
    public final TypeElement getElementByNameNullable(@NotNull ClassName name, @NotNull Elements elements, @NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        String string = name.reflectionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.reflectionName()");
        String canonicalName = StringsKt.replace$default((String)string, (String)"$", (String)".", (boolean)false, (int)4, null);
        return (TypeElement)this.getElementByNameNullable(canonicalName, elements, types);
    }

    @NotNull
    public final Element getElementByName(@NotNull String name, @NotNull Elements elements, @NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Element element = this.getElementByNameNullable(name, elements, types);
        if (element == null) {
            String string = "Could not by element with name " + name;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Element getElementByNameNullable(@Nullable String name, @NotNull Elements elements, @NotNull Types types) {
        Element element;
        Element element2;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        boolean $i$f$synchronizedForTypeLookup = false;
        if (SynchronizationKt.getSynchronizationEnabled()) {
            Mutex mutex = SynchronizationKt.getTypeLookupMutex();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (mutex) {
                Element element3;
                boolean bl3 = false;
                try {
                    element3 = elements.getTypeElement(name);
                }
                catch (MirroredTypeException mte) {
                    element3 = types.asElement(mte.getTypeMirror());
                }
                Element element4 = element3;
                Element element5 = element4 != null ? SynchronizationKt.ensureLoaded(element4) : null;
                // MONITOREXIT @DISABLED, blocks:[0, 3, 7] lbl20 : MonitorExitStatement: MONITOREXIT : var5_5
                element2 = element5;
            }
        }
        boolean bl = false;
        try {
            element = elements.getTypeElement(name);
        }
        catch (MirroredTypeException mte) {
            element = types.asElement(mte.getTypeMirror());
        }
        Element element6 = element;
        element2 = element6 != null ? SynchronizationKt.ensureLoaded(element6) : null;
        return element2;
    }

    @JvmStatic
    @NotNull
    public static final EpoxyProcessorException buildEpoxyException(@Nullable String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = msg;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        return new EpoxyProcessorException(string3, null, 2, null);
    }

    @JvmStatic
    public static final boolean isIterableType(@NotNull TypeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeMirror typeMirror = element.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"element.asType()");
        return Utils.isSubtypeOfType(typeMirror, "java.lang.Iterable<?>");
    }

    public final boolean isController(@NotNull TypeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeMirror typeMirror = element.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"element.asType()");
        return Utils.isSubtypeOfType(typeMirror, EPOXY_CONTROLLER_TYPE);
    }

    @JvmStatic
    public static final boolean isEpoxyModel(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Utils.isSubtypeOfType(type, EPOXY_MODEL_TYPE) || Utils.isSubtypeOfType(type, UNTYPED_EPOXY_MODEL_TYPE);
    }

    public final boolean isEpoxyModel(@NotNull TypeElement type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeMirror typeMirror = type.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"type.asType()");
        return Utils.isEpoxyModel(typeMirror);
    }

    public final boolean isEpoxyModelWithHolder(@NotNull TypeElement type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeMirror typeMirror = type.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"type.asType()");
        return Utils.isSubtypeOfType(typeMirror, EPOXY_MODEL_WITH_HOLDER_TYPE);
    }

    public final boolean isDataBindingModel(@NotNull TypeElement type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeMirror typeMirror = type.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"type.asType()");
        return Utils.isSubtypeOfType(typeMirror, DATA_BINDING_MODEL_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isSubtypeOfType(@NotNull TypeMirror typeMirror, @NotNull String otherType) {
        boolean bl;
        block33: {
            TypeMirror superType;
            Element element;
            Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
            Intrinsics.checkNotNullParameter((Object)otherType, (String)"otherType");
            boolean $i$f$synchronizedForTypeLookup = false;
            if (SynchronizationKt.getSynchronizationEnabled()) {
                Mutex mutex = SynchronizationKt.getTypeLookupMutex();
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (mutex) {
                    boolean bl4;
                    block32: {
                        TypeElement element2;
                        block31: {
                            TypeMirror superType2;
                            TypeElement typeElement;
                            block30: {
                                DeclaredType declaredType;
                                block29: {
                                    block28: {
                                        block27: {
                                            boolean bl5 = false;
                                            if (!Intrinsics.areEqual((Object)otherType, (Object)((Object)typeMirror).toString())) break block27;
                                            boolean bl6 = true;
                                            return bl6;
                                        }
                                        if (typeMirror.getKind() == TypeKind.DECLARED) break block28;
                                        boolean bl7 = false;
                                        return bl7;
                                    }
                                    declaredType = (DeclaredType)typeMirror;
                                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                                    if (typeArguments.size() <= 0) break block29;
                                    StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
                                    typeString.append('<');
                                    int n = 0;
                                    List<? extends TypeMirror> list = typeArguments;
                                    Intrinsics.checkNotNullExpressionValue(list, (String)"typeArguments");
                                    int n2 = ((Collection)list).size();
                                    while (n < n2) {
                                        void i;
                                        if (i > 0) {
                                            typeString.append(',');
                                        }
                                        typeString.append('?');
                                        ++i;
                                    }
                                    typeString.append('>');
                                    if (!Intrinsics.areEqual((Object)typeString.toString(), (Object)otherType)) break block29;
                                    boolean bl8 = true;
                                    return bl8;
                                }
                                Element element3 = declaredType.asElement();
                                if (!(element3 instanceof TypeElement)) {
                                    element3 = null;
                                }
                                if ((TypeElement)element3 != null) break block30;
                                boolean bl9 = false;
                                return bl9;
                            }
                            element2 = typeElement;
                            TypeMirror typeMirror2 = superType2 = element2.getSuperclass();
                            Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"superType");
                            if (!Utils.isSubtypeOfType(typeMirror2, otherType)) break block31;
                            boolean bl10 = true;
                            return bl10;
                        }
                        List<? extends TypeMirror> list = element2.getInterfaces();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"element.interfaces");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                TypeMirror interfaceType = (TypeMirror)element$iv;
                                boolean bl11 = false;
                                TypeMirror typeMirror3 = interfaceType;
                                Intrinsics.checkNotNullExpressionValue((Object)typeMirror3, (String)"interfaceType");
                                if (!Utils.isSubtypeOfType(typeMirror3, otherType)) continue;
                                bl4 = true;
                                break block32;
                            }
                            bl4 = false;
                        }
                    }
                    boolean bl12 = bl4;
                    return bl12;
                }
            }
            boolean bl13 = false;
            if (Intrinsics.areEqual((Object)otherType, (Object)((Object)typeMirror).toString())) {
                return true;
            }
            if (typeMirror.getKind() != TypeKind.DECLARED) {
                return false;
            }
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() > 0) {
                StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
                typeString.append('<');
                int superType3 = 0;
                List<? extends TypeMirror> list = typeArguments;
                Intrinsics.checkNotNullExpressionValue(list, (String)"typeArguments");
                int $this$any$iv = ((Collection)list).size();
                while (superType3 < $this$any$iv) {
                    void i;
                    if (i > 0) {
                        typeString.append(',');
                    }
                    typeString.append('?');
                    ++i;
                }
                typeString.append('>');
                if (Intrinsics.areEqual((Object)typeString.toString(), (Object)otherType)) {
                    return true;
                }
            }
            if (!((element = declaredType.asElement()) instanceof TypeElement)) {
                element = null;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement == null) {
                return false;
            }
            TypeElement element4 = typeElement;
            TypeMirror typeMirror4 = superType = element4.getSuperclass();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror4, (String)"superType");
            if (Utils.isSubtypeOfType(typeMirror4, otherType)) {
                return true;
            }
            List<? extends TypeMirror> list = element4.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(list, (String)"element.interfaces");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeMirror interfaceType = (TypeMirror)element$iv;
                    boolean bl14 = false;
                    TypeMirror typeMirror5 = interfaceType;
                    Intrinsics.checkNotNullExpressionValue((Object)typeMirror5, (String)"interfaceType");
                    if (!Utils.isSubtypeOfType(typeMirror5, otherType)) continue;
                    bl = true;
                    break block33;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean belongToTheSamePackage(@NotNull TypeElement class1, @NotNull TypeElement class2, @NotNull Elements elements) {
        Intrinsics.checkNotNullParameter((Object)class1, (String)"class1");
        Intrinsics.checkNotNullParameter((Object)class2, (String)"class2");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        SynchronizationKt.ensureLoaded((Element)class1);
        SynchronizationKt.ensureLoaded((Element)class2);
        PackageElement packageElement = elements.getPackageOf(class1);
        Intrinsics.checkNotNullExpressionValue((Object)packageElement, (String)"elements.getPackageOf(class1)");
        Name package1 = packageElement.getQualifiedName();
        PackageElement packageElement2 = elements.getPackageOf(class2);
        Intrinsics.checkNotNullExpressionValue((Object)packageElement2, (String)"elements.getPackageOf(class2)");
        Name package2 = packageElement2.getQualifiedName();
        return Intrinsics.areEqual((Object)package1, (Object)package2);
    }

    public final boolean isSubtype(@NotNull TypeElement e1, @NotNull TypeElement e2, @NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        TypeMirror typeMirror = e1.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"e1.asType()");
        TypeMirror typeMirror2 = e2.asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"e2.asType()");
        return Utils.isSubtype(typeMirror, typeMirror2, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean isSubtype(@NotNull TypeMirror e1, @NotNull TypeMirror e2, @NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        boolean $i$f$synchronizedForTypeLookup = false;
        if (SynchronizationKt.getSynchronizationEnabled()) {
            Mutex mutex = SynchronizationKt.getTypeLookupMutex();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (mutex) {
                boolean bl3 = false;
                SynchronizationKt.ensureLoaded(e1);
                SynchronizationKt.ensureLoaded(e2);
                boolean bl4 = types.isSubtype(e1, types.erasure(e2));
                return bl4;
            }
        }
        boolean bl = false;
        SynchronizationKt.ensureLoaded(e1);
        SynchronizationKt.ensureLoaded(e2);
        return types.isSubtype(e1, types.erasure(e2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAssignable(@NotNull TypeMirror e1, @NotNull TypeMirror e2, @NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        boolean $i$f$synchronizedForTypeLookup = false;
        if (SynchronizationKt.getSynchronizationEnabled()) {
            Mutex mutex = SynchronizationKt.getTypeLookupMutex();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (mutex) {
                boolean bl3 = false;
                boolean bl4 = types.isAssignable(e1, e2);
                return bl4;
            }
        }
        boolean bl = false;
        return types.isAssignable(e1, e2);
    }

    @JvmStatic
    public static final boolean isFieldPackagePrivate(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Set<Modifier> modifiers = SynchronizationKt.getModifiersThreadSafe(element);
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    public final boolean implementsMethod(@NotNull TypeElement clazz, @NotNull MethodSpec method, @NotNull Types typeUtils, @NotNull Elements elements) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        ExecutableElement executableElement = Utils.getMethodOnClass(clazz, method, typeUtils, elements);
        if (executableElement == null) {
            return false;
        }
        ExecutableElement methodOnClass = executableElement;
        return !SynchronizationKt.getModifiersThreadSafe(methodOnClass).contains((Object)Modifier.ABSTRACT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final ExecutableElement getMethodOnClass(@NotNull TypeElement clazz, @NotNull MethodSpec method, @NotNull Types typeUtils, @NotNull Elements elements) {
        Iterator<Element> iterator;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        boolean $i$f$synchronizedForTypeLookup = false;
        if (!SynchronizationKt.getSynchronizationEnabled()) {
            boolean bl = false;
            TypeMirror typeMirror = clazz.asType();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"clazz.asType()");
            if (typeMirror.getKind() != TypeKind.DECLARED) {
                return null;
            }
            iterator = SynchronizationKt.getEnclosedElementsThreadSafe(clazz).iterator();
        } else {
            Mutex mutex = SynchronizationKt.getTypeLookupMutex();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (mutex) {
                boolean bl3 = false;
                TypeMirror typeMirror = clazz.asType();
                Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"clazz.asType()");
                if (typeMirror.getKind() != TypeKind.DECLARED) {
                    return null;
                }
                for (Element subElement : SynchronizationKt.getEnclosedElementsThreadSafe(clazz)) {
                    if (subElement.getKind() != ElementKind.METHOD) continue;
                    Element element = subElement;
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
                    }
                    ExecutableElement methodElement = (ExecutableElement)element;
                    if (Intrinsics.areEqual((Object)methodElement.getSimpleName().toString(), (Object)method.name) ^ true || !INSTANCE.areParamsTheSame(methodElement, method, typeUtils, elements)) continue;
                    return methodElement;
                }
                TypeElement typeElement = KotlinUtilsKt.superClassElement(clazz, typeUtils);
                if (typeElement == null) return null;
                TypeElement superClazz = typeElement;
                return Utils.getMethodOnClass(superClazz, method, typeUtils, elements);
            }
        }
        while (iterator.hasNext()) {
            Element subElement = iterator.next();
            if (subElement.getKind() != ElementKind.METHOD) continue;
            Element element = subElement;
            if (element == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
            }
            ExecutableElement methodElement = (ExecutableElement)element;
            if (Intrinsics.areEqual((Object)methodElement.getSimpleName().toString(), (Object)method.name) ^ true || !INSTANCE.areParamsTheSame(methodElement, method, typeUtils, elements)) continue;
            return methodElement;
        }
        TypeElement typeElement = KotlinUtilsKt.superClassElement(clazz, typeUtils);
        if (typeElement == null) return null;
        TypeElement superClazz = typeElement;
        return Utils.getMethodOnClass(superClazz, method, typeUtils, elements);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areParamsTheSame(ExecutableElement method1, MethodSpec method2, Types types, Elements elements) {
        List<VariableElement> params1 = SynchronizationKt.getParametersThreadSafe(method1);
        List params2 = method2.parameters;
        if (params1.size() != params2.size()) {
            return false;
        }
        int n = 0;
        int n2 = ((Collection)params1).size();
        while (n < n2) {
            TypeMirror param1Type;
            TypeMirror typeMirror;
            VariableElement param1;
            void i;
            block7: {
                boolean bl;
                Object object;
                ParameterSpec param2;
                block6: {
                    param1 = params1.get((int)i);
                    Object e = params2.get((int)i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"params2[i]");
                    param2 = (ParameterSpec)e;
                    Intrinsics.checkNotNullExpressionValue((Object)types.erasure(param1.asType()), (String)"types.erasure(param1.asType())");
                    String string = param2.type.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"param2.type.toString()");
                    typeMirror = KotlinUtilsKt.getTypeMirrorNullable(string, elements);
                    if (typeMirror == null) break block6;
                    object = typeMirror;
                    bl = false;
                    boolean bl2 = false;
                    TypeMirror it = object;
                    boolean bl3 = false;
                    typeMirror = types.erasure(it);
                    if (typeMirror != null) break block7;
                }
                object = "Type mirror does not exist for " + param2.type;
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            TypeMirror param2Type = typeMirror;
            TypeMirror typeMirror2 = param1.asType();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"param1.asType()");
            if (typeMirror2.getKind() == TypeKind.TYPEVAR ? !this.isAssignable(param2Type, param1Type, types) : Intrinsics.areEqual((Object)((Object)param1Type).toString(), (Object)((Object)param2Type).toString()) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final TypeMirror getEpoxyObjectType(@NotNull TypeElement clazz, @NotNull Types typeUtils) {
        TypeMirror superTypeArgument;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        boolean $i$f$synchronizedForTypeLookup = false;
        if (SynchronizationKt.getSynchronizationEnabled()) {
            Mutex mutex = SynchronizationKt.getTypeLookupMutex();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (mutex) {
                TypeMirror superTypeArgument2;
                boolean bl3 = false;
                TypeMirror typeMirror = clazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"clazz.superclass");
                if (typeMirror.getKind() != TypeKind.DECLARED) {
                    return null;
                }
                TypeMirror typeMirror2 = clazz.getSuperclass();
                if (typeMirror2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
                }
                DeclaredType superclass = (DeclaredType)typeMirror2;
                Element element = typeUtils.asElement(superclass);
                if (element == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                TypeMirror recursiveResult = INSTANCE.getEpoxyObjectType((TypeElement)element, typeUtils);
                if (recursiveResult != null && recursiveResult.getKind() != TypeKind.TYPEVAR) {
                    return recursiveResult;
                }
                List<? extends TypeMirror> superTypeArguments = superclass.getTypeArguments();
                if (superTypeArguments.size() == 1) {
                    return superTypeArguments.get(0);
                }
                Iterator<? extends TypeMirror> iterator = superTypeArguments.iterator();
                do {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    TypeMirror typeMirror3 = superTypeArgument2 = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)typeMirror3, (String)"superTypeArgument");
                    if (Utils.isSubtypeOfType(typeMirror3, ANDROID_VIEW_TYPE)) return superTypeArgument2;
                } while (!Utils.isSubtypeOfType(superTypeArgument2, EPOXY_HOLDER_TYPE));
                return superTypeArgument2;
            }
        }
        boolean bl = false;
        TypeMirror typeMirror = clazz.getSuperclass();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"clazz.superclass");
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeMirror typeMirror4 = clazz.getSuperclass();
        if (typeMirror4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
        }
        DeclaredType superclass = (DeclaredType)typeMirror4;
        Element element = typeUtils.asElement(superclass);
        if (element == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
        }
        TypeMirror recursiveResult = INSTANCE.getEpoxyObjectType((TypeElement)element, typeUtils);
        if (recursiveResult != null && recursiveResult.getKind() != TypeKind.TYPEVAR) {
            return recursiveResult;
        }
        List<? extends TypeMirror> superTypeArguments = superclass.getTypeArguments();
        if (superTypeArguments.size() == 1) {
            return superTypeArguments.get(0);
        }
        Iterator<? extends TypeMirror> iterator = superTypeArguments.iterator();
        do {
            if (!iterator.hasNext()) {
                return null;
            }
            TypeMirror typeMirror5 = superTypeArgument = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror5, (String)"superTypeArgument");
            if (Utils.isSubtypeOfType(typeMirror5, ANDROID_VIEW_TYPE)) return superTypeArgument;
        } while (!Utils.isSubtypeOfType(superTypeArgument, EPOXY_HOLDER_TYPE));
        return superTypeArgument;
    }

    @JvmOverloads
    public final void validateFieldAccessibleViaGeneratedCode(@NotNull Element fieldElement, @NotNull Class<?> annotationClass, @NotNull Logger logger2, boolean skipPrivateFieldCheck) {
        Intrinsics.checkNotNullParameter((Object)fieldElement, (String)"fieldElement");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Element element = fieldElement.getEnclosingElement();
        if (element == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
        }
        TypeElement enclosingElement = (TypeElement)element;
        Set<Modifier> modifiers = SynchronizationKt.getModifiersThreadSafe(fieldElement);
        if (modifiers.contains((Object)Modifier.PRIVATE) && !skipPrivateFieldCheck || modifiers.contains((Object)Modifier.STATIC)) {
            Object[] objectArray = new Object[3];
            String string = annotationClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.simpleName");
            objectArray[0] = string;
            Name name = enclosingElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"enclosingElement.simpleName");
            objectArray[1] = name;
            Name name2 = fieldElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"fieldElement.simpleName");
            objectArray[2] = name2;
            logger2.logError("%s annotations must not be on private or static fields. (class: %s, field: %s)", objectArray);
        }
        NestingKind nestingKind = enclosingElement.getNestingKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)nestingKind), (String)"enclosingElement.nestingKind");
        if (nestingKind.isNested() && !SynchronizationKt.getModifiersThreadSafe(enclosingElement).contains((Object)Modifier.STATIC)) {
            Object[] objectArray = new Object[3];
            String string = annotationClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.simpleName");
            objectArray[0] = string;
            Name name = enclosingElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"enclosingElement.simpleName");
            objectArray[1] = name;
            Name name3 = fieldElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"fieldElement.simpleName");
            objectArray[2] = name3;
            logger2.logError("Nested classes with %s annotations must be static. (class: %s, field: %s)", objectArray);
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            Object[] objectArray = new Object[3];
            String string = annotationClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.simpleName");
            objectArray[0] = string;
            Name name = enclosingElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"enclosingElement.simpleName");
            objectArray[1] = name;
            Name name4 = fieldElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"fieldElement.simpleName");
            objectArray[2] = name4;
            logger2.logError("%s annotations may only be contained in classes. (class: %s, field: %s)", objectArray);
        }
        if (SynchronizationKt.getModifiersThreadSafe(enclosingElement).contains((Object)Modifier.PRIVATE)) {
            Object[] objectArray = new Object[3];
            String string = annotationClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.simpleName");
            objectArray[0] = string;
            Name name = enclosingElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"enclosingElement.simpleName");
            objectArray[1] = name;
            Name name5 = fieldElement.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"fieldElement.simpleName");
            objectArray[2] = name5;
            logger2.logError("%s annotations may not be contained in private classes. (class: %s, field: %s)", objectArray);
        }
    }

    public static /* synthetic */ void validateFieldAccessibleViaGeneratedCode$default(Utils utils, Element element, Class clazz, Logger logger2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        utils.validateFieldAccessibleViaGeneratedCode(element, clazz, logger2, bl);
    }

    @JvmOverloads
    public final void validateFieldAccessibleViaGeneratedCode(@NotNull Element fieldElement, @NotNull Class<?> annotationClass, @NotNull Logger logger2) {
        Utils.validateFieldAccessibleViaGeneratedCode$default(this, fieldElement, annotationClass, logger2, false, 8, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @Nullable
    public static final String capitalizeFirstLetter(@Nullable String original) {
        String string;
        int n;
        CharSequence charSequence;
        block5: {
            block4: {
                if (original == null) break block4;
                charSequence = original;
                n = 0;
                if (!(charSequence.length() == 0)) break block5;
            }
            string = original;
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        charSequence = original;
        n = 0;
        int n2 = 1;
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)charSequence2).toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        charSequence = original;
        n = 1;
        n2 = 0;
        String string4 = ((String)charSequence).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        string = stringBuilder2.append(string4).toString();
        return string;
    }

    @JvmStatic
    public static final boolean startsWithIs(@NotNull String original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return StringsKt.startsWith$default((String)original, (String)"is", (boolean)false, (int)2, null) && original.length() > 2 && Character.isUpperCase(original.charAt(2));
    }

    public final boolean isSetterMethod(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        ExecutableElement method = (ExecutableElement)element;
        String methodName = method.getSimpleName().toString();
        return PATTERN_STARTS_WITH_SET.matcher(methodName).matches() && SynchronizationKt.getParametersThreadSafe(method).size() == 1;
    }

    @NotNull
    public final String removeSetPrefix(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!PATTERN_STARTS_WITH_SET.matcher(string).matches()) {
            string2 = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(string.charAt(3));
            int n = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            StringBuilder stringBuilder2 = stringBuilder.append(string5);
            string3 = string;
            n = 4;
            boolean bl = false;
            String string6 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string6).toString();
        }
        return string2;
    }

    public final boolean isType(@NotNull TypeMirror typeMirror, @NotNull String otherType) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        Intrinsics.checkNotNullParameter((Object)otherType, (String)"otherType");
        SynchronizationKt.ensureLoaded(typeMirror);
        return Intrinsics.areEqual((Object)otherType, (Object)((Object)typeMirror).toString());
    }

    @Nullable
    public final <T extends Annotation> ClassName getClassParamFromAnnotation(@NotNull Element annotatedElement, @NotNull Class<T> annotationClass, @NotNull String paramName, @NotNull Types typeUtils) {
        ClassName className;
        Intrinsics.checkNotNullParameter((Object)annotatedElement, (String)"annotatedElement");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        AnnotationMirror annotationMirror = this.getAnnotationMirror(annotatedElement, annotationClass);
        if (annotationMirror == null) {
            return null;
        }
        AnnotationMirror am = annotationMirror;
        AnnotationValue av = this.getAnnotationValue(am, paramName);
        if (av == null) {
            className = null;
        } else {
            Object value = av.getValue();
            if (value instanceof TypeMirror) {
                Element element = typeUtils.asElement((TypeMirror)value);
                if (element == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                className = ClassName.get((TypeElement)((TypeElement)element));
            } else {
                className = null;
            }
        }
        return className;
    }

    private final AnnotationMirror getAnnotationMirror(Element typeElement, Class<? extends Annotation> annotationClass) {
        Object v0;
        block1: {
            String clazzName = annotationClass.getName();
            Iterable $this$firstOrNull$iv = SynchronizationKt.getAnnotationMirrorsThreadSafe(typeElement);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationMirror m = (AnnotationMirror)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)m.getAnnotationType().toString(), (Object)clazzName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map2 = annotationMirror.getElementValues();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"annotationMirror.elementValues");
        Object object = map2;
        boolean bl = false;
        Iterator<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key1;
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry;
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            AnnotationValue value = entry2.getValue();
            void v1 = key1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key1");
            if (!Intrinsics.areEqual((Object)v1.getSimpleName().toString(), (Object)key)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    public final String toSnakeCase(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = s;
        String string = "([^_A-Z])([A-Z])";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "$1_$2";
        boolean bl2 = false;
        charSequence = string.replace(charSequence, string2);
        boolean bl3 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)charSequence2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3;
    }

    @NotNull
    public final String getDefaultValue(@NotNull TypeName attributeType) {
        Intrinsics.checkNotNullParameter((Object)attributeType, (String)"attributeType");
        return attributeType == TypeName.BOOLEAN ? "false" : (attributeType == TypeName.INT ? "0" : (attributeType == TypeName.BYTE ? "(byte) 0" : (attributeType == TypeName.CHAR ? "(char) 0" : (attributeType == TypeName.SHORT ? "(short) 0" : (attributeType == TypeName.LONG ? "0L" : (attributeType == TypeName.FLOAT ? "0.0f" : (attributeType == TypeName.DOUBLE ? "0.0d" : "null")))))));
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
        PATTERN_STARTS_WITH_SET = Pattern.compile("set[A-Z]\\w*");
    }
}

