/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.amazonaws.mobileconnectors.appsync.AppSyncQueryWatcher;
import com.amazonaws.mobileconnectors.appsync.fetcher.AppSyncResponseFetchers;
import com.apollographql.apollo.GraphQLCall;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.RealAppSyncCall;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RealAppSyncQueryWatcher<T>
implements AppSyncQueryWatcher<T> {
    private RealAppSyncCall<T> activeCall;
    private ResponseFetcher refetchResponseFetcher = AppSyncResponseFetchers.CACHE_FIRST;
    private final ApolloStore mApolloStore;
    private Set<String> dependentKeys = Collections.emptySet();
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker;
    private final ApolloStore.RecordChangeSubscriber recordChangeSubscriber = new ApolloStore.RecordChangeSubscriber(){

        @Override
        public void onCacheRecordsChanged(Set<String> changedRecordKeys) {
            if (!Utils.areDisjoint((Set)RealAppSyncQueryWatcher.this.dependentKeys, changedRecordKeys)) {
                RealAppSyncQueryWatcher.this.refetch();
            }
        }
    };
    private final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    private final AtomicReference<GraphQLCall.Callback<T>> originalCallback = new AtomicReference();

    RealAppSyncQueryWatcher(RealAppSyncCall<T> originalCall, ApolloStore apolloStore, ApolloLogger logger, ApolloCallTracker tracker) {
        this.activeCall = originalCall;
        this.mApolloStore = apolloStore;
        this.logger = logger;
        this.tracker = tracker;
    }

    @Override
    public AppSyncQueryWatcher<T> enqueueAndWatch(@Nullable GraphQLCall.Callback<T> callback) {
        try {
            this.activate(Optional.fromNullable(callback));
        }
        catch (ApolloCanceledException e) {
            if (callback != null) {
                callback.onCanceledError(e);
            } else {
                this.logger.e((Throwable)e, "Operation: %s was canceled", new Object[]{this.operation().name().name()});
            }
            return this;
        }
        this.activeCall.enqueue(this.callbackProxy());
        return this;
    }

    @Override
    @Nonnull
    public synchronized RealAppSyncQueryWatcher<T> refetchResponseFetcher(@Nonnull ResponseFetcher fetcher) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        Utils.checkNotNull((Object)fetcher, (Object)"responseFetcher == null");
        this.refetchResponseFetcher = fetcher;
        return this;
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                try {
                    this.activeCall.cancel();
                    this.mApolloStore.unsubscribe(this.recordChangeSubscriber);
                    break;
                }
                finally {
                    this.tracker.unregisterQueryWatcher(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.activeCall.operation();
    }

    @Override
    public synchronized void refetch() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.mApolloStore.unsubscribe(this.recordChangeSubscriber);
                this.activeCall.cancel();
                this.activeCall = ((RealAppSyncCall)this.activeCall.clone()).responseFetcher(this.refetchResponseFetcher);
                this.activeCall.enqueue(this.callbackProxy());
                break;
            }
            case IDLE: {
                throw new IllegalStateException("Cannot refetch a watcher which has not first called enqueueAndWatch.");
            }
            case CANCELED: {
                throw new IllegalStateException("Cannot refetch a canceled watcher,");
            }
            case TERMINATED: {
                throw new IllegalStateException("Cannot refetch a watcher which has experienced an error.");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    private GraphQLCall.Callback<T> callbackProxy() {
        return new GraphQLCall.Callback<T>(){

            @Override
            public void onResponse(@Nonnull Response<T> response) {
                Optional callback = RealAppSyncQueryWatcher.this.responseCallback();
                if (!callback.isPresent()) {
                    RealAppSyncQueryWatcher.this.logger.d("onResponse for watched operation: %s. No callback present.", new Object[]{RealAppSyncQueryWatcher.this.operation().name().name()});
                    return;
                }
                RealAppSyncQueryWatcher.this.dependentKeys = response.dependentKeys();
                RealAppSyncQueryWatcher.this.mApolloStore.subscribe(RealAppSyncQueryWatcher.this.recordChangeSubscriber);
                ((GraphQLCall.Callback)callback.get()).onResponse(response);
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                Optional callback = RealAppSyncQueryWatcher.this.terminate();
                if (!callback.isPresent()) {
                    RealAppSyncQueryWatcher.this.logger.d((Throwable)e, "onFailure for operation: %s. No callback present.", new Object[]{RealAppSyncQueryWatcher.this.operation().name().name()});
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    ((GraphQLCall.Callback)callback.get()).onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    ((GraphQLCall.Callback)callback.get()).onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    ((GraphQLCall.Callback)callback.get()).onNetworkError((ApolloNetworkException)e);
                } else {
                    ((GraphQLCall.Callback)callback.get()).onFailure(e);
                }
            }
        };
    }

    private synchronized void activate(Optional<GraphQLCall.Callback<T>> callback) throws ApolloCanceledException {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set((GraphQLCall.Callback<T>)callback.orNull());
                this.tracker.registerQueryWatcher(this);
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException("Call is cancelled.");
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    private synchronized Optional<GraphQLCall.Callback<T>> responseCallback() {
        switch (this.state.get()) {
            case ACTIVE: 
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.get());
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private synchronized Optional<GraphQLCall.Callback<T>> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterQueryWatcher(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }
}

