/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.amazonaws.mobileconnectors.appsync.subscription.SubscriptionResponse;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.json.ApolloJsonReader;
import com.apollographql.apollo.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.internal.json.ResponseJsonStreamReader;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import okhttp3.Response;

public class AppSyncSubscriptionInterceptor
implements ApolloInterceptor {
    private final SubscriptionManager mSubscriptionManager;
    private final ResponseNormalizer<Map<String, Object>> mapResponseNormalizer;

    public AppSyncSubscriptionInterceptor(SubscriptionManager subscriptionManager, ResponseNormalizer<Map<String, Object>> mapResponseNormalizer) {
        this.mSubscriptionManager = subscriptionManager;
        this.mapResponseNormalizer = mapResponseNormalizer;
    }

    @Override
    public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, final @Nonnull Executor dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        boolean isSubscription = request.operation instanceof Subscription;
        if (!isSubscription) {
            chain.proceedAsync(request, dispatcher, callBack);
            return;
        }
        chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(final @Nonnull ApolloInterceptor.InterceptorResponse response) {
                dispatcher.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map<String, Object> responseMap = null;
                        try {
                            ResponseJsonStreamReader responseStreamReader = ApolloJsonReader.responseJsonStreamReader(new BufferedSourceJsonReader(((Response)response.httpResponse.get()).body().source()));
                            responseMap = responseStreamReader.toMap();
                            Map extensions = (Map)responseMap.get("extensions");
                            Map subscriptions = (Map)extensions.get("subscription");
                            List mqttConnections = (List)subscriptions.get("mqttConnections");
                            ArrayList<String> newTopics = new ArrayList<String>();
                            Collection newSubscriptions = ((Map)subscriptions.get("newSubscriptions")).values();
                            for (Object newSub : newSubscriptions) {
                                if (!newSub.containsKey("topic")) continue;
                                newTopics.add((String)newSub.get("topic"));
                            }
                            SubscriptionResponse subscriptionResponse = new SubscriptionResponse();
                            for (Map mqttConnection : mqttConnections) {
                                String clientId = (String)mqttConnection.get("client");
                                String wssURI = (String)mqttConnection.get("url");
                                String[] topics = ((List)mqttConnection.get("topics")).toArray(new String[0]);
                                subscriptionResponse.add(new SubscriptionResponse.MqttInfo(clientId, wssURI, topics));
                            }
                            AppSyncSubscriptionInterceptor.this.mSubscriptionManager.subscribe((Subscription)request.operation, newTopics, subscriptionResponse, AppSyncSubscriptionInterceptor.this.mapResponseNormalizer);
                            com.apollographql.apollo.api.Response parsedResponse = AppSyncSubscriptionInterceptor.this.parseSubscription(request.operation, response);
                            callBack.onResponse(new ApolloInterceptor.InterceptorResponse((Response)response.httpResponse.get(), parsedResponse, null));
                        }
                        catch (Exception e) {
                            try {
                                callBack.onFailure(new ApolloException("Failed to parse subscription response: " + responseMap, e));
                            }
                            catch (Exception e1) {
                                callBack.onFailure(new ApolloException("Failed to parse subscription response, failed to get body string", e));
                            }
                        }
                        finally {
                            callBack.onCompleted();
                        }
                    }
                });
            }

            @Override
            public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                callBack.onFetch(sourceType);
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                callBack.onFailure(e);
            }

            @Override
            public void onCompleted() {
            }
        });
    }

    private <W> com.apollographql.apollo.api.Response<W> parseSubscription(Operation<?, W, ?> operation, ApolloInterceptor.InterceptorResponse response) {
        return com.apollographql.apollo.api.Response.builder(operation).data(null).build();
    }

    @Override
    public void dispose() {
    }
}

