/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.response;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import com.apollographql.apollo.internal.response.ResponseReaderShadow;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RealResponseReader<R>
implements ResponseReader {
    private final Operation.Variables operationVariables;
    private final R recordSet;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final FieldValueResolver<R> fieldValueResolver;
    private final ResponseReaderShadow<R> readerShadow;
    private final Map<String, Object> variableValues;

    public RealResponseReader(Operation.Variables operationVariables, R recordSet, FieldValueResolver<R> fieldValueResolver, ScalarTypeAdapters scalarTypeAdapters, ResponseReaderShadow<R> readerShadow) {
        this.operationVariables = operationVariables;
        this.recordSet = recordSet;
        this.fieldValueResolver = fieldValueResolver;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.readerShadow = readerShadow;
        this.variableValues = operationVariables.valueMap();
    }

    public String readString(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value;
    }

    public Integer readInt(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    public Long readLong(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public Double readDouble(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    public Boolean readBoolean(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        Boolean value = (Boolean)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value;
    }

    public <T> T readObject(ResponseField field, ResponseReader.ObjectReader<T> objectReader) {
        Object parsedValue;
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        Object value = this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.readerShadow.willResolveObject(field, Optional.fromNullable(value));
        if (value == null) {
            this.readerShadow.didResolveNull();
            parsedValue = null;
        } else {
            parsedValue = objectReader.read(new RealResponseReader(this.operationVariables, value, this.fieldValueResolver, this.scalarTypeAdapters, this.readerShadow));
        }
        this.readerShadow.didResolveObject(field, Optional.fromNullable(value));
        this.didResolve(field);
        return (T)parsedValue;
    }

    public <T> List<T> readList(ResponseField field, ResponseReader.ListReader<T> listReader) {
        ArrayList<Object> result;
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        List values = (List)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, values);
        if (values == null) {
            this.readerShadow.didResolveNull();
            result = null;
        } else {
            result = new ArrayList<Object>();
            for (int i = 0; i < values.size(); ++i) {
                this.readerShadow.willResolveElement(i);
                Object value = values.get(i);
                if (value != null) {
                    Object item = listReader.read((ResponseReader.ListItemReader)new ListItemReader(field, value));
                    result.add(item);
                }
                this.readerShadow.didResolveElement(i);
            }
            this.readerShadow.didResolveList(values);
        }
        this.didResolve(field);
        return result != null ? Collections.unmodifiableList(result) : null;
    }

    public <T> T readCustomType(ResponseField.CustomTypeField field) {
        T result;
        if (this.shouldSkip((ResponseField)field)) {
            return null;
        }
        this.willResolve((ResponseField)field);
        Object value = this.fieldValueResolver.valueFor(this.recordSet, (ResponseField)field);
        this.checkValue((ResponseField)field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
            result = null;
        } else {
            CustomTypeAdapter typeAdapter = this.scalarTypeAdapters.adapterFor(field.scalarType());
            this.readerShadow.didResolveScalar(value);
            result = typeAdapter.decode(value.toString());
        }
        this.didResolve((ResponseField)field);
        return result;
    }

    public <T> T readConditional(ResponseField field, ResponseReader.ConditionalTypeReader<T> conditionalTypeReader) {
        if (this.shouldSkip(field)) {
            return null;
        }
        this.willResolve(field);
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            this.readerShadow.didResolveNull();
            this.didResolve(field);
            return null;
        }
        this.readerShadow.didResolveScalar(value);
        this.didResolve(field);
        if (field.type() == ResponseField.Type.INLINE_FRAGMENT) {
            for (ResponseField.Condition condition : field.conditions()) {
                if (!(condition instanceof ResponseField.TypeNameCondition) || !((ResponseField.TypeNameCondition)condition).typeName().equals(value)) continue;
                return (T)conditionalTypeReader.read(value, (ResponseReader)this);
            }
            return null;
        }
        return (T)conditionalTypeReader.read(value, (ResponseReader)this);
    }

    private boolean shouldSkip(ResponseField field) {
        for (ResponseField.Condition condition : field.conditions()) {
            if (!(condition instanceof ResponseField.BooleanCondition)) continue;
            ResponseField.BooleanCondition booleanCondition = (ResponseField.BooleanCondition)condition;
            Boolean conditionValue = (Boolean)this.variableValues.get(booleanCondition.variableName());
            if (!(booleanCondition.inverted() ? conditionValue == Boolean.TRUE : conditionValue == Boolean.FALSE)) continue;
            return true;
        }
        return false;
    }

    private void willResolve(ResponseField field) {
        this.readerShadow.willResolve(field, this.operationVariables);
    }

    private void didResolve(ResponseField field) {
        this.readerShadow.didResolve(field, this.operationVariables);
    }

    private void checkValue(ResponseField field, Object value) {
        if (!field.optional() && value == null) {
            throw new NullPointerException("corrupted response reader, expected non null value for " + field.fieldName());
        }
    }

    private class ListItemReader
    implements ResponseReader.ListItemReader {
        private final ResponseField field;
        private final Object value;

        ListItemReader(ResponseField field, Object value) {
            this.field = field;
            this.value = value;
        }

        public String readString() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return (String)this.value;
        }

        public Integer readInt() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return ((BigDecimal)this.value).intValue();
        }

        public Long readLong() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return ((BigDecimal)this.value).longValue();
        }

        public Double readDouble() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return ((BigDecimal)this.value).doubleValue();
        }

        public Boolean readBoolean() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return (Boolean)this.value;
        }

        public <T> T readCustomType(ScalarType scalarType) {
            CustomTypeAdapter typeAdapter = RealResponseReader.this.scalarTypeAdapters.adapterFor(scalarType);
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return typeAdapter.decode(this.value.toString());
        }

        public <T> T readObject(ResponseReader.ObjectReader<T> objectReader) {
            Object value = this.value;
            RealResponseReader.this.readerShadow.willResolveObject(this.field, Optional.fromNullable((Object)value));
            Object item = objectReader.read(new RealResponseReader<Object>(RealResponseReader.this.operationVariables, value, RealResponseReader.this.fieldValueResolver, RealResponseReader.this.scalarTypeAdapters, RealResponseReader.this.readerShadow));
            RealResponseReader.this.readerShadow.didResolveObject(this.field, Optional.fromNullable((Object)value));
            return (T)item;
        }

        public <T> List<T> readList(ResponseReader.ListReader<T> listReader) {
            List values = (List)this.value;
            if (values == null) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < values.size(); ++i) {
                RealResponseReader.this.readerShadow.willResolveElement(i);
                Object value = values.get(i);
                if (value != null) {
                    Object item = listReader.read((ResponseReader.ListItemReader)new ListItemReader(this.field, value));
                    result.add(item);
                }
                RealResponseReader.this.readerShadow.didResolveElement(i);
            }
            RealResponseReader.this.readerShadow.didResolveList(values);
            return Collections.unmodifiableList(result);
        }
    }
}

