/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.cache.normalized.CacheKey;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class CacheKeyResolver {
    public static final CacheKeyResolver DEFAULT = new CacheKeyResolver(){

        @Override
        @Nonnull
        public CacheKey fromFieldRecordSet(@Nonnull ResponseField field, @Nonnull Map<String, Object> recordSet) {
            return CacheKey.NO_KEY;
        }

        @Override
        @Nonnull
        public CacheKey fromFieldArguments(@Nonnull ResponseField field, @Nonnull Operation.Variables variables) {
            return CacheKey.NO_KEY;
        }
    };
    public static final CacheKey QUERY_ROOT_KEY = CacheKey.from("QUERY_ROOT");
    public static final CacheKey MUTATION_ROOT_KEY = CacheKey.from("MUTATION_ROOT");
    public static final CacheKey SUBSCRIPTION_ROOT_KEY = CacheKey.from("SUBSCRIPTION_ROOT");

    public static CacheKey rootKeyForOperation(@Nonnull Operation operation) {
        if (operation instanceof Query) {
            return QUERY_ROOT_KEY;
        }
        if (operation instanceof Mutation) {
            return MUTATION_ROOT_KEY;
        }
        if (operation instanceof Subscription) {
            return SUBSCRIPTION_ROOT_KEY;
        }
        throw new IllegalArgumentException("Unknown operation type.");
    }

    @Nonnull
    public abstract CacheKey fromFieldRecordSet(@Nonnull ResponseField var1, @Nonnull Map<String, Object> var2);

    @Nonnull
    public abstract CacheKey fromFieldArguments(@Nonnull ResponseField var1, @Nonnull Operation.Variables var2);
}

