/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.amazonaws.mobileconnectors.appsync.AppSyncSubscriptionCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.GraphQLCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.RealAppSyncCall;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class RealAppSyncSubscriptionCall<T>
implements AppSyncSubscriptionCall<T> {
    private final Subscription<?, T, ?> subscription;
    private final SubscriptionManager subscriptionManager;
    private final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    private final ApolloClient apolloClient;
    private final RealAppSyncCall<T> solicitingCall;
    private AppSyncSubscriptionCall.Callback<T> userCallback;

    public RealAppSyncSubscriptionCall(Subscription<?, T, ?> subscription, SubscriptionManager subscriptionManager, ApolloClient apolloClient, RealAppSyncCall<T> solicitingCall) {
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
        this.apolloClient = apolloClient;
        this.solicitingCall = solicitingCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final @Nonnull AppSyncSubscriptionCall.Callback<T> callback) {
        Utils.checkNotNull(callback, (Object)"callback == null");
        this.userCallback = callback;
        this.subscriptionManager.addListener(this.subscription, callback);
        RealAppSyncSubscriptionCall realAppSyncSubscriptionCall = this;
        synchronized (realAppSyncSubscriptionCall) {
            switch (this.state.get()) {
                case IDLE: {
                    this.state.set(CallState.ACTIVE);
                    break;
                }
                case CANCELED: {
                    throw new RuntimeException("Cancelled", new ApolloCanceledException("Call is cancelled."));
                }
                case ACTIVE: {
                    throw new IllegalStateException("Already Executed");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
        this.solicitingCall.enqueue(new GraphQLCall.Callback<T>(){

            @Override
            public void onResponse(@Nonnull Response<T> response) {
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                callback.onFailure(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        RealAppSyncSubscriptionCall realAppSyncSubscriptionCall = this;
        synchronized (realAppSyncSubscriptionCall) {
            switch (this.state.get()) {
                case IDLE: {
                    this.state.set(CallState.CANCELED);
                    break;
                }
                case ACTIVE: {
                    try {
                        this.subscriptionManager.unsubscribe(this.subscription);
                        this.subscriptionManager.removeListener(this.subscription, this.userCallback);
                        this.userCallback.onCompleted();
                        this.userCallback = null;
                        break;
                    }
                    finally {
                        this.state.set(CallState.CANCELED);
                    }
                }
                case CANCELED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    @Override
    public AppSyncSubscriptionCall<T> clone() {
        return new RealAppSyncSubscriptionCall<T>(this.subscription, this.subscriptionManager, this.apolloClient, this.solicitingCall.clone());
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }
}

