/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class CacheResponseWriter
implements ResponseWriter {
    private final Operation.Variables operationVariables;
    private final ScalarTypeAdapters scalarTypeAdapters;
    final Map<String, FieldDescriptor> fieldDescriptors = new LinkedHashMap<String, FieldDescriptor>();

    CacheResponseWriter(Operation.Variables operationVariables, ScalarTypeAdapters scalarTypeAdapters) {
        this.operationVariables = operationVariables;
        this.scalarTypeAdapters = scalarTypeAdapters;
    }

    public void writeString(@Nonnull ResponseField field, @Nullable String value) {
        this.writeScalarFieldValue(field, value);
    }

    public void writeInt(@Nonnull ResponseField field, @Nullable Integer value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value.intValue()) : null);
    }

    public void writeLong(@Nonnull ResponseField field, @Nullable Long value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value) : null);
    }

    public void writeDouble(@Nonnull ResponseField field, @Nullable Double value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value) : null);
    }

    public void writeBoolean(@Nonnull ResponseField field, @Nullable Boolean value) {
        this.writeScalarFieldValue(field, value);
    }

    public void writeCustom(@Nonnull ResponseField.CustomTypeField field, @Nullable Object value) {
        CustomTypeAdapter<Object> typeAdapter = this.scalarTypeAdapters.adapterFor(field.scalarType());
        this.writeScalarFieldValue((ResponseField)field, value != null ? typeAdapter.encode(value) : null);
    }

    public void writeObject(@Nonnull ResponseField field, @Nullable ResponseFieldMarshaller marshaller) {
        CacheResponseWriter.checkFieldValue(field, marshaller);
        if (marshaller == null) {
            this.fieldDescriptors.put(field.responseName(), new FieldDescriptor(field, null));
            return;
        }
        CacheResponseWriter nestedResponseWriter = new CacheResponseWriter(this.operationVariables, this.scalarTypeAdapters);
        marshaller.marshal((ResponseWriter)nestedResponseWriter);
        this.fieldDescriptors.put(field.responseName(), new FieldDescriptor(field, nestedResponseWriter.fieldDescriptors));
    }

    public void writeList(@Nonnull ResponseField field, @Nullable List values, @Nonnull ResponseWriter.ListWriter listWriter) {
        CacheResponseWriter.checkFieldValue(field, values);
        if (values == null) {
            this.fieldDescriptors.put(field.responseName(), new FieldDescriptor(field, null));
            return;
        }
        List items = this.writeListItemValues(values, listWriter);
        this.fieldDescriptors.put(field.responseName(), new FieldDescriptor(field, items));
    }

    public Collection<Record> normalize(ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        this.normalize(this.operationVariables, responseNormalizer, this.fieldDescriptors);
        return responseNormalizer.records();
    }

    private List writeListItemValues(List values, ResponseWriter.ListWriter listWriter) {
        ListItemWriter listItemWriter = new ListItemWriter(this.operationVariables, this.scalarTypeAdapters);
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof List) {
                List nestedItems = this.writeListItemValues((List)value, listWriter);
                items.add(nestedItems);
                continue;
            }
            listWriter.write(value, (ResponseWriter.ListItemWriter)listItemWriter);
            items.add(listItemWriter.value);
        }
        return items;
    }

    private void writeScalarFieldValue(ResponseField field, Object value) {
        CacheResponseWriter.checkFieldValue(field, value);
        this.fieldDescriptors.put(field.responseName(), new FieldDescriptor(field, value));
    }

    private Map<String, Object> rawFieldValues(Map<String, FieldDescriptor> fieldDescriptors) {
        LinkedHashMap<String, Object> fieldValues = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, FieldDescriptor> entry : fieldDescriptors.entrySet()) {
            String fieldResponseName = entry.getKey();
            Object fieldValue = entry.getValue().value;
            if (fieldValue == null) {
                fieldValues.put(fieldResponseName, null);
                continue;
            }
            if (fieldValue instanceof Map) {
                Map<String, Object> nestedMap = this.rawFieldValues((Map)fieldValue);
                fieldValues.put(fieldResponseName, nestedMap);
                continue;
            }
            if (fieldValue instanceof List) {
                fieldValues.put(fieldResponseName, this.rawListFieldValues((List)fieldValue));
                continue;
            }
            fieldValues.put(fieldResponseName, fieldValue);
        }
        return fieldValues;
    }

    private List rawListFieldValues(List values) {
        ArrayList<Object> listValues = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof Map) {
                listValues.add(this.rawFieldValues((Map)value));
                continue;
            }
            if (value instanceof List) {
                listValues.add(this.rawListFieldValues((List)value));
                continue;
            }
            listValues.add(value);
        }
        return listValues;
    }

    private void normalize(Operation.Variables operationVariables, ResponseNormalizer<Map<String, Object>> responseNormalizer, Map<String, FieldDescriptor> fieldDescriptors) {
        Map<String, Object> rawFieldValues = this.rawFieldValues(fieldDescriptors);
        for (String fieldResponseName : fieldDescriptors.keySet()) {
            FieldDescriptor fieldDescriptor = fieldDescriptors.get(fieldResponseName);
            Object rawFieldValue = rawFieldValues.get(fieldResponseName);
            responseNormalizer.willResolve(fieldDescriptor.field, operationVariables);
            switch (fieldDescriptor.field.type()) {
                case OBJECT: {
                    this.normalizeObjectField(fieldDescriptor, (Map)rawFieldValue, responseNormalizer);
                    break;
                }
                case LIST: {
                    this.normalizeList(fieldDescriptor.field, (List)fieldDescriptor.value, (List)rawFieldValue, responseNormalizer);
                    break;
                }
                default: {
                    if (rawFieldValue == null) {
                        responseNormalizer.didResolveNull();
                        break;
                    }
                    responseNormalizer.didResolveScalar(rawFieldValue);
                }
            }
            responseNormalizer.didResolve(fieldDescriptor.field, operationVariables);
        }
    }

    private void normalizeObjectField(FieldDescriptor fieldDescriptor, Map<String, Object> rawFieldValues, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        responseNormalizer.willResolveObject(fieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(rawFieldValues));
        if (fieldDescriptor.value == null) {
            responseNormalizer.didResolveNull();
        } else {
            this.normalize(this.operationVariables, responseNormalizer, (Map)fieldDescriptor.value);
        }
        responseNormalizer.didResolveObject(fieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(rawFieldValues));
    }

    private void normalizeList(ResponseField listResponseField, List fieldValues, List rawFieldValues, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        if (fieldValues == null) {
            responseNormalizer.didResolveNull();
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            responseNormalizer.willResolveElement(i);
            Object fieldValue = fieldValues.get(i);
            if (fieldValue instanceof Map) {
                responseNormalizer.willResolveObject(listResponseField, (Optional<Map<String, Object>>)Optional.fromNullable((Object)((Map)rawFieldValues.get(i))));
                this.normalize(this.operationVariables, responseNormalizer, (Map)fieldValue);
                responseNormalizer.didResolveObject(listResponseField, (Optional<Map<String, Object>>)Optional.fromNullable((Object)((Map)rawFieldValues.get(i))));
            } else if (fieldValue instanceof List) {
                this.normalizeList(listResponseField, (List)fieldValue, (List)rawFieldValues.get(i), responseNormalizer);
            } else {
                responseNormalizer.didResolveScalar(rawFieldValues.get(i));
            }
            responseNormalizer.didResolveElement(i);
        }
        responseNormalizer.didResolveList(rawFieldValues);
    }

    private static void checkFieldValue(ResponseField field, Object value) {
        if (!field.optional() && value == null) {
            throw new NullPointerException(String.format("Mandatory response field `%s` resolved with null value", field.responseName()));
        }
    }

    private static class FieldDescriptor {
        final ResponseField field;
        final Object value;

        FieldDescriptor(ResponseField field, Object value) {
            this.field = field;
            this.value = value;
        }
    }

    private static final class ListItemWriter
    implements ResponseWriter.ListItemWriter {
        final Operation.Variables operationVariables;
        final ScalarTypeAdapters scalarTypeAdapters;
        Object value;

        ListItemWriter(Operation.Variables operationVariables, ScalarTypeAdapters scalarTypeAdapters) {
            this.operationVariables = operationVariables;
            this.scalarTypeAdapters = scalarTypeAdapters;
        }

        public void writeString(@Nullable Object value) {
            this.value = value;
        }

        public void writeInt(@Nullable Object value) {
            this.value = value != null ? BigDecimal.valueOf(((Integer)value).intValue()) : null;
        }

        public void writeLong(@Nullable Object value) {
            this.value = value != null ? BigDecimal.valueOf((Long)value) : null;
        }

        public void writeDouble(@Nullable Object value) {
            this.value = value != null ? BigDecimal.valueOf((Double)value) : null;
        }

        public void writeBoolean(@Nullable Object value) {
            this.value = value;
        }

        public void writeCustom(@Nonnull ScalarType scalarType, @Nullable Object value) {
            CustomTypeAdapter<Object> typeAdapter = this.scalarTypeAdapters.adapterFor(scalarType);
            this.value = value != null ? typeAdapter.encode(value) : null;
        }

        public void writeObject(ResponseFieldMarshaller marshaller) {
            CacheResponseWriter nestedResponseWriter = new CacheResponseWriter(this.operationVariables, this.scalarTypeAdapters);
            marshaller.marshal((ResponseWriter)nestedResponseWriter);
            this.value = nestedResponseWriter.fieldDescriptors;
        }
    }
}

