/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.json.InputFieldJsonWriter;
import com.apollographql.apollo.internal.json.JsonWriter;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class ApolloServerInterceptor
implements ApolloInterceptor {
    private static final String HEADER_ACCEPT_TYPE = "Accept";
    private static final String HEADER_CONTENT_TYPE = "CONTENT_TYPE";
    private static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    private static final String ACCEPT_TYPE = "application/json";
    private static final String CONTENT_TYPE = "application/json";
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final Optional<HttpCachePolicy.Policy> cachePolicy;
    final boolean prefetch;
    final ApolloLogger logger;
    final ScalarTypeAdapters scalarTypeAdapters;
    final boolean sendOperationIdentifiers;
    volatile Call httpCall;
    volatile boolean disposed;

    public ApolloServerInterceptor(@Nonnull HttpUrl serverUrl, @Nonnull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @Nonnull ScalarTypeAdapters scalarTypeAdapters, @Nonnull ApolloLogger logger, boolean sendOperationIdentifiers) {
        this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null");
        this.httpCallFactory = (Call.Factory)Utils.checkNotNull((Object)httpCallFactory, (Object)"httpCallFactory == null");
        this.cachePolicy = Optional.fromNullable((Object)cachePolicy);
        this.prefetch = prefetch;
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.sendOperationIdentifiers = sendOperationIdentifiers;
    }

    @Override
    public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, @Nonnull Executor dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        if (this.disposed) {
            return;
        }
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                callBack.onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
                try {
                    ApolloServerInterceptor.this.httpCall = ApolloServerInterceptor.this.httpCall(request.operation);
                }
                catch (IOException e) {
                    ApolloServerInterceptor.this.logger.e((Throwable)e, "Failed to prepare http call for operation %s", new Object[]{request.operation.name().name()});
                    callBack.onFailure(new ApolloNetworkException("Failed to prepare http call", e));
                    return;
                }
                ApolloServerInterceptor.this.httpCall.enqueue(new Callback(){

                    public void onFailure(@Nonnull Call call, @Nonnull IOException e) {
                        if (ApolloServerInterceptor.this.disposed) {
                            return;
                        }
                        ApolloServerInterceptor.this.logger.e((Throwable)e, "Failed to execute http call for operation %s", new Object[]{request.operation.name().name()});
                        callBack.onFailure(new ApolloNetworkException("Failed to execute http call", e));
                    }

                    public void onResponse(@Nonnull Call call, @Nonnull Response response) throws IOException {
                        if (ApolloServerInterceptor.this.disposed) {
                            return;
                        }
                        callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response));
                        callBack.onCompleted();
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
        Call httpCall = this.httpCall;
        if (httpCall != null) {
            httpCall.cancel();
        }
        this.httpCall = null;
    }

    private Call httpCall(Operation operation) throws IOException {
        RequestBody requestBody = this.httpRequestBody(operation);
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).post(requestBody).header(HEADER_ACCEPT_TYPE, "application/json").header(HEADER_CONTENT_TYPE, "application/json").header(HEADER_APOLLO_OPERATION_ID, operation.operationId());
        if (this.cachePolicy.isPresent()) {
            HttpCachePolicy.Policy cachePolicy = (HttpCachePolicy.Policy)this.cachePolicy.get();
            String cacheKey = ApolloServerInterceptor.cacheKey(requestBody);
            requestBuilder = requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch));
        }
        return this.httpCallFactory.newCall(requestBuilder.build());
    }

    private RequestBody httpRequestBody(Operation operation) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.beginObject();
        if (this.sendOperationIdentifiers) {
            jsonWriter.name("id").value(operation.operationId());
        } else {
            jsonWriter.name("query").value(operation.queryDocument().replaceAll("\\n", ""));
        }
        jsonWriter.name("variables").beginObject();
        operation.variables().marshaller().marshal((InputFieldWriter)new InputFieldJsonWriter(jsonWriter, this.scalarTypeAdapters));
        jsonWriter.endObject();
        jsonWriter.endObject();
        jsonWriter.close();
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
    }

    public static String cacheKey(RequestBody requestBody) {
        Buffer hashBuffer = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)hashBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hashBuffer.readByteString().md5().hex();
    }
}

