/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import okhttp3.Response;

public interface ApolloInterceptor {
    public void interceptAsync(@Nonnull InterceptorRequest var1, @Nonnull ApolloInterceptorChain var2, @Nonnull Executor var3, @Nonnull CallBack var4);

    public void dispose();

    public static final class InterceptorRequest {
        public final UUID uniqueId = UUID.randomUUID();
        public final Operation operation;
        public final CacheHeaders cacheHeaders;
        public final boolean fetchFromCache;
        public final Optional<Operation.Data> optimisticUpdates;

        InterceptorRequest(Operation operation, CacheHeaders cacheHeaders, Optional<Operation.Data> optimisticUpdates, boolean fetchFromCache) {
            this.operation = operation;
            this.cacheHeaders = cacheHeaders;
            this.optimisticUpdates = optimisticUpdates;
            this.fetchFromCache = fetchFromCache;
        }

        public Builder toBuilder() {
            return new Builder(this.operation).cacheHeaders(this.cacheHeaders).fetchFromCache(this.fetchFromCache).optimisticUpdates((Operation.Data)this.optimisticUpdates.orNull());
        }

        public static Builder builder(@Nonnull Operation operation) {
            return new Builder(operation);
        }

        public static final class Builder {
            private final Operation operation;
            private CacheHeaders cacheHeaders = CacheHeaders.NONE;
            private boolean fetchFromCache;
            private Optional<Operation.Data> optimisticUpdates = Optional.absent();

            Builder(@Nonnull Operation operation) {
                this.operation = (Operation)Utils.checkNotNull((Object)operation, (Object)"operation == null");
            }

            public Builder cacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
                this.cacheHeaders = (CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
                return this;
            }

            public Builder fetchFromCache(boolean fetchFromCache) {
                this.fetchFromCache = fetchFromCache;
                return this;
            }

            public Builder optimisticUpdates(Operation.Data optimisticUpdates) {
                this.optimisticUpdates = Optional.fromNullable((Object)optimisticUpdates);
                return this;
            }

            public Builder optimisticUpdates(@Nonnull Optional<Operation.Data> optimisticUpdates) {
                this.optimisticUpdates = (Optional)Utils.checkNotNull(optimisticUpdates, (Object)"optimisticUpdates == null");
                return this;
            }

            public InterceptorRequest build() {
                return new InterceptorRequest(this.operation, this.cacheHeaders, this.optimisticUpdates, this.fetchFromCache);
            }
        }
    }

    public static final class InterceptorResponse {
        public final Optional<Response> httpResponse;
        public final Optional<com.apollographql.apollo.api.Response> parsedResponse;
        public final Optional<Collection<Record>> cacheRecords;
        public final Optional<String> clonedBufferString;

        public InterceptorResponse(Response httpResponse) {
            this(httpResponse, null, null);
        }

        public InterceptorResponse(Response httpResponse, com.apollographql.apollo.api.Response parsedResponse, Collection<Record> cacheRecords) {
            this.httpResponse = Optional.fromNullable((Object)httpResponse);
            this.parsedResponse = Optional.fromNullable((Object)parsedResponse);
            this.cacheRecords = Optional.fromNullable(cacheRecords);
            this.clonedBufferString = Optional.fromNullable(null);
        }

        public InterceptorResponse(Response httpResponse, com.apollographql.apollo.api.Response parsedResponse, Collection<Record> cacheRecords, String clonedBufferString) {
            this.httpResponse = Optional.fromNullable((Object)httpResponse);
            this.parsedResponse = Optional.fromNullable((Object)parsedResponse);
            this.cacheRecords = Optional.fromNullable(cacheRecords);
            this.clonedBufferString = Optional.fromNullable((Object)clonedBufferString);
        }
    }

    public static enum FetchSourceType {
        CACHE,
        NETWORK;

    }

    public static interface CallBack {
        public void onResponse(@Nonnull InterceptorResponse var1);

        public void onFetch(FetchSourceType var1);

        public void onFailure(@Nonnull ApolloException var1);

        public void onCompleted();
    }
}

