/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.api.GraphqlFragment;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.GraphQLStoreOperation;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.OptimisticNormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.cache.normalized.CacheResponseWriter;
import com.apollographql.apollo.internal.cache.normalized.ReadableStore;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableStore;
import com.apollographql.apollo.internal.field.CacheFieldValueResolver;
import com.apollographql.apollo.internal.response.RealResponseReader;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RealAppSyncStore
implements ApolloStore,
ReadableStore,
WriteableStore {
    private final OptimisticNormalizedCache optimisticCache;
    private final CacheKeyResolver cacheKeyResolver;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final ReadWriteLock lock;
    private final Set<ApolloStore.RecordChangeSubscriber> subscribers;
    private final Executor dispatcher;
    private final ApolloLogger logger;

    public RealAppSyncStore(@Nonnull NormalizedCache normalizedCache, @Nonnull CacheKeyResolver cacheKeyResolver, @Nonnull ScalarTypeAdapters scalarTypeAdapters, @Nonnull Executor dispatcher, @Nonnull ApolloLogger logger) {
        Utils.checkNotNull((Object)normalizedCache, (Object)"cacheStore == null");
        this.optimisticCache = (OptimisticNormalizedCache)new OptimisticNormalizedCache().chain(normalizedCache);
        this.cacheKeyResolver = (CacheKeyResolver)Utils.checkNotNull((Object)cacheKeyResolver, (Object)"cacheKeyResolver == null");
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.dispatcher = (Executor)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
        this.lock = new ReentrantReadWriteLock();
        this.subscribers = Collections.newSetFromMap(new WeakHashMap());
    }

    @Override
    public ResponseNormalizer<Map<String, Object>> networkResponseNormalizer() {
        return new ResponseNormalizer<Map<String, Object>>(){

            @Override
            @Nonnull
            public CacheKey resolveCacheKey(@Nonnull ResponseField field, @Nonnull Map<String, Object> record) {
                return RealAppSyncStore.this.cacheKeyResolver.fromFieldRecordSet(field, record);
            }
        };
    }

    @Override
    public ResponseNormalizer<Record> cacheResponseNormalizer() {
        return new ResponseNormalizer<Record>(){

            @Override
            @Nonnull
            public CacheKey resolveCacheKey(@Nonnull ResponseField field, @Nonnull Record record) {
                return CacheKey.from(record.key());
            }
        };
    }

    @Override
    public synchronized void subscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public synchronized void unsubscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@Nonnull Set<String> changedKeys) {
        LinkedHashSet<ApolloStore.RecordChangeSubscriber> iterableSubscribers;
        Utils.checkNotNull(changedKeys, (Object)"changedKeys == null");
        if (changedKeys.isEmpty()) {
            return;
        }
        RealAppSyncStore realAppSyncStore = this;
        synchronized (realAppSyncStore) {
            iterableSubscribers = new LinkedHashSet<ApolloStore.RecordChangeSubscriber>(this.subscribers);
        }
        for (ApolloStore.RecordChangeSubscriber subscriber : iterableSubscribers) {
            subscriber.onCacheRecordsChanged(changedKeys);
        }
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Boolean> clearAll() {
        return new GraphQLStoreOperation<Boolean>(this.dispatcher){

            @Override
            public Boolean perform() {
                return RealAppSyncStore.this.writeTransaction(new Transaction<WriteableStore, Boolean>(){

                    @Override
                    public Boolean execute(WriteableStore cache) {
                        RealAppSyncStore.this.optimisticCache.clearAll();
                        return Boolean.TRUE;
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Boolean> remove(final @Nonnull CacheKey cacheKey) {
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        return new GraphQLStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                return RealAppSyncStore.this.writeTransaction(new Transaction<WriteableStore, Boolean>(){

                    @Override
                    public Boolean execute(WriteableStore cache) {
                        return RealAppSyncStore.this.optimisticCache.remove(cacheKey);
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Integer> remove(final @Nonnull List<CacheKey> cacheKeys) {
        Utils.checkNotNull(cacheKeys, (Object)"cacheKey == null");
        return new GraphQLStoreOperation<Integer>(this.dispatcher){

            @Override
            protected Integer perform() {
                return RealAppSyncStore.this.writeTransaction(new Transaction<WriteableStore, Integer>(){

                    @Override
                    public Integer execute(WriteableStore cache) {
                        int count = 0;
                        for (CacheKey cacheKey : cacheKeys) {
                            if (!RealAppSyncStore.this.optimisticCache.remove(cacheKey)) continue;
                            ++count;
                        }
                        return count;
                    }
                });
            }
        };
    }

    @Override
    public <R> R readTransaction(Transaction<ReadableStore, R> transaction) {
        this.lock.readLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <R> R writeTransaction(Transaction<WriteableStore, R> transaction) {
        this.lock.writeLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public NormalizedCache normalizedCache() {
        return this.optimisticCache;
    }

    @Override
    @Nullable
    public Record read(@Nonnull String key, @Nonnull CacheHeaders cacheHeaders) {
        return this.optimisticCache.loadRecord((String)Utils.checkNotNull((Object)key, (Object)"key == null"), cacheHeaders);
    }

    @Override
    @Nonnull
    public Collection<Record> read(@Nonnull Collection<String> keys, @Nonnull CacheHeaders cacheHeaders) {
        return this.optimisticCache.loadRecords((Collection)Utils.checkNotNull(keys, (Object)"keys == null"), cacheHeaders);
    }

    @Override
    @Nonnull
    public Set<String> merge(@Nonnull Collection<Record> recordSet, @Nonnull CacheHeaders cacheHeaders) {
        return this.optimisticCache.merge((Collection)Utils.checkNotNull(recordSet, (Object)"recordSet == null"), cacheHeaders);
    }

    @Override
    public Set<String> merge(Record record, @Nonnull CacheHeaders cacheHeaders) {
        return this.optimisticCache.merge((Record)Utils.checkNotNull((Object)record, (Object)"record == null"), cacheHeaders);
    }

    @Override
    public CacheKeyResolver cacheKeyResolver() {
        return this.cacheKeyResolver;
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> GraphQLStoreOperation<T> read(final @Nonnull Operation<D, T, V> operation) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        return new GraphQLStoreOperation<T>(this.dispatcher){

            @Override
            protected T perform() {
                return RealAppSyncStore.this.doRead(operation);
            }
        };
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> GraphQLStoreOperation<Response<T>> read(final @Nonnull Operation<D, T, V> operation, final @Nonnull ResponseFieldMapper<D> responseFieldMapper, final @Nonnull ResponseNormalizer<Record> responseNormalizer, final @Nonnull CacheHeaders cacheHeaders) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        Utils.checkNotNull(responseNormalizer, (Object)"responseNormalizer == null");
        return new GraphQLStoreOperation<Response<T>>(this.dispatcher){

            @Override
            protected Response<T> perform() {
                return RealAppSyncStore.this.doRead(operation, responseFieldMapper, responseNormalizer, cacheHeaders);
            }
        };
    }

    @Override
    @Nonnull
    public <F extends GraphqlFragment> GraphQLStoreOperation<F> read(final @Nonnull ResponseFieldMapper<F> responseFieldMapper, final @Nonnull CacheKey cacheKey, final @Nonnull Operation.Variables variables) {
        Utils.checkNotNull(responseFieldMapper, (Object)"responseFieldMapper == null");
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        Utils.checkNotNull((Object)variables, (Object)"variables == null");
        return new GraphQLStoreOperation<F>(this.dispatcher){

            @Override
            protected F perform() {
                return RealAppSyncStore.this.doRead(responseFieldMapper, cacheKey, variables);
            }
        };
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> GraphQLStoreOperation<Set<String>> write(final @Nonnull Operation<D, T, V> operation, final @Nonnull D operationData) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        Utils.checkNotNull(operationData, (Object)"operationData == null");
        return new GraphQLStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealAppSyncStore.this.doWrite(operation, operationData, false, null);
            }
        };
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> GraphQLStoreOperation<Boolean> writeAndPublish(final @Nonnull Operation<D, T, V> operation, final @Nonnull D operationData) {
        return new GraphQLStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set changedKeys = RealAppSyncStore.this.doWrite(operation, operationData, false, null);
                RealAppSyncStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Set<String>> write(final @Nonnull GraphqlFragment fragment, final @Nonnull CacheKey cacheKey, final @Nonnull Operation.Variables variables) {
        Utils.checkNotNull((Object)fragment, (Object)"fragment == null");
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        Utils.checkNotNull((Object)variables, (Object)"operation == null");
        if (cacheKey == CacheKey.NO_KEY) {
            throw new IllegalArgumentException("undefined cache key");
        }
        return new GraphQLStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealAppSyncStore.this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                    @Override
                    public Set<String> execute(WriteableStore cache) {
                        return RealAppSyncStore.this.doWrite(fragment, cacheKey, variables);
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Boolean> writeAndPublish(final @Nonnull GraphqlFragment fragment, final @Nonnull CacheKey cacheKey, final @Nonnull Operation.Variables variables) {
        return new GraphQLStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set changedKeys = RealAppSyncStore.this.doWrite(fragment, cacheKey, variables);
                RealAppSyncStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> GraphQLStoreOperation<Set<String>> writeOptimisticUpdates(final @Nonnull Operation<D, T, V> operation, final @Nonnull D operationData, final @Nonnull UUID mutationId) {
        return new GraphQLStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealAppSyncStore.this.doWrite(operation, operationData, true, mutationId);
            }
        };
    }

    @Override
    @Nonnull
    public <D extends Operation.Data, T, V extends Operation.Variables> GraphQLStoreOperation<Boolean> writeOptimisticUpdatesAndPublish(final @Nonnull Operation<D, T, V> operation, final @Nonnull D operationData, final @Nonnull UUID mutationId) {
        return new GraphQLStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set changedKeys = RealAppSyncStore.this.doWrite(operation, operationData, true, mutationId);
                RealAppSyncStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Set<String>> rollbackOptimisticUpdates(final @Nonnull UUID mutationId) {
        return new GraphQLStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealAppSyncStore.this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                    @Override
                    public Set<String> execute(WriteableStore cache) {
                        return RealAppSyncStore.this.optimisticCache.removeOptimisticUpdates(mutationId);
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public GraphQLStoreOperation<Boolean> rollbackOptimisticUpdatesAndPublish(final @Nonnull UUID mutationId) {
        return new GraphQLStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set<String> changedKeys = RealAppSyncStore.this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                    @Override
                    public Set<String> execute(WriteableStore cache) {
                        return RealAppSyncStore.this.optimisticCache.removeOptimisticUpdates(mutationId);
                    }
                });
                RealAppSyncStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> T doRead(final Operation<D, T, V> operation) {
        return (T)this.readTransaction(new Transaction<ReadableStore, T>(){

            @Override
            @Nullable
            public T execute(ReadableStore cache) {
                Record rootRecord = cache.read(CacheKeyResolver.rootKeyForOperation(operation).key(), CacheHeaders.NONE);
                if (rootRecord == null) {
                    return null;
                }
                ResponseFieldMapper responseFieldMapper = operation.responseFieldMapper();
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, operation.variables(), RealAppSyncStore.this.cacheKeyResolver(), CacheHeaders.NONE);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(operation.variables(), rootRecord, fieldValueResolver, RealAppSyncStore.this.scalarTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
                return operation.wrapData((Operation.Data)responseFieldMapper.map(responseReader));
            }
        });
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> Response<T> doRead(final Operation<D, T, V> operation, final ResponseFieldMapper<D> responseFieldMapper, final ResponseNormalizer<Record> responseNormalizer, final CacheHeaders cacheHeaders) {
        return (Response)this.readTransaction(new Transaction<ReadableStore, Response<T>>(){

            @Override
            @Nonnull
            public Response<T> execute(ReadableStore cache) {
                Record rootRecord = cache.read(CacheKeyResolver.rootKeyForOperation(operation).key(), cacheHeaders);
                if (rootRecord == null) {
                    return Response.builder((Operation)operation).fromCache(true).build();
                }
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, operation.variables(), RealAppSyncStore.this.cacheKeyResolver(), cacheHeaders);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(operation.variables(), rootRecord, fieldValueResolver, RealAppSyncStore.this.scalarTypeAdapters, responseNormalizer);
                try {
                    responseNormalizer.willResolveRootQuery(operation);
                    Object data = operation.wrapData((Operation.Data)responseFieldMapper.map(responseReader));
                    return Response.builder((Operation)operation).data(data).fromCache(true).dependentKeys(responseNormalizer.dependentKeys()).build();
                }
                catch (Exception e) {
                    RealAppSyncStore.this.logger.e((Throwable)e, "Failed to read cache response", new Object[0]);
                    return Response.builder((Operation)operation).fromCache(true).build();
                }
            }
        });
    }

    private <F extends GraphqlFragment> F doRead(final ResponseFieldMapper<F> responseFieldMapper, final CacheKey cacheKey, final Operation.Variables variables) {
        return (F)((GraphqlFragment)this.readTransaction(new Transaction<ReadableStore, F>(){

            @Override
            @Nullable
            public F execute(ReadableStore cache) {
                Record rootRecord = cache.read(cacheKey.key(), CacheHeaders.NONE);
                if (rootRecord == null) {
                    return null;
                }
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, variables, RealAppSyncStore.this.cacheKeyResolver(), CacheHeaders.NONE);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(variables, rootRecord, fieldValueResolver, RealAppSyncStore.this.scalarTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
                return (GraphqlFragment)responseFieldMapper.map(responseReader);
            }
        }));
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> Set<String> doWrite(final Operation<D, T, V> operation, final D operationData, final boolean optimistic, final UUID mutationId) {
        return this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

            @Override
            public Set<String> execute(WriteableStore cache) {
                CacheResponseWriter cacheResponseWriter = new CacheResponseWriter(operation.variables(), RealAppSyncStore.this.scalarTypeAdapters);
                operationData.marshaller().marshal((ResponseWriter)cacheResponseWriter);
                ResponseNormalizer<Map<String, Object>> responseNormalizer = RealAppSyncStore.this.networkResponseNormalizer();
                responseNormalizer.willResolveRootQuery(operation);
                Collection<Record> records = cacheResponseWriter.normalize(responseNormalizer);
                if (optimistic) {
                    ArrayList<Record> updatedRecords = new ArrayList<Record>();
                    for (Record record : records) {
                        updatedRecords.add(record.toBuilder().mutationId(mutationId).build());
                    }
                    return RealAppSyncStore.this.optimisticCache.mergeOptimisticUpdates(updatedRecords);
                }
                return RealAppSyncStore.this.optimisticCache.merge(records, CacheHeaders.NONE);
            }
        });
    }

    private Set<String> doWrite(final GraphqlFragment fragment, final CacheKey cacheKey, final Operation.Variables variables) {
        return this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

            @Override
            public Set<String> execute(WriteableStore cache) {
                CacheResponseWriter cacheResponseWriter = new CacheResponseWriter(variables, RealAppSyncStore.this.scalarTypeAdapters);
                fragment.marshaller().marshal((ResponseWriter)cacheResponseWriter);
                ResponseNormalizer<Map<String, Object>> responseNormalizer = RealAppSyncStore.this.networkResponseNormalizer();
                responseNormalizer.willResolveRecord(cacheKey);
                Collection<Record> records = cacheResponseWriter.normalize(responseNormalizer);
                return RealAppSyncStore.this.merge(records, CacheHeaders.NONE);
            }
        });
    }
}

