/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.amazonaws.mobileconnectors.appsync.AppSyncSubscriptionCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.GraphQLCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.RealAppSyncCall;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class RealAppSyncSubscriptionCall<T>
implements AppSyncSubscriptionCall<T> {
    public static Semaphore subscriptionSemaphore = new Semaphore(1, true);
    private static int MAX_WAIT_TIME = 30;
    private final ApolloLogger logger;
    private final Subscription<?, T, ?> subscription;
    private final SubscriptionManager subscriptionManager;
    private final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    private final ApolloClient apolloClient;
    private final RealAppSyncCall<T> subscriptionMetadataRequest;
    private AppSyncSubscriptionCall.Callback<T> userCallback;
    private static final String TAG = RealAppSyncSubscriptionCall.class.getSimpleName();

    public RealAppSyncSubscriptionCall(Subscription<?, T, ?> subscription, SubscriptionManager subscriptionManager, ApolloClient apolloClient, ApolloLogger logger, RealAppSyncCall<T> solicitingCall) {
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
        this.apolloClient = apolloClient;
        this.subscriptionMetadataRequest = solicitingCall;
        this.logger = logger;
    }

    @Override
    public void execute(final @Nonnull AppSyncSubscriptionCall.Callback<T> callback) {
        if (callback == null) {
            this.logger.w("Subscription Infrastructure: Callback passed into subscription [" + this.subscription + "] was null. Will not subscribe.", new Object[0]);
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RealAppSyncSubscriptionCall.this.userCallback = callback;
                RealAppSyncSubscriptionCall.this.subscriptionManager.addListener(RealAppSyncSubscriptionCall.this.subscription, callback);
                1 var1_1 = this;
                synchronized (var1_1) {
                    switch ((CallState)((Object)RealAppSyncSubscriptionCall.this.state.get())) {
                        case IDLE: {
                            RealAppSyncSubscriptionCall.this.state.set(CallState.ACTIVE);
                            break;
                        }
                        case CANCELED: {
                            throw new RuntimeException("Cancelled", new ApolloCanceledException("Call is cancelled."));
                        }
                        case ACTIVE: {
                            throw new IllegalStateException("Already Executed");
                        }
                        default: {
                            throw new IllegalStateException("Unknown state");
                        }
                    }
                }
                try {
                    if (subscriptionSemaphore.tryAcquire(MAX_WAIT_TIME, TimeUnit.SECONDS)) {
                        RealAppSyncSubscriptionCall.this.logger.d("Subscription Infrastructure: Acquired subscription Semaphore. Continuing", new Object[0]);
                    } else {
                        RealAppSyncSubscriptionCall.this.logger.d("Subscription Infrastructure: Did not acquire subscription Semaphore after waiting for [" + MAX_WAIT_TIME + "] seconds. Will continue", new Object[0]);
                    }
                }
                catch (InterruptedException e) {
                    RealAppSyncSubscriptionCall.this.logger.e((Throwable)e, "Subscription Infrastructure:Got exception while waiting to acquire subscription Semaphore. Will continue without waiting", new Object[0]);
                }
                RealAppSyncSubscriptionCall.this.logger.d("Subscription Infrastructure: Making request to server to get Subscription Meta Data", new Object[0]);
                RealAppSyncSubscriptionCall.this.subscriptionMetadataRequest.enqueue(new GraphQLCall.Callback<T>(){

                    @Override
                    public void onResponse(@Nonnull Response<T> response) {
                        subscriptionSemaphore.release();
                    }

                    @Override
                    public void onFailure(@Nonnull ApolloException e) {
                        subscriptionSemaphore.release();
                        RealAppSyncSubscriptionCall.this.reportFailureToSubscriptionManager();
                        callback.onFailure(e);
                    }
                });
            }
        }).start();
    }

    void reportFailureToSubscriptionManager() {
        this.logger.d("Trying to report failure to Subscription Manager", new Object[0]);
        try {
            Method method = this.subscriptionManager.getClass().getDeclaredMethod("reportConnectionError", new Class[0]);
            method.invoke((Object)this.subscriptionManager, new Object[0]);
        }
        catch (NoSuchMethodException noe) {
            this.logger.d("Exception [" + noe + "] trying to call reportConnectionError in subscriptionManager", new Object[0]);
        }
        catch (InvocationTargetException ite) {
            this.logger.d("Exception [" + ite + "] trying to call reportConnectionError in subscriptionManager", new Object[0]);
        }
        catch (IllegalAccessException iae) {
            this.logger.d("Exception [" + iae + "] trying to call reportConnectionError in subscriptionManager", new Object[0]);
        }
    }

    @Override
    public void cancel() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    switch ((CallState)((Object)RealAppSyncSubscriptionCall.this.state.get())) {
                        case IDLE: {
                            RealAppSyncSubscriptionCall.this.state.set(CallState.CANCELED);
                            break;
                        }
                        case ACTIVE: {
                            try {
                                RealAppSyncSubscriptionCall.this.subscriptionManager.unsubscribe(RealAppSyncSubscriptionCall.this.subscription);
                                RealAppSyncSubscriptionCall.this.subscriptionManager.removeListener(RealAppSyncSubscriptionCall.this.subscription, RealAppSyncSubscriptionCall.this.userCallback);
                                RealAppSyncSubscriptionCall.this.userCallback.onCompleted();
                                RealAppSyncSubscriptionCall.this.userCallback = null;
                                break;
                            }
                            finally {
                                RealAppSyncSubscriptionCall.this.state.set(CallState.CANCELED);
                            }
                        }
                        case CANCELED: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state");
                        }
                    }
                }
            }
        }).start();
    }

    @Override
    public AppSyncSubscriptionCall<T> clone() {
        return new RealAppSyncSubscriptionCall<T>(this.subscription, this.subscriptionManager, this.apolloClient, this.logger, this.subscriptionMetadataRequest.clone());
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }
}

