/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.field;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ReadableStore;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import java.util.ArrayList;
import java.util.List;

public final class CacheFieldValueResolver
implements FieldValueResolver<Record> {
    private final ReadableStore readableCache;
    private final Operation.Variables variables;
    private final CacheKeyResolver cacheKeyResolver;
    private final CacheHeaders cacheHeaders;

    public CacheFieldValueResolver(ReadableStore readableCache, Operation.Variables variables, CacheKeyResolver cacheKeyResolver, CacheHeaders cacheHeaders) {
        this.readableCache = readableCache;
        this.variables = variables;
        this.cacheKeyResolver = cacheKeyResolver;
        this.cacheHeaders = cacheHeaders;
    }

    @Override
    public <T> T valueFor(Record record, ResponseField field) {
        switch (field.type()) {
            case OBJECT: {
                return (T)this.valueForObject(record, field);
            }
            case LIST: {
                return (T)this.valueForList((List)this.fieldValue(record, field));
            }
        }
        return this.fieldValue(record, field);
    }

    private Record valueForObject(Record record, ResponseField field) {
        CacheKey fieldCacheKey = this.cacheKeyResolver.fromFieldArguments(field, this.variables);
        CacheReference cacheReference = fieldCacheKey != CacheKey.NO_KEY ? new CacheReference(fieldCacheKey.key()) : (CacheReference)this.fieldValue(record, field);
        if (cacheReference != null) {
            Record referencedRecord = this.readableCache.read(cacheReference.key(), this.cacheHeaders);
            if (referencedRecord == null) {
                throw new IllegalStateException("Cache MISS: failed to find record in cache by reference");
            }
            return referencedRecord;
        }
        return null;
    }

    private List valueForList(List values) {
        if (values == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof CacheReference) {
                CacheReference reference = (CacheReference)value;
                Record referencedRecord = this.readableCache.read(reference.key(), this.cacheHeaders);
                if (referencedRecord == null) {
                    throw new IllegalStateException("Cache MISS: failed to find record in cache by reference");
                }
                result.add(referencedRecord);
                continue;
            }
            if (value instanceof List) {
                result.add(this.valueForList((List)value));
                continue;
            }
            result.add(value);
        }
        return result;
    }

    private <T> T fieldValue(Record record, ResponseField field) {
        String fieldKey = field.cacheKey(this.variables);
        if (!record.hasField(fieldKey)) {
            throw new NullPointerException("Missing value: " + field.fieldName());
        }
        return (T)record.field(fieldKey);
    }
}

