/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.response.OperationResponseParser;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public final class ApolloParseInterceptor
implements ApolloInterceptor {
    private final HttpCache httpCache;
    private final ResponseNormalizer<Map<String, Object>> normalizer;
    private final ResponseFieldMapper responseFieldMapper;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final ApolloLogger logger;
    private volatile boolean disposed;

    public ApolloParseInterceptor(HttpCache httpCache, ResponseNormalizer<Map<String, Object>> normalizer, ResponseFieldMapper responseFieldMapper, ScalarTypeAdapters scalarTypeAdapters, ApolloLogger logger) {
        this.httpCache = httpCache;
        this.normalizer = normalizer;
        this.responseFieldMapper = responseFieldMapper;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.logger = logger;
    }

    @Override
    public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain, @Nonnull Executor dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        if (this.disposed) {
            return;
        }
        chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                try {
                    if (ApolloParseInterceptor.this.disposed) {
                        return;
                    }
                    if (response.parsedResponse.isPresent()) {
                        callBack.onResponse(response);
                    } else {
                        ApolloInterceptor.InterceptorResponse result = ApolloParseInterceptor.this.parse(request.operation, (Response)response.httpResponse.get());
                        callBack.onResponse(result);
                    }
                    callBack.onCompleted();
                }
                catch (ApolloException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (ApolloParseInterceptor.this.disposed) {
                    return;
                }
                callBack.onFailure(e);
            }

            @Override
            public void onCompleted() {
            }

            @Override
            public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                callBack.onFetch(sourceType);
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    private ApolloInterceptor.InterceptorResponse parse(Operation operation, Response httpResponse) throws ApolloHttpException, ApolloParseException {
        String cacheKey = httpResponse.request().header("X-APOLLO-CACHE-KEY");
        String cloneString = null;
        ResponseBody responseBody = httpResponse.body();
        BufferedSource source = responseBody.source();
        try {
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            cloneString = buffer.clone().readString(Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (httpResponse.isSuccessful()) {
            try {
                OperationResponseParser parser = new OperationResponseParser(operation, this.responseFieldMapper, this.scalarTypeAdapters, this.normalizer);
                com.apollographql.apollo.api.Response parsedResponse = parser.parse(httpResponse.body().source()).toBuilder().fromCache(httpResponse.cacheResponse() != null).build();
                if (parsedResponse.hasErrors() && this.httpCache != null) {
                    this.httpCache.removeQuietly(cacheKey);
                }
                return new ApolloInterceptor.InterceptorResponse(httpResponse, parsedResponse, this.normalizer.records(), cloneString);
            }
            catch (Exception rethrown) {
                this.logger.e((Throwable)rethrown, "Failed to parse network response for operation: %s", new Object[]{operation});
                ApolloParseInterceptor.closeQuietly((Closeable)httpResponse);
                if (this.httpCache != null) {
                    this.httpCache.removeQuietly(cacheKey);
                }
                throw new ApolloParseException("Failed to parse http response", rethrown);
            }
        }
        this.logger.e("Failed to parse network response: %s", new Object[]{httpResponse});
        throw new ApolloHttpException(httpResponse);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

