/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.amazonaws.mobileconnectors.appsync.AppSyncMutationCall;
import com.amazonaws.mobileconnectors.appsync.AppSyncPrefetch;
import com.amazonaws.mobileconnectors.appsync.AppSyncQueryCall;
import com.amazonaws.mobileconnectors.appsync.AppSyncSubscriptionCall;
import com.amazonaws.mobileconnectors.appsync.fetcher.AppSyncResponseFetchers;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.GraphQLStoreOperation;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import com.apollographql.apollo.cache.normalized.RecordFieldJsonAdapter;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.RealAppSyncCall;
import com.apollographql.apollo.internal.RealAppSyncPrefetch;
import com.apollographql.apollo.internal.RealAppSyncSubscriptionCall;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.normalized.RealAppSyncStore;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import com.apollographql.apollo.internal.subscription.NoOpSubscriptionManager;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public final class ApolloClient
implements AppSyncQueryCall.Factory,
AppSyncMutationCall.Factory,
AppSyncSubscriptionCall.Factory,
AppSyncPrefetch.Factory {
    private final HttpUrl serverUrl;
    private final Call.Factory httpCallFactory;
    private final HttpCache httpCache;
    private final ApolloStore mApolloStore;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final Executor dispatcher;
    private final HttpCachePolicy.Policy defaultHttpCachePolicy;
    private final ResponseFetcher defaultResponseFetcher;
    private final CacheHeaders defaultCacheHeaders;
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker = new ApolloCallTracker();
    private final List<ApolloInterceptor> applicationInterceptors;
    private final boolean sendOperationIdentifiers;
    private final SubscriptionManager subscriptionManager;

    public static Builder builder() {
        return new Builder();
    }

    private ApolloClient(HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, ApolloStore apolloStore, ScalarTypeAdapters scalarTypeAdapters, Executor dispatcher, HttpCachePolicy.Policy defaultHttpCachePolicy, ResponseFetcher defaultResponseFetcher, CacheHeaders defaultCacheHeaders, ApolloLogger logger, List<ApolloInterceptor> applicationInterceptors, boolean sendOperationIdentifiers, SubscriptionManager subscriptionManager) {
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.mApolloStore = apolloStore;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.dispatcher = dispatcher;
        this.defaultHttpCachePolicy = defaultHttpCachePolicy;
        this.defaultResponseFetcher = defaultResponseFetcher;
        this.defaultCacheHeaders = defaultCacheHeaders;
        this.logger = logger;
        this.applicationInterceptors = applicationInterceptors;
        this.sendOperationIdentifiers = sendOperationIdentifiers;
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> AppSyncMutationCall<T> mutate(@Nonnull Mutation<D, T, V> mutation) {
        return this.newCall((Operation<D, T, V>)mutation).responseFetcher(AppSyncResponseFetchers.NETWORK_ONLY);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> AppSyncMutationCall<T> mutate(@Nonnull Mutation<D, T, V> mutation, @Nonnull D withOptimisticUpdates) {
        Utils.checkNotNull(withOptimisticUpdates, (Object)"withOptimisticUpdate == null");
        return this.newCall((Operation<D, T, V>)mutation).toBuilder().responseFetcher(AppSyncResponseFetchers.NETWORK_ONLY).optimisticUpdates((Optional<Operation.Data>)Optional.fromNullable(withOptimisticUpdates)).build();
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> AppSyncQueryCall<T> query(@Nonnull Query<D, T, V> query) {
        return this.newCall((Operation<D, T, V>)query);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> AppSyncSubscriptionCall<T> subscribe(@Nonnull Subscription<D, T, V> subscription) {
        return new RealAppSyncSubscriptionCall<T>(subscription, this.subscriptionManager, this, this.logger, this.newCall((Operation<D, T, V>)subscription));
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> AppSyncPrefetch prefetch(@Nonnull Operation<D, T, V> operation) {
        return new RealAppSyncPrefetch(operation, this.serverUrl, this.httpCallFactory, this.scalarTypeAdapters, this.dispatcher, this.logger, this.tracker, this.sendOperationIdentifiers);
    }

    public CacheHeaders defaultCacheHeaders() {
        return this.defaultCacheHeaders;
    }

    public void clearHttpCache() {
        if (this.httpCache != null) {
            this.httpCache.clear();
        }
    }

    @Nonnull
    public GraphQLStoreOperation<Boolean> clearNormalizedCache() {
        return this.mApolloStore.clearAll();
    }

    public ApolloStore apolloStore() {
        return this.mApolloStore;
    }

    public void idleCallback(IdleResourceCallback idleResourceCallback) {
        this.tracker.setIdleResourceCallback(idleResourceCallback);
    }

    public int activeCallsCount() {
        return this.tracker.activeCallsCount();
    }

    Response cachedHttpResponse(String cacheKey) throws IOException {
        if (this.httpCache != null) {
            return this.httpCache.read(cacheKey);
        }
        return null;
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> RealAppSyncCall<T> newCall(@Nonnull Operation<D, T, V> operation) {
        return RealAppSyncCall.builder().operation(operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.defaultHttpCachePolicy).responseFieldMapperFactory(this.responseFieldMapperFactory).scalarTypeAdapters(this.scalarTypeAdapters).apolloStore(this.mApolloStore).responseFetcher(this.defaultResponseFetcher).cacheHeaders(this.defaultCacheHeaders).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueries(Collections.emptyList()).refetchQueryNames(Collections.emptyList()).sendOperationIdentifiers(this.sendOperationIdentifiers).subscriptionManager(this.subscriptionManager).build();
    }

    public static class Builder {
        Call.Factory callFactory;
        HttpUrl serverUrl;
        HttpCache httpCache;
        ApolloStore mApolloStore = ApolloStore.NO_APOLLO_STORE;
        Optional<NormalizedCacheFactory> cacheFactory = Optional.absent();
        Optional<CacheKeyResolver> cacheKeyResolver = Optional.absent();
        HttpCachePolicy.Policy defaultHttpCachePolicy = HttpCachePolicy.NETWORK_ONLY;
        ResponseFetcher defaultResponseFetcher = AppSyncResponseFetchers.CACHE_FIRST;
        CacheHeaders defaultCacheHeaders = CacheHeaders.NONE;
        final Map<ScalarType, CustomTypeAdapter> customTypeAdapters = new LinkedHashMap<ScalarType, CustomTypeAdapter>();
        Executor dispatcher;
        Optional<Logger> logger = Optional.absent();
        final List<ApolloInterceptor> applicationInterceptors = new ArrayList<ApolloInterceptor>();
        boolean sendOperationIdentifiers;
        SubscriptionManager subscriptionManager = new NoOpSubscriptionManager();

        private Builder() {
        }

        public Builder okHttpClient(@Nonnull OkHttpClient okHttpClient) {
            return this.callFactory((Call.Factory)Utils.checkNotNull((Object)okHttpClient, (Object)"okHttpClient is null"));
        }

        public Builder callFactory(@Nonnull Call.Factory factory) {
            this.callFactory = (Call.Factory)Utils.checkNotNull((Object)factory, (Object)"factory == null");
            return this;
        }

        public Builder serverUrl(@Nonnull HttpUrl serverUrl) {
            this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl is null");
            return this;
        }

        public Builder serverUrl(@Nonnull String serverUrl) {
            this.serverUrl = HttpUrl.parse((String)((String)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null")));
            return this;
        }

        public Builder httpCache(@Nonnull HttpCache httpCache) {
            this.httpCache = (HttpCache)Utils.checkNotNull((Object)httpCache, (Object)"httpCache == null");
            return this;
        }

        public Builder normalizedCache(@Nonnull NormalizedCacheFactory normalizedCacheFactory) {
            return this.normalizedCache(normalizedCacheFactory, CacheKeyResolver.DEFAULT);
        }

        public Builder normalizedCache(@Nonnull NormalizedCacheFactory normalizedCacheFactory, @Nonnull CacheKeyResolver keyResolver) {
            this.cacheFactory = Optional.fromNullable((Object)Utils.checkNotNull((Object)normalizedCacheFactory, (Object)"normalizedCacheFactory == null"));
            this.cacheKeyResolver = Optional.fromNullable((Object)Utils.checkNotNull((Object)keyResolver, (Object)"cacheKeyResolver == null"));
            return this;
        }

        public <T> Builder addCustomTypeAdapter(@Nonnull ScalarType scalarType, @Nonnull CustomTypeAdapter<T> customTypeAdapter) {
            this.customTypeAdapters.put(scalarType, customTypeAdapter);
            return this;
        }

        public Builder dispatcher(@Nonnull Executor dispatcher) {
            this.dispatcher = (Executor)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
            return this;
        }

        public Builder defaultHttpCachePolicy(@Nonnull HttpCachePolicy.Policy cachePolicy) {
            this.defaultHttpCachePolicy = (HttpCachePolicy.Policy)Utils.checkNotNull((Object)cachePolicy, (Object)"cachePolicy == null");
            return this;
        }

        public Builder defaultCacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
            this.defaultCacheHeaders = (CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
            return this;
        }

        public Builder defaultResponseFetcher(@Nonnull ResponseFetcher defaultResponseFetcher) {
            this.defaultResponseFetcher = (ResponseFetcher)Utils.checkNotNull((Object)defaultResponseFetcher, (Object)"defaultResponseFetcher == null");
            return this;
        }

        public Builder logger(@Nullable Logger logger) {
            this.logger = Optional.fromNullable((Object)logger);
            return this;
        }

        public Builder addApplicationInterceptor(@Nonnull ApolloInterceptor interceptor) {
            this.applicationInterceptors.add(interceptor);
            return this;
        }

        public Builder sendOperationIdentifiers(boolean sendOperationIdentifiers) {
            this.sendOperationIdentifiers = sendOperationIdentifiers;
            return this;
        }

        public Builder subscriptionManager(@Nonnull SubscriptionManager subscriptionManager) {
            this.subscriptionManager = subscriptionManager;
            return this;
        }

        public ApolloClient build() {
            Executor dispatcher;
            HttpCache httpCache;
            Utils.checkNotNull((Object)this.serverUrl, (Object)"serverUrl is null");
            ApolloLogger apolloLogger = new ApolloLogger(this.logger);
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            if ((httpCache = this.httpCache) != null) {
                callFactory = Builder.addHttCacheInterceptorIfNeeded(callFactory, httpCache.interceptor());
            }
            if ((dispatcher = this.dispatcher) == null) {
                dispatcher = this.defaultDispatcher();
            }
            ScalarTypeAdapters scalarTypeAdapters = new ScalarTypeAdapters(this.customTypeAdapters);
            ApolloStore apolloStore = this.mApolloStore;
            Optional<NormalizedCacheFactory> cacheFactory = this.cacheFactory;
            Optional<CacheKeyResolver> cacheKeyResolver = this.cacheKeyResolver;
            if (cacheFactory.isPresent() && cacheKeyResolver.isPresent()) {
                NormalizedCache normalizedCache = ((NormalizedCacheFactory)cacheFactory.get()).createChain(RecordFieldJsonAdapter.create());
                apolloStore = new RealAppSyncStore(normalizedCache, (CacheKeyResolver)cacheKeyResolver.get(), scalarTypeAdapters, dispatcher, apolloLogger);
            }
            return new ApolloClient(this.serverUrl, callFactory, httpCache, apolloStore, scalarTypeAdapters, dispatcher, this.defaultHttpCachePolicy, this.defaultResponseFetcher, this.defaultCacheHeaders, apolloLogger, this.applicationInterceptors, this.sendOperationIdentifiers, this.subscriptionManager);
        }

        private Executor defaultDispatcher() {
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(@Nonnull Runnable runnable) {
                    return new Thread(runnable, "Apollo Dispatcher");
                }
            });
        }

        private static Call.Factory addHttCacheInterceptorIfNeeded(Call.Factory callFactory, Interceptor httCacheInterceptor) {
            if (callFactory instanceof OkHttpClient) {
                OkHttpClient client = (OkHttpClient)callFactory;
                for (Interceptor interceptor : client.interceptors()) {
                    if (!interceptor.getClass().equals(httCacheInterceptor.getClass())) continue;
                    return callFactory;
                }
                return client.newBuilder().addInterceptor(httCacheInterceptor).build();
            }
            return callFactory;
        }
    }
}

