/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.exception.ApolloException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class GraphQLStoreOperation<T> {
    private final Executor dispatcher;
    private AtomicReference<Callback<T>> callback = new AtomicReference();
    private final AtomicBoolean executed = new AtomicBoolean();

    public static <T> GraphQLStoreOperation<T> emptyOperation(final T result) {
        return new GraphQLStoreOperation<T>(null){

            @Override
            protected T perform() {
                return result;
            }

            @Override
            public void enqueue(Callback<T> callback) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }
        };
    }

    protected GraphQLStoreOperation(Executor dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected abstract T perform();

    public final T execute() throws ApolloException {
        this.checkIfExecuted();
        try {
            return this.perform();
        }
        catch (Exception e) {
            throw new ApolloException("Failed to perform store operation", e);
        }
    }

    public void enqueue(@Nullable Callback<T> callback) {
        this.checkIfExecuted();
        this.callback.set(callback);
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = GraphQLStoreOperation.this.perform();
                }
                catch (Exception e) {
                    GraphQLStoreOperation.this.notifyFailure(new ApolloException("Failed to perform store operation", e));
                    return;
                }
                GraphQLStoreOperation.this.notifySuccess(result);
            }
        });
    }

    private void notifySuccess(T result) {
        Callback callback = this.callback.getAndSet(null);
        if (callback == null) {
            return;
        }
        callback.onSuccess(result);
    }

    private void notifyFailure(Throwable t) {
        Callback callback = this.callback.getAndSet(null);
        if (callback == null) {
            return;
        }
        callback.onFailure(t);
    }

    private void checkIfExecuted() {
        if (!this.executed.compareAndSet(false, true)) {
            throw new IllegalStateException("Already Executed");
        }
    }

    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onFailure(Throwable var1);
    }
}

