/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class NormalizedCache {
    private Optional<NormalizedCache> nextCache = Optional.absent();

    @Nullable
    public abstract Record loadRecord(@Nonnull String var1, @Nonnull CacheHeaders var2);

    @Nonnull
    public Collection<Record> loadRecords(@Nonnull Collection<String> keys, @Nonnull CacheHeaders cacheHeaders) {
        ArrayList<Record> records = new ArrayList<Record>(keys.size());
        for (String key : keys) {
            Record record = this.loadRecord(key, cacheHeaders);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    @Nonnull
    public abstract Set<String> merge(@Nonnull Record var1, @Nonnull CacheHeaders var2);

    @Nonnull
    public Set<String> merge(@Nonnull Collection<Record> recordSet, @Nonnull CacheHeaders cacheHeaders) {
        LinkedHashSet<String> aggregatedDependentKeys = new LinkedHashSet<String>();
        for (Record record : recordSet) {
            aggregatedDependentKeys.addAll(this.merge(record, cacheHeaders));
        }
        return aggregatedDependentKeys;
    }

    public abstract void clearAll();

    public abstract boolean remove(@Nonnull CacheKey var1);

    public final NormalizedCache chain(@Nonnull NormalizedCache cache) {
        Utils.checkNotNull((Object)cache, (Object)"cache == null");
        NormalizedCache leafCache = this;
        while (leafCache.nextCache.isPresent()) {
            leafCache = (NormalizedCache)leafCache.nextCache.get();
        }
        leafCache.nextCache = Optional.of((Object)cache);
        return this;
    }

    public final Optional<NormalizedCache> nextCache() {
        return this.nextCache;
    }
}

