/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.amazonaws.mobileconnectors.appsync.AppSyncMutationCall;
import com.amazonaws.mobileconnectors.appsync.AppSyncPrefetch;
import com.amazonaws.mobileconnectors.appsync.AppSyncQueryCall;
import com.amazonaws.mobileconnectors.appsync.AppSyncQueryWatcher;
import com.apollographql.apollo.GraphQLCall;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public final class ApolloCallTracker {
    private final Map<OperationName, Set<AppSyncPrefetch>> activePrefetchCalls = new HashMap<OperationName, Set<AppSyncPrefetch>>();
    private final Map<OperationName, Set<AppSyncQueryCall>> activeQueryCalls = new HashMap<OperationName, Set<AppSyncQueryCall>>();
    private final Map<OperationName, Set<AppSyncMutationCall>> activeMutationCalls = new HashMap<OperationName, Set<AppSyncMutationCall>>();
    private final Map<OperationName, Set<AppSyncQueryWatcher>> activeQueryWatchers = new HashMap<OperationName, Set<AppSyncQueryWatcher>>();
    private final AtomicInteger activeCallCount = new AtomicInteger();
    private IdleResourceCallback idleResourceCallback;

    void registerCall(@Nonnull GraphQLCall call) {
        Utils.checkNotNull((Object)call, (Object)"call == null");
        Operation operation = call.operation();
        if (operation instanceof Query) {
            this.registerQueryCall((AppSyncQueryCall)call);
        } else if (operation instanceof Mutation) {
            this.registerMutationCall((AppSyncMutationCall)call);
        } else if (!(operation instanceof Subscription)) {
            throw new IllegalArgumentException("Unknown call type");
        }
    }

    void unregisterCall(@Nonnull GraphQLCall call) {
        Utils.checkNotNull((Object)call, (Object)"call == null");
        Operation operation = call.operation();
        if (operation instanceof Query) {
            this.unregisterQueryCall((AppSyncQueryCall)call);
        } else if (operation instanceof Mutation) {
            this.unregisterMutationCall((AppSyncMutationCall)call);
        } else if (!(operation instanceof Subscription)) {
            throw new IllegalArgumentException("Unknown call type");
        }
    }

    void registerPrefetchCall(@Nonnull AppSyncPrefetch appSyncPrefetch) {
        Utils.checkNotNull((Object)appSyncPrefetch, (Object)"appSyncPrefetch == null");
        OperationName operationName = appSyncPrefetch.operation().name();
        this.registerCall(this.activePrefetchCalls, operationName, appSyncPrefetch);
    }

    void unregisterPrefetchCall(@Nonnull AppSyncPrefetch appSyncPrefetch) {
        Utils.checkNotNull((Object)appSyncPrefetch, (Object)"appSyncPrefetch == null");
        OperationName operationName = appSyncPrefetch.operation().name();
        this.unregisterCall(this.activePrefetchCalls, operationName, appSyncPrefetch);
    }

    @Nonnull
    Set<AppSyncPrefetch> activePrefetchCalls(@Nonnull OperationName operationName) {
        return this.activeCalls(this.activePrefetchCalls, operationName);
    }

    void registerQueryCall(@Nonnull AppSyncQueryCall appSyncQueryCall) {
        Utils.checkNotNull((Object)appSyncQueryCall, (Object)"appSyncQueryCall == null");
        OperationName operationName = appSyncQueryCall.operation().name();
        this.registerCall(this.activeQueryCalls, operationName, appSyncQueryCall);
    }

    void unregisterQueryCall(@Nonnull AppSyncQueryCall appSyncQueryCall) {
        Utils.checkNotNull((Object)appSyncQueryCall, (Object)"appSyncQueryCall == null");
        OperationName operationName = appSyncQueryCall.operation().name();
        this.unregisterCall(this.activeQueryCalls, operationName, appSyncQueryCall);
    }

    @Nonnull
    Set<AppSyncQueryCall> activeQueryCalls(@Nonnull OperationName operationName) {
        return this.activeCalls(this.activeQueryCalls, operationName);
    }

    void registerMutationCall(@Nonnull AppSyncMutationCall appSyncMutationCall) {
        Utils.checkNotNull((Object)appSyncMutationCall, (Object)"appSyncMutationCall == null");
        OperationName operationName = appSyncMutationCall.operation().name();
        this.registerCall(this.activeMutationCalls, operationName, appSyncMutationCall);
    }

    void unregisterMutationCall(@Nonnull AppSyncMutationCall appSyncMutationCall) {
        Utils.checkNotNull((Object)appSyncMutationCall, (Object)"appSyncMutationCall == null");
        OperationName operationName = appSyncMutationCall.operation().name();
        this.unregisterCall(this.activeMutationCalls, operationName, appSyncMutationCall);
    }

    @Nonnull
    Set<AppSyncMutationCall> activeMutationCalls(@Nonnull OperationName operationName) {
        return this.activeCalls(this.activeMutationCalls, operationName);
    }

    void registerQueryWatcher(@Nonnull AppSyncQueryWatcher queryWatcher) {
        Utils.checkNotNull((Object)queryWatcher, (Object)"queryWatcher == null");
        OperationName operationName = queryWatcher.operation().name();
        this.registerCall(this.activeQueryWatchers, operationName, queryWatcher);
    }

    void unregisterQueryWatcher(@Nonnull AppSyncQueryWatcher queryWatcher) {
        Utils.checkNotNull((Object)queryWatcher, (Object)"queryWatcher == null");
        OperationName operationName = queryWatcher.operation().name();
        this.unregisterCall(this.activeQueryWatchers, operationName, queryWatcher);
    }

    @Nonnull
    Set<AppSyncQueryWatcher> activeQueryWatchers(@Nonnull OperationName operationName) {
        return this.activeCalls(this.activeQueryWatchers, operationName);
    }

    public synchronized void setIdleResourceCallback(IdleResourceCallback idleResourceCallback) {
        this.idleResourceCallback = idleResourceCallback;
    }

    public int activeCallsCount() {
        return this.activeCallCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <CALL> void registerCall(Map<OperationName, Set<CALL>> registry, OperationName operationName, CALL call) {
        Map<OperationName, Set<CALL>> map = registry;
        synchronized (map) {
            Set<CALL> calls = registry.get(operationName);
            if (calls == null) {
                calls = new HashSet<CALL>();
                registry.put(operationName, calls);
            }
            calls.add(call);
        }
        this.activeCallCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <CALL> void unregisterCall(Map<OperationName, Set<CALL>> registry, OperationName operationName, CALL call) {
        Map<OperationName, Set<CALL>> map = registry;
        synchronized (map) {
            Set<CALL> calls = registry.get(operationName);
            if (calls == null || !calls.remove(call)) {
                throw new AssertionError((Object)"Call wasn't registered before");
            }
            if (calls.isEmpty()) {
                registry.remove(operationName);
            }
        }
        if (this.activeCallCount.decrementAndGet() == 0) {
            this.notifyIdleResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <CALL> Set<CALL> activeCalls(Map<OperationName, Set<CALL>> registry, @Nonnull OperationName operationName) {
        Utils.checkNotNull((Object)operationName, (Object)"operationName == null");
        Map<OperationName, Set<CALL>> map = registry;
        synchronized (map) {
            Set<CALL> calls = registry.get(operationName);
            return calls != null ? new HashSet<CALL>(calls) : Collections.emptySet();
        }
    }

    private void notifyIdleResource() {
        IdleResourceCallback callback = this.idleResourceCallback;
        if (callback != null) {
            callback.onIdle();
        }
    }
}

