/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.amazonaws.mobileconnectors.appsync.AppSyncMutationCall;
import com.amazonaws.mobileconnectors.appsync.AppSyncQueryCall;
import com.apollographql.apollo.GraphQLCall;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.QueryReFetcher;
import com.apollographql.apollo.internal.RealAppSyncQueryWatcher;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.AppSyncSubscriptionInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;

public final class RealAppSyncCall<T>
implements AppSyncQueryCall<T>,
AppSyncMutationCall<T> {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final HttpCachePolicy.Policy httpCachePolicy;
    final ResponseFieldMapperFactory responseFieldMapperFactory;
    final ScalarTypeAdapters scalarTypeAdapters;
    final ApolloStore mApolloStore;
    final CacheHeaders cacheHeaders;
    final ResponseFetcher responseFetcher;
    final ApolloInterceptorChain interceptorChain;
    final Executor dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final List<ApolloInterceptor> applicationInterceptors;
    final List<OperationName> refetchQueryNames;
    final List<Query> refetchQueries;
    final Optional<QueryReFetcher> queryReFetcher;
    final boolean sendOperationdIdentifiers;
    final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    final AtomicReference<GraphQLCall.Callback<T>> originalCallback = new AtomicReference();
    final Optional<Operation.Data> optimisticUpdates;
    SubscriptionManager subscriptionManager;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private RealAppSyncCall(Builder<T> builder) {
        this.operation = builder.operation;
        this.serverUrl = builder.serverUrl;
        this.httpCallFactory = builder.httpCallFactory;
        this.httpCache = builder.httpCache;
        this.httpCachePolicy = builder.httpCachePolicy;
        this.responseFieldMapperFactory = builder.responseFieldMapperFactory;
        this.scalarTypeAdapters = builder.scalarTypeAdapters;
        this.mApolloStore = builder.mApolloStore;
        this.responseFetcher = builder.responseFetcher;
        this.cacheHeaders = builder.cacheHeaders;
        this.dispatcher = builder.dispatcher;
        this.logger = builder.logger;
        this.applicationInterceptors = builder.applicationInterceptors;
        this.refetchQueryNames = builder.refetchQueryNames;
        this.refetchQueries = builder.refetchQueries;
        this.tracker = builder.tracker;
        this.subscriptionManager = builder.subscriptionManager;
        this.queryReFetcher = this.refetchQueries.isEmpty() && this.refetchQueryNames.isEmpty() || builder.mApolloStore == null ? Optional.absent() : Optional.of((Object)QueryReFetcher.builder().queries(builder.refetchQueries).queryWatchers(this.refetchQueryNames).serverUrl(builder.serverUrl).httpCallFactory(builder.httpCallFactory).responseFieldMapperFactory(builder.responseFieldMapperFactory).scalarTypeAdapters(builder.scalarTypeAdapters).apolloStore(builder.mApolloStore).dispatcher(builder.dispatcher).logger(builder.logger).applicationInterceptors(builder.applicationInterceptors).callTracker(builder.tracker).build());
        this.sendOperationdIdentifiers = builder.sendOperationIdentifiers;
        this.interceptorChain = this.prepareInterceptorChain(this.operation);
        this.optimisticUpdates = builder.optimisticUpdates;
    }

    @Override
    public void enqueue(@Nullable GraphQLCall.Callback<T> responseCallback) {
        try {
            this.activate(Optional.fromNullable(responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onCanceledError(e);
            } else {
                this.logger.e((Throwable)e, "Operation: %s was canceled", new Object[]{this.operation().name().name()});
            }
            return;
        }
        ApolloInterceptor.InterceptorRequest request = ApolloInterceptor.InterceptorRequest.builder(this.operation).cacheHeaders(this.cacheHeaders).fetchFromCache(false).optimisticUpdates(this.optimisticUpdates).build();
        this.interceptorChain.proceedAsync(request, this.dispatcher, this.interceptorCallbackProxy());
    }

    @Override
    @Nonnull
    public RealAppSyncQueryWatcher<T> watcher() {
        return new RealAppSyncQueryWatcher(this.clone(), this.mApolloStore, this.logger, this.tracker);
    }

    @Override
    @Nonnull
    public RealAppSyncCall<T> httpCachePolicy(@Nonnull HttpCachePolicy.Policy httpCachePolicy) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().httpCachePolicy((HttpCachePolicy.Policy)Utils.checkNotNull((Object)httpCachePolicy, (Object)"httpCachePolicy == null")).build();
    }

    @Override
    @Nonnull
    public RealAppSyncCall<T> responseFetcher(@Nonnull ResponseFetcher fetcher) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().responseFetcher((ResponseFetcher)Utils.checkNotNull((Object)fetcher, (Object)"responseFetcher == null")).build();
    }

    @Override
    @Nonnull
    public RealAppSyncCall<T> cacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().cacheHeaders((CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null")).build();
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.state.set(CallState.CANCELED);
                try {
                    if (this.operation instanceof Mutation) {
                        this.cancelMutation();
                    }
                    this.interceptorChain.dispose();
                    if (!this.queryReFetcher.isPresent()) break;
                    ((QueryReFetcher)this.queryReFetcher.get()).cancel();
                    break;
                }
                finally {
                    this.tracker.unregisterCall(this);
                    this.originalCallback.set(null);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    private void cancelMutation() {
        Mutation mutation = (Mutation)this.operation;
        ApolloInterceptor appSyncOfflineMutationInterceptor = null;
        for (ApolloInterceptor interceptor : this.applicationInterceptors) {
            if (!"AppSyncOfflineMutationInterceptor".equalsIgnoreCase(interceptor.getClass().getSimpleName())) continue;
            appSyncOfflineMutationInterceptor = interceptor;
            break;
        }
        if (appSyncOfflineMutationInterceptor == null) {
            return;
        }
        Class[] cArg = new Class[]{Mutation.class};
        try {
            Method method = appSyncOfflineMutationInterceptor.getClass().getMethod("dispose", cArg);
            method.invoke((Object)appSyncOfflineMutationInterceptor, mutation);
        }
        catch (Exception e) {
            this.logger.w((Throwable)e, "unable to invoke dispose method", new Object[0]);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @Nonnull
    public RealAppSyncCall<T> clone() {
        return this.toBuilder().build();
    }

    @Override
    @Nonnull
    public AppSyncMutationCall<T> refetchQueries(OperationName ... operationNames) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().refetchQueryNames(Arrays.asList((Object[])Utils.checkNotNull((Object)operationNames, (Object)"operationNames == null"))).build();
    }

    @Override
    @Nonnull
    public AppSyncMutationCall<T> refetchQueries(Query ... queries) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().refetchQueries(Arrays.asList((Object[])Utils.checkNotNull((Object)queries, (Object)"queries == null"))).build();
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                Optional callback = RealAppSyncCall.this.responseCallback();
                if (!callback.isPresent()) {
                    RealAppSyncCall.this.logger.d("onResponse for operation: %s. No callback present.", new Object[]{RealAppSyncCall.this.operation().name().name()});
                    return;
                }
                ((GraphQLCall.Callback)callback.get()).onResponse((Response)response.parsedResponse.get());
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                Optional callback = RealAppSyncCall.this.terminate();
                if (!callback.isPresent()) {
                    RealAppSyncCall.this.logger.d((Throwable)e, "onFailure for operation: %s. No callback present.", new Object[]{RealAppSyncCall.this.operation().name().name()});
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    ((GraphQLCall.Callback)callback.get()).onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    ((GraphQLCall.Callback)callback.get()).onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    ((GraphQLCall.Callback)callback.get()).onNetworkError((ApolloNetworkException)e);
                } else {
                    ((GraphQLCall.Callback)callback.get()).onFailure(e);
                }
            }

            @Override
            public void onCompleted() {
                Optional callback = RealAppSyncCall.this.terminate();
                if (RealAppSyncCall.this.queryReFetcher.isPresent()) {
                    ((QueryReFetcher)RealAppSyncCall.this.queryReFetcher.get()).refetch();
                }
                if (!callback.isPresent()) {
                    RealAppSyncCall.this.logger.d("onCompleted for operation: %s. No callback present.", new Object[]{RealAppSyncCall.this.operation().name().name()});
                    return;
                }
                ((GraphQLCall.Callback)callback.get()).onStatusEvent(GraphQLCall.StatusEvent.COMPLETED);
            }

            @Override
            public void onFetch(final ApolloInterceptor.FetchSourceType sourceType) {
                RealAppSyncCall.this.responseCallback().apply(new Action<GraphQLCall.Callback<T>>(){

                    public void apply(@Nonnull GraphQLCall.Callback<T> callback) {
                        switch (sourceType) {
                            case CACHE: {
                                callback.onStatusEvent(GraphQLCall.StatusEvent.FETCH_CACHE);
                                break;
                            }
                            case NETWORK: {
                                callback.onStatusEvent(GraphQLCall.StatusEvent.FETCH_NETWORK);
                                break;
                            }
                        }
                    }
                });
            }
        };
    }

    public Builder<T> toBuilder() {
        return RealAppSyncCall.builder().operation(this.operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.httpCachePolicy).responseFieldMapperFactory(this.responseFieldMapperFactory).scalarTypeAdapters(this.scalarTypeAdapters).apolloStore(this.mApolloStore).cacheHeaders(this.cacheHeaders).responseFetcher(this.responseFetcher).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueryNames(this.refetchQueryNames).refetchQueries(this.refetchQueries).sendOperationIdentifiers(this.sendOperationdIdentifiers).optimisticUpdates(this.optimisticUpdates);
    }

    private synchronized void activate(Optional<GraphQLCall.Callback<T>> callback) throws ApolloCanceledException {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set((GraphQLCall.Callback<T>)callback.orNull());
                this.tracker.registerCall(this);
                callback.apply(new Action<GraphQLCall.Callback<T>>(){

                    public void apply(@Nonnull GraphQLCall.Callback<T> callback) {
                        callback.onStatusEvent(GraphQLCall.StatusEvent.SCHEDULED);
                    }
                });
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException("Call is cancelled.");
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    private synchronized Optional<GraphQLCall.Callback<T>> responseCallback() {
        switch (this.state.get()) {
            case ACTIVE: 
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.get());
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private synchronized Optional<GraphQLCall.Callback<T>> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterCall(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private ApolloInterceptorChain prepareInterceptorChain(Operation operation) {
        ArrayList<ApolloInterceptor> interceptors = new ArrayList<ApolloInterceptor>();
        HttpCachePolicy.Policy httpCachePolicy = operation instanceof Query ? this.httpCachePolicy : null;
        ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create(operation);
        interceptors.addAll(this.applicationInterceptors);
        interceptors.add(this.responseFetcher.provideInterceptor(this.logger));
        interceptors.add(new ApolloCacheInterceptor(this.mApolloStore, responseFieldMapper, this.dispatcher, this.logger));
        interceptors.add(new ApolloParseInterceptor(this.httpCache, this.mApolloStore.networkResponseNormalizer(), responseFieldMapper, this.scalarTypeAdapters, this.logger));
        interceptors.add(new AppSyncSubscriptionInterceptor(this.subscriptionManager, this.mApolloStore.networkResponseNormalizer()));
        interceptors.add(new ApolloServerInterceptor(this.serverUrl, this.httpCallFactory, httpCachePolicy, false, this.scalarTypeAdapters, this.logger, this.sendOperationdIdentifiers));
        return new RealApolloInterceptorChain(interceptors);
    }

    public static final class Builder<T> {
        Operation operation;
        HttpUrl serverUrl;
        Call.Factory httpCallFactory;
        HttpCache httpCache;
        HttpCachePolicy.Policy httpCachePolicy;
        ResponseFieldMapperFactory responseFieldMapperFactory;
        ScalarTypeAdapters scalarTypeAdapters;
        ApolloStore mApolloStore;
        ResponseFetcher responseFetcher;
        CacheHeaders cacheHeaders;
        ApolloInterceptorChain interceptorChain;
        Executor dispatcher;
        ApolloLogger logger;
        List<ApolloInterceptor> applicationInterceptors;
        List<OperationName> refetchQueryNames = Collections.emptyList();
        List<Query> refetchQueries = Collections.emptyList();
        ApolloCallTracker tracker;
        boolean sendOperationIdentifiers;
        Optional<Operation.Data> optimisticUpdates = Optional.absent();
        SubscriptionManager subscriptionManager;

        public Builder<T> operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder<T> serverUrl(HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder<T> httpCallFactory(Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        public Builder<T> httpCache(HttpCache httpCache) {
            this.httpCache = httpCache;
            return this;
        }

        public Builder<T> httpCachePolicy(HttpCachePolicy.Policy httpCachePolicy) {
            this.httpCachePolicy = httpCachePolicy;
            return this;
        }

        public Builder<T> responseFieldMapperFactory(ResponseFieldMapperFactory responseFieldMapperFactory) {
            this.responseFieldMapperFactory = responseFieldMapperFactory;
            return this;
        }

        public Builder<T> scalarTypeAdapters(ScalarTypeAdapters scalarTypeAdapters) {
            this.scalarTypeAdapters = scalarTypeAdapters;
            return this;
        }

        public Builder<T> apolloStore(ApolloStore apolloStore) {
            this.mApolloStore = apolloStore;
            return this;
        }

        public Builder<T> responseFetcher(ResponseFetcher responseFetcher) {
            this.responseFetcher = responseFetcher;
            return this;
        }

        public Builder<T> cacheHeaders(CacheHeaders cacheHeaders) {
            this.cacheHeaders = cacheHeaders;
            return this;
        }

        public Builder<T> dispatcher(Executor dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder<T> logger(ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder<T> tracker(ApolloCallTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        public Builder<T> applicationInterceptors(List<ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        public Builder<T> refetchQueryNames(List<OperationName> refetchQueryNames) {
            this.refetchQueryNames = refetchQueryNames != null ? new ArrayList<OperationName>(refetchQueryNames) : Collections.emptyList();
            return this;
        }

        public Builder<T> refetchQueries(List<Query> refetchQueries) {
            this.refetchQueries = refetchQueries != null ? new ArrayList<Query>(refetchQueries) : Collections.emptyList();
            return this;
        }

        public Builder<T> sendOperationIdentifiers(boolean sendOperationIdentifiers) {
            this.sendOperationIdentifiers = sendOperationIdentifiers;
            return this;
        }

        public Builder<T> optimisticUpdates(Optional<Operation.Data> optimisticUpdates) {
            this.optimisticUpdates = optimisticUpdates;
            return this;
        }

        public Builder<T> subscriptionManager(SubscriptionManager subscriptionManager) {
            this.subscriptionManager = subscriptionManager;
            return this;
        }

        Builder() {
        }

        public RealAppSyncCall<T> build() {
            return new RealAppSyncCall(this);
        }
    }
}

