/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class RealApolloInterceptorChain
implements ApolloInterceptorChain {
    private final List<ApolloInterceptor> interceptors;
    private final int interceptorIndex;

    public RealApolloInterceptorChain(@Nonnull List<ApolloInterceptor> interceptors) {
        this(interceptors, 0);
    }

    private RealApolloInterceptorChain(List<ApolloInterceptor> interceptors, int interceptorIndex) {
        if (interceptorIndex > interceptors.size()) {
            throw new IllegalArgumentException();
        }
        this.interceptors = new ArrayList<ApolloInterceptor>((Collection)Utils.checkNotNull(interceptors, (Object)"interceptors == null"));
        this.interceptorIndex = interceptorIndex;
    }

    @Override
    public void proceedAsync(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull Executor dispatcher, @Nonnull ApolloInterceptor.CallBack callBack) {
        if (this.interceptorIndex >= this.interceptors.size()) {
            throw new IllegalStateException();
        }
        this.interceptors.get(this.interceptorIndex).interceptAsync(request, new RealApolloInterceptorChain(this.interceptors, this.interceptorIndex + 1), dispatcher, callBack);
    }

    @Override
    public void dispose() {
        for (ApolloInterceptor interceptor : this.interceptors) {
            interceptor.dispose();
        }
    }
}

