/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class SortedInputFieldMapWriter
implements InputFieldWriter {
    final Comparator<String> fieldNameComparator;
    final Map<String, Object> buffer;

    public SortedInputFieldMapWriter(@Nonnull Comparator<String> fieldNameComparator) {
        this.fieldNameComparator = (Comparator)Utils.checkNotNull(fieldNameComparator, (Object)"fieldNameComparator == null");
        this.buffer = new TreeMap<String, Object>(fieldNameComparator);
    }

    public Map<String, Object> map() {
        return Collections.unmodifiableMap(this.buffer);
    }

    public void writeString(@Nonnull String fieldName, String value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeInt(@Nonnull String fieldName, Integer value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeLong(@Nonnull String fieldName, Long value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeDouble(@Nonnull String fieldName, Double value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeBoolean(@Nonnull String fieldName, Boolean value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeCustom(@Nonnull String fieldName, ScalarType scalarType, Object value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeObject(@Nonnull String fieldName, InputFieldMarshaller marshaller) throws IOException {
        if (marshaller == null) {
            this.buffer.put(fieldName, null);
        } else {
            SortedInputFieldMapWriter nestedWriter = new SortedInputFieldMapWriter(this.fieldNameComparator);
            marshaller.marshal((InputFieldWriter)nestedWriter);
            this.buffer.put(fieldName, nestedWriter.buffer);
        }
    }

    public void writeList(@Nonnull String fieldName, InputFieldWriter.ListWriter listWriter) throws IOException {
        if (listWriter == null) {
            this.buffer.put(fieldName, null);
        } else {
            ListItemWriter listItemWriter = new ListItemWriter(this.fieldNameComparator);
            listWriter.write((InputFieldWriter.ListItemWriter)listItemWriter);
            this.buffer.put(fieldName, listItemWriter.list);
        }
    }

    private static class ListItemWriter
    implements InputFieldWriter.ListItemWriter {
        final Comparator<String> fieldNameComparator;
        final List list = new ArrayList();

        ListItemWriter(Comparator<String> fieldNameComparator) {
            this.fieldNameComparator = fieldNameComparator;
        }

        public void writeString(String value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeInt(Integer value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeLong(Long value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeDouble(Double value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeBoolean(Boolean value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeCustom(ScalarType scalarType, Object value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeObject(InputFieldMarshaller marshaller) throws IOException {
            if (marshaller != null) {
                SortedInputFieldMapWriter nestedWriter = new SortedInputFieldMapWriter(this.fieldNameComparator);
                marshaller.marshal((InputFieldWriter)nestedWriter);
                this.list.add(nestedWriter.buffer);
            }
        }
    }
}

