/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.internal.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import okio.Buffer;
import okio.BufferedSink;

public final class Utils {
    public static String toJsonString(@Nonnull Object data) throws IOException {
        com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)data, (Object)"data == null");
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        Utils.writeToJson(data, jsonWriter);
        jsonWriter.close();
        return buffer.readUtf8();
    }

    public static void writeToJson(Object value, JsonWriter jsonWriter) throws IOException {
        if (value == null) {
            jsonWriter.nullValue();
        } else if (value instanceof Map) {
            jsonWriter.beginObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String key = entry.getKey().toString();
                jsonWriter.name(key);
                Utils.writeToJson(entry.getValue(), jsonWriter);
            }
            jsonWriter.endObject();
        } else if (value instanceof List) {
            jsonWriter.beginArray();
            for (Object item : (List)value) {
                Utils.writeToJson(item, jsonWriter);
            }
            jsonWriter.endArray();
        } else if (value instanceof Boolean) {
            jsonWriter.value((Boolean)value);
        } else if (value instanceof Number) {
            jsonWriter.value((Number)value);
        } else {
            jsonWriter.value(value.toString());
        }
    }

    private Utils() {
    }
}

