/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.util.VersionInfoUtils;
import java.util.Date;
import java.util.Map;

public class CognitoCachingCredentialsProvider
extends CognitoCredentialsProvider {
    private final String DEFAULT_SHAREDPREFERENCES_NAME = "com.amazonaws.android.auth";
    private static final String USER_AGENT = CognitoCachingCredentialsProvider.class.getName() + "/" + VersionInfoUtils.getVersion();
    private final SharedPreferences prefs;
    private String identityId;
    private static final String ID_KEY = "identityId";
    private static final String AK_KEY = "accessKey";
    private static final String SK_KEY = "secretKey";
    private static final String ST_KEY = "sessionToken";
    private static final String EXP_KEY = "expirationDate";
    boolean needIdentityRefresh = false;
    private static final String TAG = "CognitoCachingCredentialsProvider";
    private final IdentityChangedListener listener = new IdentityChangedListener(){

        @Override
        public void identityChanged(String string, String string2) {
            Log.d((String)CognitoCachingCredentialsProvider.TAG, (String)"Identity id is changed");
            CognitoCachingCredentialsProvider.this.saveIdentityId(string2);
        }
    };

    public CognitoCachingCredentialsProvider(Context context, String string, String string2, String string3, String string4, Regions regions) {
        this(context, string, string2, string3, string4, regions, new ClientConfiguration());
    }

    public CognitoCachingCredentialsProvider(Context context, String string, String string2, String string3, String string4, Regions regions, ClientConfiguration clientConfiguration) {
        super(string, string2, string3, string4, regions, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.registerIdentityChangedListener(this.listener);
    }

    public CognitoCachingCredentialsProvider(Context context, String string, String string2, String string3, String string4, AmazonCognitoIdentityClient amazonCognitoIdentityClient, AWSSecurityTokenService aWSSecurityTokenService) {
        this(context, new AWSBasicCognitoIdentityProvider(string, string2, amazonCognitoIdentityClient), string3, string4, aWSSecurityTokenService);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider aWSCognitoIdentityProvider, String string, String string2, AWSSecurityTokenService aWSSecurityTokenService) {
        super(aWSCognitoIdentityProvider, string, string2, aWSSecurityTokenService);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.registerIdentityChangedListener(this.listener);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider aWSCognitoIdentityProvider, String string, String string2) {
        super(aWSCognitoIdentityProvider, string, string2, new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), new ClientConfiguration()));
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.registerIdentityChangedListener(this.listener);
    }

    @Override
    public String getIdentityId() {
        if (this.needIdentityRefresh) {
            this.needIdentityRefresh = false;
            this.refresh();
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        this.identityId = this.getCachedIdentityId();
        if (this.identityId == null) {
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        return this.identityId;
    }

    @Override
    public synchronized AWSSessionCredentials getCredentials() {
        if (this.sessionCredentials == null) {
            this.loadCachedCredentials();
        }
        if (!this.needsNewSession()) {
            return this.sessionCredentials;
        }
        try {
            super.getCredentials();
        }
        catch (NotAuthorizedException notAuthorizedException) {
            Log.e((String)TAG, (String)"Failure to get credentials", (Throwable)notAuthorizedException);
            if (this.getLogins() != null) {
                this.clear();
                super.getCredentials();
            }
            throw notAuthorizedException;
        }
        this.saveCredentials(this.sessionCredentials, this.getSessionCredentitalsExpiration().getTime());
        return this.sessionCredentials;
    }

    @Override
    public void setLogins(Map<String, String> map) {
        super.setLogins(map);
        this.needIdentityRefresh = true;
        this.prefs.edit().remove(AK_KEY).remove(SK_KEY).remove(ST_KEY).remove(EXP_KEY).apply();
    }

    @Override
    public void clear() {
        super.clear();
        this.prefs.edit().clear().apply();
    }

    public String getCachedIdentityId() {
        String string = this.prefs.getString(ID_KEY, null);
        if (string != null && this.identityId == null) {
            super.setIdentityId(string);
        }
        return string;
    }

    private void loadCachedCredentials() {
        Log.d((String)TAG, (String)"Loading credentials from SharedPreferences");
        this.sessionCredentialsExpiration = new Date(this.prefs.getLong(EXP_KEY, 0L));
        boolean bl = this.prefs.contains(AK_KEY);
        boolean bl2 = this.prefs.contains(SK_KEY);
        boolean bl3 = this.prefs.contains(ST_KEY);
        if (!(bl && bl2 && bl3)) {
            Log.d((String)TAG, (String)"No valid credentials found in SharedPreferences");
            this.sessionCredentialsExpiration = null;
            return;
        }
        String string = this.prefs.getString(AK_KEY, null);
        String string2 = this.prefs.getString(SK_KEY, null);
        String string3 = this.prefs.getString(ST_KEY, null);
        this.sessionCredentials = new BasicSessionCredentials(string, string2, string3);
    }

    private void saveCredentials(AWSSessionCredentials aWSSessionCredentials, long l) {
        Log.d((String)TAG, (String)"Saving credentials to SharedPreferences");
        if (aWSSessionCredentials != null) {
            this.prefs.edit().putString(AK_KEY, aWSSessionCredentials.getAWSAccessKeyId()).putString(SK_KEY, aWSSessionCredentials.getAWSSecretKey()).putString(ST_KEY, aWSSessionCredentials.getSessionToken()).putLong(EXP_KEY, l).apply();
        }
    }

    private void saveIdentityId(String string) {
        Log.d((String)TAG, (String)"Saving identity id to SharedPreferences");
        this.identityId = string;
        this.prefs.edit().putString(ID_KEY, string).apply();
    }

    @Override
    public Date getSessionCredentitalsExpiration() {
        return super.getSessionCredentitalsExpiration();
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }
}

