/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CognitoCredentialsProvider
implements AWSCredentialsProvider {
    private final AWSCognitoIdentityProvider identityProvider;
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    public static final int DEFAULT_THRESHOLD_SECONDS = 500;
    protected AWSSessionCredentials sessionCredentials;
    protected Date sessionCredentialsExpiration;
    protected String token;
    protected AWSSecurityTokenService securityTokenService;
    protected int sessionDuration;
    protected int refreshThreshold;
    protected String unauthRoleArn;
    protected String authRoleArn;

    public CognitoCredentialsProvider(String string, String string2, String string3, String string4, Regions regions) {
        this(string, string2, string3, string4, regions, new ClientConfiguration());
    }

    public CognitoCredentialsProvider(String string, String string2, String string3, String string4, Regions regions, ClientConfiguration clientConfiguration) {
        AmazonCognitoIdentityClient amazonCognitoIdentityClient = new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration);
        amazonCognitoIdentityClient.setRegion(Region.getRegion(regions));
        this.identityProvider = new AWSBasicCognitoIdentityProvider(string, string2, amazonCognitoIdentityClient);
        this.unauthRoleArn = string3;
        this.authRoleArn = string4;
        this.securityTokenService = new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), clientConfiguration);
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    public CognitoCredentialsProvider(String string, String string2, String string3, String string4, AmazonCognitoIdentityClient amazonCognitoIdentityClient, AWSSecurityTokenService aWSSecurityTokenService) {
        this(new AWSBasicCognitoIdentityProvider(string, string2, amazonCognitoIdentityClient), string3, string4, aWSSecurityTokenService);
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider aWSCognitoIdentityProvider, String string, String string2, AWSSecurityTokenService aWSSecurityTokenService) {
        this.identityProvider = aWSCognitoIdentityProvider;
        this.unauthRoleArn = string;
        this.authRoleArn = string2;
        this.securityTokenService = aWSSecurityTokenService;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider aWSCognitoIdentityProvider, String string, String string2) {
        this.identityProvider = aWSCognitoIdentityProvider;
        this.unauthRoleArn = string;
        this.authRoleArn = string2;
        this.securityTokenService = new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), new ClientConfiguration());
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    public String getIdentityId() {
        return this.identityProvider.getIdentityId();
    }

    public String getToken() {
        return this.identityProvider.getToken();
    }

    public AWSIdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setSessionCredentialsExpiration(Date date) {
        this.sessionCredentialsExpiration = date;
    }

    public Date getSessionCredentitalsExpiration() {
        return this.sessionCredentialsExpiration;
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    public void setSessionDuration(int n) {
        this.sessionDuration = n;
    }

    public CognitoCredentialsProvider withSessionDuration(int n) {
        this.setSessionDuration(n);
        return this;
    }

    public int getSessionDuration() {
        return this.sessionDuration;
    }

    public void setRefreshThreshold(int n) {
        this.refreshThreshold = n;
    }

    public CognitoCredentialsProvider withRefreshThreshold(int n) {
        this.setRefreshThreshold(n);
        return this;
    }

    public int getRefreshThreshold() {
        return this.refreshThreshold;
    }

    protected void setIdentityId(String string) {
        this.identityProvider.identityChanged(string);
    }

    public void setLogins(Map<String, String> map) {
        this.identityProvider.setLogins(map);
        this.sessionCredentials = null;
    }

    public AWSCredentialsProvider withLogins(Map<String, String> map) {
        this.setLogins(map);
        return this;
    }

    public Map<String, String> getLogins() {
        return this.identityProvider.getLogins();
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    public void clear() {
        this.sessionCredentials = null;
        this.sessionCredentialsExpiration = null;
        this.identityProvider.clearListeners();
        this.setIdentityId(null);
        this.identityProvider.setLogins(new HashMap<String, String>());
    }

    protected void startSession() {
        this.token = this.identityProvider.refresh();
        String string = this.unauthRoleArn;
        Map<String, String> map = this.identityProvider.getLogins();
        if (map != null && map.size() > 0) {
            string = this.authRoleArn;
        }
        AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest = new AssumeRoleWithWebIdentityRequest().withWebIdentityToken(this.token).withRoleArn(string).withRoleSessionName("ProviderSession").withDurationSeconds(this.sessionDuration);
        this.appendUserAgent(assumeRoleWithWebIdentityRequest, this.getUserAgent());
        AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentityResult = this.securityTokenService.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest);
        Credentials credentials = assumeRoleWithWebIdentityResult.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.sessionCredentialsExpiration = credentials.getExpiration();
    }

    protected boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long l = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
        long l2 = this.sessionCredentialsExpiration.getTime() - l;
        return l2 < (long)(this.refreshThreshold * 1000);
    }

    private void appendUserAgent(AmazonWebServiceRequest amazonWebServiceRequest, String string) {
        amazonWebServiceRequest.getRequestClientOptions().appendUserAgent(string);
    }

    protected String getUserAgent() {
        return "";
    }

    public void registerIdentityChangedListener(IdentityChangedListener identityChangedListener) {
        this.identityProvider.registerIdentityChangedListener(identityChangedListener);
    }

    public void unregisterIdentityChangedListener(IdentityChangedListener identityChangedListener) {
        this.identityProvider.unregisterIdentityChangedListener(identityChangedListener);
    }
}

