/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.STSSessionCredentialsProvider;
import java.util.HashMap;
import java.util.Map;

public class SessionCredentialsProviderFactory {
    private static final Map<Key, STSSessionCredentialsProvider> cache = new HashMap<Key, STSSessionCredentialsProvider>();

    public static synchronized STSSessionCredentialsProvider getSessionCredentialsProvider(AWSCredentials aWSCredentials, String string, ClientConfiguration clientConfiguration) {
        Key key = new Key(aWSCredentials.getAWSAccessKeyId(), string);
        if (!cache.containsKey(key)) {
            cache.put(key, new STSSessionCredentialsProvider(aWSCredentials, clientConfiguration));
        }
        return cache.get(key);
    }

    private static final class Key {
        private final String awsAccessKeyId;
        private final String serviceEndpoint;

        public Key(String string, String string2) {
            this.awsAccessKeyId = string;
            this.serviceEndpoint = string2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.awsAccessKeyId == null ? 0 : this.awsAccessKeyId.hashCode());
            n = 31 * n + (this.serviceEndpoint == null ? 0 : this.serviceEndpoint.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            if (this.awsAccessKeyId == null ? key.awsAccessKeyId != null : !this.awsAccessKeyId.equals(key.awsAccessKeyId)) {
                return false;
            }
            return !(this.serviceEndpoint == null ? key.serviceEndpoint != null : !this.serviceEndpoint.equals(key.serviceEndpoint));
        }
    }
}

