/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy;

public class Principal {
    public static final Principal AllUsers = new Principal("AWS", "*");
    public static final Principal AllServices = new Principal("Service", "*");
    public static final Principal AllWebProviders = new Principal("Federated", "*");
    public static final Principal All = new Principal("*", "*");
    private final String id;
    private final String provider;

    public Principal(Services services) {
        if (services == null) {
            throw new IllegalArgumentException("Null AWS service name specified");
        }
        this.id = services.getServiceId();
        this.provider = "Service";
    }

    public Principal(String string, String string2) {
        this.provider = string;
        if (string.equals("AWS")) {
            string2 = string2.replaceAll("-", "");
        }
        this.id = string2;
    }

    public Principal(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null AWS account ID specified");
        }
        this.id = string.replaceAll("-", "");
        this.provider = "AWS";
    }

    public Principal(WebIdentityProviders webIdentityProviders) {
        if (webIdentityProviders == null) {
            throw new IllegalArgumentException("Null web identity provider specified");
        }
        this.id = webIdentityProviders.getWebIdentityProvider();
        this.provider = "Federated";
    }

    public String getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.provider.hashCode();
        n = 31 * n + this.id.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Principal)) {
            return false;
        }
        Principal principal = (Principal)object;
        return this.getProvider().equals(principal.getProvider()) && this.getId().equals(principal.getId());
    }

    public static enum WebIdentityProviders {
        Facebook("graph.facebook.com"),
        Google("accounts.google.com"),
        Amazon("www.amazon.com"),
        AllProviders("*");

        private String webIdentityProvider;

        private WebIdentityProviders(String string2) {
            this.webIdentityProvider = string2;
        }

        public String getWebIdentityProvider() {
            return this.webIdentityProvider;
        }

        public static WebIdentityProviders fromString(String string) {
            if (string != null) {
                for (WebIdentityProviders webIdentityProviders : WebIdentityProviders.values()) {
                    if (!webIdentityProviders.getWebIdentityProvider().equalsIgnoreCase(string)) continue;
                    return webIdentityProviders;
                }
            }
            return null;
        }
    }

    public static enum Services {
        AWSDataPipeline("datapipeline.amazonaws.com"),
        AmazonElasticTranscoder("elastictranscoder.amazonaws.com"),
        AmazonEC2("ec2.amazonaws.com"),
        AWSOpsWorks("opsworks.amazonaws.com"),
        AWSCloudHSM("cloudhsm.amazonaws.com"),
        AllServices("*");

        private String serviceId;

        private Services(String string2) {
            this.serviceId = string2;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public static Services fromString(String string) {
            if (string != null) {
                for (Services services : Services.values()) {
                    if (!services.getServiceId().equalsIgnoreCase(string)) continue;
                    return services;
                }
            }
            return null;
        }
    }
}

