/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser.std;

import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.io.IOException;
import java.io.Serializable;

public class StdValueInstantiator
extends ValueInstantiator
implements Serializable {
    protected final String _valueTypeDesc;
    protected final boolean _cfgEmptyStringsAsObjects;
    protected AnnotatedWithParams _defaultCreator;
    protected AnnotatedWithParams _withArgsCreator;
    protected CreatorProperty[] _constructorArguments;
    protected JavaType _delegateType;
    protected AnnotatedWithParams _delegateCreator;
    protected CreatorProperty[] _delegateArguments;
    protected AnnotatedWithParams _fromStringCreator;
    protected AnnotatedWithParams _fromIntCreator;
    protected AnnotatedWithParams _fromLongCreator;
    protected AnnotatedWithParams _fromDoubleCreator;
    protected AnnotatedWithParams _fromBooleanCreator;

    public StdValueInstantiator(DeserializationConfig config, JavaType valueType) {
        this._cfgEmptyStringsAsObjects = config == null ? false : config.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this._valueTypeDesc = valueType == null ? "UNKNOWN TYPE" : valueType.toString();
    }

    public void configureFromObjectSettings(AnnotatedWithParams defaultCreator, AnnotatedWithParams delegateCreator, JavaType delegateType, CreatorProperty[] delegateArgs, AnnotatedWithParams withArgsCreator, CreatorProperty[] constructorArgs) {
        this._defaultCreator = defaultCreator;
        this._delegateCreator = delegateCreator;
        this._delegateType = delegateType;
        this._delegateArguments = delegateArgs;
        this._withArgsCreator = withArgsCreator;
        this._constructorArguments = constructorArgs;
    }

    public void configureFromStringCreator(AnnotatedWithParams creator) {
        this._fromStringCreator = creator;
    }

    public void configureFromIntCreator(AnnotatedWithParams creator) {
        this._fromIntCreator = creator;
    }

    public void configureFromLongCreator(AnnotatedWithParams creator) {
        this._fromLongCreator = creator;
    }

    public void configureFromDoubleCreator(AnnotatedWithParams creator) {
        this._fromDoubleCreator = creator;
    }

    public void configureFromBooleanCreator(AnnotatedWithParams creator) {
        this._fromBooleanCreator = creator;
    }

    @Override
    public String getValueTypeDesc() {
        return this._valueTypeDesc;
    }

    @Override
    public boolean canCreateFromString() {
        return this._fromStringCreator != null;
    }

    @Override
    public boolean canCreateFromInt() {
        return this._fromIntCreator != null;
    }

    @Override
    public boolean canCreateFromLong() {
        return this._fromLongCreator != null;
    }

    @Override
    public boolean canCreateFromDouble() {
        return this._fromDoubleCreator != null;
    }

    @Override
    public boolean canCreateFromBoolean() {
        return this._fromBooleanCreator != null;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return this._defaultCreator != null;
    }

    @Override
    public boolean canCreateUsingDelegate() {
        return this._delegateType != null;
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return this._withArgsCreator != null;
    }

    @Override
    public JavaType getDelegateType(DeserializationConfig config) {
        return this._delegateType;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        return this._constructorArguments;
    }

    @Override
    public Object createUsingDefault(DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._defaultCreator == null) {
            throw new IllegalStateException("No default constructor for " + this.getValueTypeDesc());
        }
        try {
            return this._defaultCreator.call();
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException, JsonProcessingException {
        if (this._withArgsCreator == null) {
            throw new IllegalStateException("No with-args constructor for " + this.getValueTypeDesc());
        }
        try {
            return this._withArgsCreator.call(args);
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws IOException, JsonProcessingException {
        if (this._delegateCreator == null) {
            throw new IllegalStateException("No delegate constructor for " + this.getValueTypeDesc());
        }
        try {
            if (this._delegateArguments == null) {
                return this._delegateCreator.call1(delegate);
            }
            int len = this._delegateArguments.length;
            Object[] args = new Object[len];
            for (int i = 0; i < len; ++i) {
                CreatorProperty prop = this._delegateArguments[i];
                args[i] = prop == null ? delegate : ctxt.findInjectableValue(prop.getInjectableValueId(), prop, null);
            }
            return this._delegateCreator.call(args);
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public Object createFromString(DeserializationContext ctxt, String value) throws IOException, JsonProcessingException {
        if (this._fromStringCreator != null) {
            try {
                return this._fromStringCreator.call1(value);
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
            catch (ExceptionInInitializerError e) {
                throw this.wrapException(e);
            }
        }
        return this._createFromStringFallbacks(ctxt, value);
    }

    @Override
    public Object createFromInt(DeserializationContext ctxt, int value) throws IOException, JsonProcessingException {
        try {
            if (this._fromIntCreator != null) {
                return this._fromIntCreator.call1(value);
            }
            if (this._fromLongCreator != null) {
                return this._fromLongCreator.call1(value);
            }
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Integral number; no single-int-arg constructor/factory method");
    }

    @Override
    public Object createFromLong(DeserializationContext ctxt, long value) throws IOException, JsonProcessingException {
        try {
            if (this._fromLongCreator != null) {
                return this._fromLongCreator.call1(value);
            }
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Long integral number; no single-long-arg constructor/factory method");
    }

    @Override
    public Object createFromDouble(DeserializationContext ctxt, double value) throws IOException, JsonProcessingException {
        try {
            if (this._fromDoubleCreator != null) {
                return this._fromDoubleCreator.call1(value);
            }
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Floating-point number; no one-double/Double-arg constructor/factory method");
    }

    @Override
    public Object createFromBoolean(DeserializationContext ctxt, boolean value) throws IOException, JsonProcessingException {
        try {
            if (this._fromBooleanCreator != null) {
                return this._fromBooleanCreator.call1(value);
            }
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw this.wrapException(e);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Boolean value; no single-boolean/Boolean-arg constructor/factory method");
    }

    @Override
    public AnnotatedWithParams getDelegateCreator() {
        return this._delegateCreator;
    }

    @Override
    public AnnotatedWithParams getDefaultCreator() {
        return this._defaultCreator;
    }

    protected Object _createFromStringFallbacks(DeserializationContext deserializationContext, String string) throws IOException, JsonProcessingException {
        if (this._fromBooleanCreator != null) {
            String string2 = string.trim();
            if ("true".equals(string2)) {
                return this.createFromBoolean(deserializationContext, true);
            }
            if ("false".equals(string2)) {
                return this.createFromBoolean(deserializationContext, false);
            }
        }
        if (this._cfgEmptyStringsAsObjects && string.length() == 0) {
            return null;
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from String value; no single-String constructor/factory method");
    }

    protected JsonMappingException wrapException(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof JsonMappingException) {
            return (JsonMappingException)throwable;
        }
        return new JsonMappingException("Instantiation of " + this.getValueTypeDesc() + " value failed: " + throwable.getMessage(), throwable);
    }
}

